package com.digiwin.mobile.mobileuibot.common.calculate;

import java.util.UUID;

/**
 * <p>功能描述：</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: UuidUtil
 * @Author: Zaregoto
 * @Date: 2021/6/16 22:44
 */
public final class UUIDUtil {

    /**
     * 得到UUID的128位中的最高有效64位
     *
     * @return
     */
    public static String getSignificantBitsUuid() {
        while (true) {
            long uuid = UUID.randomUUID().getMostSignificantBits();
            if (uuid > 0) {
                return uuid + "";
            }
        }
    }

    /**
     * 得到UUID
     *
     * @return
     */
    public static String getUuid() {
        return UUID.randomUUID().toString();
    }

    /**
     * 生成一个纯数字型的UUID。
     */
    public static Long getLongUuid() {
        return Math.abs(UUID.randomUUID().getMostSignificantBits());
    }
}
