package com.digiwin.mobile.mobileuibot.common.converter;

import org.springframework.core.convert.converter.Converter;
import org.springframework.data.convert.ReadingConverter;

import java.sql.Timestamp;
import java.util.Date;

/**
 * @FileName: TimestampToDateConverter
 * @Author: Zaregoto
 * @Description:
 * @Date: Created On 2019/5/10 15:43
 */
@ReadingConverter
public class TimestampToDateConverter implements Converter<Timestamp, Date> {

    /**
     * 用于默认初始化的构造函数，可以不添加逻辑
     */
    public TimestampToDateConverter() {
        // Do nothing because this is init
    }

    @Override
    public Date convert(Timestamp timestamp) {
        return timestamp != null ? new Date(timestamp.getTime()) : null;
    }
}
