package com.digiwin.mobile.mobileuibot.common.crypto.aes;

import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;

/**
 * AES加密工具类
 *
 * @author zhangjj
 * @date 2022/9/16 10:33
 */
public class AESUtil {

    /**
     * 生成密钥算法
     *
     * @param seed
     * @return
     * @throws Exception
     */
    public static String generateKey(String seed) throws Exception {
        // 获取秘钥生成器
        KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
        // 通过种子初始化
        SecureRandom secureRandom = new SecureRandom();
        secureRandom.setSeed(seed.getBytes(StandardCharsets.UTF_8));
        keyGenerator.init(192, secureRandom);
        // 生成秘钥并返回
        SecretKey secretKey = keyGenerator.generateKey();
        byte[] enCodeFormat = secretKey.getEncoded();
        return byte2hex(enCodeFormat);
    }

    /**
     * 加密算法
     *
     * @param secretKey
     * @param content
     * @return
     * @throws Exception
     */
    public static String encrypt(String secretKey, String content) throws Exception {
        // 秘钥
        byte[] enCodeFormat = hex2byte(secretKey);
        // 创建AES秘钥
        SecretKeySpec key = new SecretKeySpec(enCodeFormat, "AES");
        // 创建密码器
        Cipher cipher = Cipher.getInstance("AES");
        // 初始化加密器
        cipher.init(Cipher.ENCRYPT_MODE, key);
        // 加密
        byte[] bytes = cipher.doFinal(content.getBytes(StandardCharsets.UTF_8));

        return byte2hex(bytes);
    }

    /**
     * 解密算法
     *
     * @param secretKey
     * @param content
     * @return
     * @throws Exception
     */
    public static String decrypt(String secretKey, String content) throws IllegalArgumentException {
        try {
            if (content == null || content.length() < 2) {
                return content;
            }
            // 秘钥
            byte[] enCodeFormat = hex2byte(secretKey);
            // 创建AES秘钥
            SecretKeySpec key = new SecretKeySpec(enCodeFormat, "AES");
            // 创建密码器
            Cipher cipher = Cipher.getInstance("AES");
            // 初始化解密器
            cipher.init(Cipher.DECRYPT_MODE, key);
            // 解密
            byte[] result = cipher.doFinal(hex2byte(content));
            return new String(result, StandardCharsets.UTF_8);
        }catch (Exception e){
            throw new IllegalArgumentException("解密失败：" + e.getMessage());
        }
    }

    private static String byte2hex(byte[] b) {
        StringBuilder sb = new StringBuilder(b.length * 2);
        String tmp = "";
        for (byte aB : b) {
            // 整数转成十六进制表示
            tmp = (Integer.toHexString(aB & 0XFF));
            if (tmp.length() == 1) {
                sb.append("0");
            }
            sb.append(tmp);
        }
        return sb.toString().toUpperCase(); // 转成大写
    }

    private static byte[] hex2byte(String inputString) {
        if (inputString == null || inputString.length() < 2) {
            return new byte[0];
        }
        inputString = inputString.toLowerCase();
        int l = inputString.length() / 2;
        byte[] result = new byte[l];
        for (int i = 0; i < l; ++i) {
            String tmp = inputString.substring(2 * i, 2 * i + 2);
            result[i] = (byte) (Integer.parseInt(tmp, 16) & 0xFF);
        }
        return result;
    }

    public static void main(String[] args) throws Exception {
        System.out.println(decrypt("550F743242C486791EDBDEDEE3498BAA", "4E7865BC5C58A9367227497724343A11CDBB79744C4C7F6D613793133F94CA29"));
        System.out.println(decrypt("550F743242C486791EDBDEDEE3498BAA", ""));
        System.out.println(encrypt("550F743242C486791EDBDEDEE3498BAA", "wangjwc@digiwin.com"));
    }
}
