package com.digiwin.mobile.mobileuibot.common.crypto.aes;

import org.apache.commons.codec.binary.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;

/**
 * 功能: IAM登录相关 AES 加解密工具类
 *
 * @author: wjw
 * @date: created at 2023/5/9
 */
public class AESUtils {
    private static final Logger logger = LoggerFactory.getLogger(AESUtils.class);
    private static final String IV_STRING = "ghUb#er57HBh(u%g";
    private static final String CHARSET = "UTF-8";
    // 代理模式登录 userId AES 加密 key
    public static final String AESKEY = "tnega!niwigid";

    private static final String ALGORITHM_STR = "AES/ECB/PKCS5Padding";
    private static final String ENCRYPT_BY_BASE_STR = "AES/CBC/PKCS5Padding";

    /**
     * 默认构造器，禁止实例化此类
     */
    private AESUtils(){}

    /**
     * 加密
     * 加密失败返回原文 2021-7-21
     *
     * @param src    加密字段
     * @param aesKey aesKey
     * @return 密文 .toUpperCase() 和MySQL保持一致
     */
    public static String aesEncryptByBase64(String src, String aesKey) {
        try {
            //生成和mysql一致的加密数据
            SecretKeySpec key = new SecretKeySpec(aesKey.getBytes(StandardCharsets.UTF_8), "AES");

            byte[] initParam = IV_STRING.getBytes(StandardCharsets.UTF_8);
            IvParameterSpec ivParameterSpec = new IvParameterSpec(initParam);
            Cipher cipher = Cipher.getInstance(ENCRYPT_BY_BASE_STR);
            cipher.init(Cipher.ENCRYPT_MODE, key, ivParameterSpec);

            byte[] cleartext = src.getBytes(StandardCharsets.UTF_8);
            byte[] ciphertextBytes = cipher.doFinal(cleartext);
            Base64.Encoder encoder = Base64.getEncoder();
            return encoder.encodeToString(ciphertextBytes);
        } catch (Exception ex) {
            logger.error("AES加密失败[{}]", src);
            return src;
        }

    }

    public static String aesEncrypt(String src, String aesKey) {
        try {
            //生成和mysql一致的加密数据
            SecretKeySpec key = generate(aesKey);
            Cipher cipher = Cipher.getInstance(ALGORITHM_STR);
            cipher.init(Cipher.ENCRYPT_MODE, key);

            byte[] cleartext = src.getBytes(StandardCharsets.UTF_8);
            byte[] ciphertextBytes = cipher.doFinal(cleartext);
            return Hex.encodeHexString(ciphertextBytes).toUpperCase();
        } catch (Exception ex) {
            logger.error("AES加密失败[{}]", src);
            return src;
        }
    }

    private static SecretKeySpec generate(String key) {
        byte[] finalKey = new byte[16];
        int i = 0;
        for (byte b : key.getBytes(StandardCharsets.UTF_8)) {
            finalKey[i++ % 16] ^= b;
        }
        return new SecretKeySpec(finalKey, "AES");
    }
}
