package com.digiwin.mobile.mobileuibot.common.crypto.digest;


import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Base64;

/**
 * <p>功能描述：摘要加密工具类</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: DigestUtil
 * @Author: zaregoto
 * @Date: 2023/1/18 16:43
 */
public class DigestUtil {

    public static final String AES_SECREKEY = "OkTLr7+ZtjyoGyEM";

    /**
     * 默认构造器，禁止实例化此类
     */
    private DigestUtil(){}

    /**
     * 依鼎捷IAM登录的加密标准，对原始字符串以UTF-8编码进行摘要加密
     *
     * @param rawString 原文内容
     * @return 摘要加密后的密文内容
     */
    public static String getDigestedStringForDwIamLogin(String rawString) {
        String encodeStr = "";
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            messageDigest.update(rawString.getBytes(StandardCharsets.UTF_8));
            byte[] bytes = messageDigest.digest();
            messageDigest.update(bytes);
            encodeStr = Base64.getEncoder().encodeToString(messageDigest.digest());
            return encodeStr;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return rawString;
    }

    public static String getDigestedStringForDwIamLoginByAes(String rawString) {
        try {
            return SecureAESUtil.aesEncrypt(rawString);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }
}
