package com.digiwin.mobile.mobileuibot.common.crypto.digest;

import cn.hutool.core.codec.Base64;
import cn.hutool.crypto.SecureUtil;

/**
 * @Auther: wuyang
 * @Date: 2023/04/04
 */
public class SecureAESUtil {
    public static final String CHANGE_PASSWORD_AES_KEY = Base64.encode("OkTLr7+ZtjyoGyEM");
    public static String aesEncrypt(String data) {
        return aesEncrypt(data, CHANGE_PASSWORD_AES_KEY);
    }

    /**
     * 禁止实例化此类
     */
    private SecureAESUtil(){}

    /**
     * 在鼎捷IAM上注册账号时使用到的加密方法
     *
     * @param data
     * @return
     */
    public static String aesEncryptInIamRegister(String data) {
        if (null == data || data.trim().isEmpty()) {
            return "";
        }
        byte[] bytes = SecureUtil.aes(Base64.decode(CHANGE_PASSWORD_AES_KEY)).encrypt(data);
        return Base64.encode(bytes);
    }

    public static String aesEncrypt(String data, String secretKey) {
        byte[] bytes = SecureUtil.aes(Base64.decode(secretKey)).encrypt(data);
        return Base64.encode(bytes);
    }

    public static String aesDecrypt(String data) {
        return aesDecrypt(data, CHANGE_PASSWORD_AES_KEY);
    }

    public static String aesDecrypt(String data, String secretKey) {
        byte[] bytes = Base64.decode(data);
        byte[] decrypt = SecureUtil.aes(Base64.decode(secretKey)).decrypt(bytes);
        return new String(decrypt);
    }
}
