package com.digiwin.mobile.mobileuibot.common.crypto.password;

import com.digiwin.mobile.mobileuibot.common.crypto.digest.SecureAESUtil;
import lombok.extern.slf4j.Slf4j;

import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * <p>功能描述：随机密码工具类</p>
 *
 * @FileName: RandomPasswordUtil
 * @Author: zaregoto
 * @Date: 2024/4/24 15:24
 */
@Slf4j
public final class RandomPasswordUtil {
    private static final String LOW_STR = "abcdefghijklmnopqrstuvwxyz";
    private static final String SPECIAL_STR = "~!@#$%^&*()_+/-=[]{};:'<>?.";
    private static final String NUM_STR = "0123456789";

    // 随机获取字符串字符
    private static char getRandomChar(String str) {
        SecureRandom random = new SecureRandom();
        return str.charAt(random.nextInt(str.length()));
    }

    // 随机获取小写字符
    private static char getLowChar() {
        return getRandomChar(LOW_STR);
    }

    // 随机获取大写字符
    private static char getUpperChar() {
        return Character.toUpperCase(getLowChar());
    }

    // 随机获取数字字符
    private static char getNumChar() {
        return getRandomChar(NUM_STR);
    }

    /**
     * 获取随机字符
     *
     * @param funNum 0-获取小写字母；1-获取大写字母；2-获取数字；其他-获取特殊字符
     * @return 字符
     */
    private static char getRandomChar(int funNum) {
        switch (funNum) {
            case 0:
                return getLowChar();
            case 1:
                return getUpperChar();
            case 2:
                return getNumChar();
            default:
                return getNumChar();
        }
    }

    /**
     * 获取随机密码
     *
     * @param num 密码长度要求
     * @return
     */
    public static String getRandomPwd(int num) {
        if (num < 8 || num > 24) {
            log.error("密码长度要求为8-24位");
            return "";
        }
        // 先把3种字符每种放来一个放进list
        List<Character> list = new ArrayList<>(num);
        list.add(getLowChar());
        list.add(getUpperChar());
        list.add(getNumChar());
        list.add(getNumChar());

        // 因为已经把4种字符放进list了，所以i从4开始取值
        // 产生随机数用于随机调用生成字符的函数
        for (int i = 4; i < num; i++) {
            SecureRandom random = new SecureRandom();
            int funNum = random.nextInt(4);
            list.add(getRandomChar(funNum));
        }

        // 打乱排序
        Collections.shuffle(list);
        StringBuilder stringBuilder = new StringBuilder(list.size());
        for (Character c : list) {
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static void main(String[] args) {
        for (int i = 0; i < 10; i++) {
            String randompwd = getRandomPwd(16);
            String randompwdEncrypt = SecureAESUtil.aesEncryptInIamRegister(randompwd);
            log.error(randompwd + " " + randompwdEncrypt);
        }
    }
}
