package com.digiwin.mobile.mobileuibot.common.crypto.rsa;


import org.apache.commons.codec.binary.Base64;

import javax.crypto.Cipher;
import java.io.ByteArrayOutputStream;
import java.security.Key;
import java.security.KeyFactory;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;

/**
 * 功能: IAM登录相关 RSA 加解密工具类
 *
 * @author: wjw
 * @date: created at 2023/5/9
 */
public class RSAUtils {

    /**
     * 客户端随机生成的 RSA 对应公钥私钥
     */
    public static final String CLIENT_PUBLIC_KEY =
            "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCs+xq+pZvnji066WeQmfpS9vA17SciLiJk9DSTyG" +
                    "ll11/F1tcg+jevbgG6a60uRfwdlnq1McMKbIdEdd0HcMIc3FPTAMCerSwWeZIU5ffL8h" +
                    "KBIhQy2JApZ4PIQIb5+WcojT97kjhxQRnBZjmXPfyRpXehIEAdyELn7fo7/dJacQIDAQAB";
    public static final String CLIENT_PRIVATE_KEY =
            "MIICdgIBADANBgkqhkiG9w0BAQEFAASCAmAwggJcAgEAAoGBAKz7Gr6lm+eOLTrpZ5CZ+lL28DXtJyI" +
                    "uImT0NJPIaWXXX8XW1yD6N69uAbprrS5F/B2WerUxwwpsh0R13QdwwhzcU9MAwJ6tLBZ5khT" +
                    "l98vyEoEiFDLYkClng8hAhvn5ZyiNP3uSOHFBGcFmOZc9/JGld6EgQB3IQuft+jv90lpxAg" +
                    "MBAAECgYANkRQj57E2k/wQJsYsnSb44s0sLZFoKN4htNV60bkSd7XXOmZc+8LqS2JvUIqgm" +
                    "nSPjYHKPEDjzGc/g072im1u3JUbTO7EyHhn7iuf9ynUe3KAAMSdD58SmQy2z12gpWYfp7x" +
                    "3AIGWWcHNk29Y/wVf73ZYRZWD5PZ7E2IHuFOewQJBAPfd0T0LlmIwssDgj0KsvP65rVhE" +
                    "6z81Z3IrMv0gXcmcQghJXYWOYonxxtAmSf3PYFJWFDcovFUtWlD5XkE7sj0CQQCyqDdz6" +
                    "laf/Y+fBBe6UEF9Qle1qFcga5S6nCBQ7RWPrfX3Twh8MvrTcCFfcVAe/NVxGZhFCvSNEF" +
                    "8aD0E67ZBFAkBMcoCXWFyQej6XmGr3AHnmAnSBVfhMbXczUjmOso3aobQIBECw8YJY01Y" +
                    "jWrvVaUFnA5+Gh6zWhH9nnBHDAtttAkAdoG+xtUawOWg7wn3805pIn1vUMBpisfR0Dbf+M" +
                    "5LDxOFpJZ4OmpWlwo6GOVBEE0GCA/CQYoSzb+eVdromf4bRAkEAgjVXk9PqfsOQr3fZQ9G" +
                    "8sDiXHbqgwpvsqH73/7HTdLO6+IapR+meHyIj1H62z22WvsmwJmGtHyC2ROD5kJ1npg==";

    /**
     * 加密算法RSA
     */
    private static final String KEY_ALGORITHM = "RSA";

    /**
     * RSA最大加密明文大小
     */
    private static final int MAX_ENCRYPT_BLOCK = 245;

    /**
     * RSA最大解密密文大小
     */
    private static final int MAX_DECRYPT_BLOCK = 256;

    /**
     * 禁止实例化此类
     */
    private RSAUtils(){}

    /**
     * 私钥解密
     *
     * @param encryptedData 已加密数据
     * @param privateKey    私钥(BASE64编码)
     * @return
     * @throws Exception
     */
    public static byte[] decryptByPrivateKey(byte[] encryptedData, String privateKey) throws Exception {
        byte[] keyBytes = Base64.decodeBase64(privateKey);
        PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        Key privateK = keyFactory.generatePrivate(pkcs8KeySpec);
        Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
        cipher.init(Cipher.DECRYPT_MODE, privateK);
        int inputLen = encryptedData.length;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int offSet = 0;
        byte[] cache;
        int i = 0;
        // 对数据分段解密
        while (inputLen - offSet > 0) {
            if (inputLen - offSet > MAX_DECRYPT_BLOCK) {
                cache = cipher.doFinal(encryptedData, offSet, MAX_DECRYPT_BLOCK);
            } else {
                cache = cipher.doFinal(encryptedData, offSet, inputLen - offSet);
            }
            out.write(cache, 0, cache.length);
            i++;
            offSet = i * MAX_DECRYPT_BLOCK;
        }
        byte[] decryptedData = out.toByteArray();
        out.close();
        return decryptedData;
    }

    /**
     * 公钥加密
     *
     * @param data      源数据
     * @param publicKey 公钥(BASE64编码)
     * @return
     * @throws Exception
     */
    private static byte[] encryptByPublicKey(byte[] data, String publicKey) throws Exception {
        byte[] keyBytes = Base64.decodeBase64(publicKey);
        X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        Key publicK = keyFactory.generatePublic(x509KeySpec);
        // 对数据加密
        Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
        cipher.init(Cipher.ENCRYPT_MODE, publicK);
        int inputLen = data.length;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int offSet = 0;
        byte[] cache;
        int i = 0;
        // 对数据分段加密
        while (inputLen - offSet > 0) {
            if (inputLen - offSet > MAX_ENCRYPT_BLOCK) {
                cache = cipher.doFinal(data, offSet, MAX_ENCRYPT_BLOCK);
            } else {
                cache = cipher.doFinal(data, offSet, inputLen - offSet);
            }
            out.write(cache, 0, cache.length);
            i++;
            offSet = i * MAX_ENCRYPT_BLOCK;
        }
        byte[] encryptedData = out.toByteArray();
        out.close();
        return encryptedData;
    }

    /**
     * 公钥加密
     *
     * @param data      源数据
     * @param publicKey 公钥(BASE64编码)
     * @return
     * @throws Exception
     */
    public static String encryptByPublicKey(String data, String publicKey) throws Exception {
        data = Base64.encodeBase64String(encryptByPublicKey(data.getBytes(), publicKey));
        return data;
    }
}
