package com.digiwin.mobile.mobileuibot.common.currency;

import java.text.DecimalFormat;

/**
 * <p>功能描述：货币、金额工具类</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: CurrencyUtil
 * @Author: Zaregoto
 * @Date: 2021/5/27 17:03
 */
public final class CurrencyUtil {

    /**
     * 禁止实例化
     */
    private CurrencyUtil(){}

    /**
     * 将数字被称为转换成有千分位的方法
     *
     * @param text
     * @return
     */
    public static String fmtMicrometer(String text) {
        DecimalFormat df = null;
        if (text.indexOf(".") > 0) {
            int i = text.length() - text.indexOf(".") - 1;
            if (i == 0) {
                df = new DecimalFormat("###,##0.");
            } else if (i == 1) {
                df = new DecimalFormat("###,##0.0");
            } else if (i == 2) {
                df = new DecimalFormat("###,##0.00");
            } else if (i == 3) {
                df = new DecimalFormat("###,##0.000");
            } else {
                df = new DecimalFormat("###,##0.0000");
            }
        } else {
            df = new DecimalFormat("###,##0");
        }
        double number = 0.0;
        try {
            number = Double.parseDouble(text);
        } catch (Exception e) {
            number = 0.0;
        }
        return df.format(number);
    }

    /**
     * 根据语言别，获取输入数值的数量级单位（unit of magnitude)
     *
     * @param locale 语言别
     * @param value  待处理数值
     * @return
     */
    public static MagnitudeUnit getUnitOfMagnitudeByLocale(String locale, Double value) {
        MagnitudeUnit magnitudeUnit = new MagnitudeUnit();
        switch (locale) {
            case "en_US":
                magnitudeUnit = getUnitOfMagnitudeInEnUs(value);
                break;
            case "zh_CN":
                magnitudeUnit = getUnitOfMagnitudeInZhCn(value);
                break;
            case "zh_TW":
                magnitudeUnit = getUnitOfMagnitudeInZhTw(value);
                break;
            default:
                break;
        }
        magnitudeUnit.setLocale(locale);
        return magnitudeUnit;
    }

    /**
     * 获取简体中文环境下，数值的数量级单位（unit of magnitude)
     *
     * @param value
     * @return
     */
    private static MagnitudeUnit getUnitOfMagnitudeInZhCn(Double value) {
        String unitText = "";
        Long level = 1L;
        if (Math.abs(value) >= 100000000) {
            unitText = "亿";
            level = 100000000L;
        } else if (Math.abs(value) >= 10000000) {
            unitText = "千万";
            level = 10000000L;
        } else if (Math.abs(value) >= 10000) {
            unitText = "万";
            level = 10000L;
        } else {
            unitText = "";
        }

        return new MagnitudeUnit().setUnitText(unitText).setLevel(level);
    }

    /**
     * 获取繁体中文环境下，数值的数量级单位（unit of magnitude)
     *
     * @param value
     * @return
     */
    private static MagnitudeUnit getUnitOfMagnitudeInZhTw(Double value) {
        String unitText = "";
        Long level = 1L;
        if (Math.abs(value) >= 100000000) {
            unitText = "億";
            level = 100000000L;
        } else if (Math.abs(value) >= 10000000) {
            unitText = "千萬";
            level = 10000000L;
        } else if (Math.abs(value) >= 10000) {
            unitText = "萬";
            level = 10000L;
        } else {
            unitText = "";
        }

        return new MagnitudeUnit().setUnitText(unitText).setLevel(level);
    }

    /**
     * 获取英语环境下，数值的数量级单位（unit of magnitude)
     *
     * @param value
     * @return
     */
    private static MagnitudeUnit getUnitOfMagnitudeInEnUs(Double value) {
        String unitText = "";
        Long level = 1L;
        if (Math.abs(value) >= 1000000000) {
            unitText = "B";
            level = 1000000000L;
        } else if (Math.abs(value) >= 1000000) {
            unitText = "M";
            level = 1000000L;
        } else if (Math.abs(value) >= 1000) {
            unitText = "K";
            level = 1000L;
        } else {
            unitText = "";
        }

        return new MagnitudeUnit().setUnitText(unitText).setLevel(level);
    }
}
