package com.digiwin.mobile.mobileuibot.common.currency;

import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * <p>功能描述：数量级单位</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: MagnitudeUnit
 * @Author: zaregoto
 * @Date: 2024/2/20 13:43
 */
@Data
@Accessors(chain = true)
public class MagnitudeUnit implements Serializable {

    private static final long serialVersionUID = -1423528471962022353L;

    /**
     * 语言别
     */
    private String locale;

    /**
     * 名称。如万、千万
     */
    private String unitText;

    /**
     * 数量级，与unitText对应
     * 如果unitText='万'，level=10000
     * 如果unitText='千万'，level=10000000
     */
    private Long level;
}