package com.digiwin.mobile.mobileuibot.common.image;

import lombok.extern.slf4j.Slf4j;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Base64;

/**
 * <p>功能描述：图片处理工具类</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: ImageUtil
 * @Author: Zaregoto
 * @Date: 2021/11/10 22:06
 */
@Slf4j
public final class ImageUtil {


    /**
     * base64字符串转化成图片
     *
     * @param imgBase64Str
     * @param imageFileSuffix 图片文件后缀包含第一个点点。如：.jpg、.png
     * @return
     */
    public static File generateImage(String imgBase64Str, String imageFileSuffix) {
        //对字节数组字符串进行Base64解码并生成图片
        if (imgBase64Str == null) {
            return null;
        }
        OutputStream out = null;
        try {
            //Base64解码
            byte[] b = Base64.getMimeDecoder().decode(imgBase64Str);
            // 生成图片
            File resultFile = File.createTempFile("AthenaAppAutoGenerated", imageFileSuffix);
            out = Files.newOutputStream(Paths.get(resultFile.getPath()));
            out.write(b);
            out.flush();
            return resultFile;
        } catch (Exception e) {
            return null;
        } finally {
            if (out != null) {
                try {
                    out.close();
                } catch (IOException e) {
                    log.error("OutputStream close exception");
                }
            }
        }
    }

    /**
     * 对图片进行base64编码
     *
     * @param files
     * @return
     */
    public static String encodeImage(byte[] files) {
        return Base64.getEncoder().encodeToString(files);
    }

    /**
     * 对图片进行base64编码
     *
     * @param path
     * @return
     */
    public static String encodeImage(String path) {
        byte[] b = null;
        InputStream in = null;
        String resultStr = null;
        try {
            in = Files.newInputStream(Paths.get(path));
            b = new byte[in.available()];
            int count = 0;
            while ((count = in.read(b)) > 0) {
                // 对字节数组Base64编码
                resultStr = Base64.getEncoder().encodeToString(b);
            }
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            try {
                if (in != null) {
                    in.close();
                }
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
        return resultStr;
    }


}
