package com.digiwin.mobile.mobileuibot.common.log;

import org.slf4j.MDC;

import java.util.UUID;

/**
 * TraceId工具类
 * 使用MDC往日志中添加traceId
 *
 * @author zhangjj
 * @date 2021/12/22 0022 14:34
 */
public class TraceIdUtil {

    public static final String TRACE_ID = "traceId";
    public static final String TRACE_START_TIME = "start_time";

    private TraceIdUtil() {
    }

    public static void set() {
        MDC.put(TRACE_ID, generate());
        MDC.put(TRACE_START_TIME, System.currentTimeMillis() + "");
    }

    public static String get() {
        return MDC.get(TRACE_ID);
    }

    public static String getTraceStartTime() {
        return MDC.get(TRACE_START_TIME);
    }

    public static void remove() {
        MDC.remove(TRACE_ID);
    }

    private static String generate() {
        return UUID.randomUUID().toString().replace("-", "").substring(0, 16);
    }
}
