package com.digiwin.mobile.mobileuibot.common.map;

import java.util.*;

/**
 * map工具类
 *
 * @author zhangjj
 * @date 2022/11/29 15:21
 */
public class MapUtil {

    /**
     * 根据value值，倒序排列
     *
     * @param map
     * @return
     */
    public static Map<String, Integer> sortMapDescOrderByValue(Map<String, Integer> map) {
        //利用Map的entrySet方法，转化为list进行排序
        List<Map.Entry<String, Integer>> entryList = new ArrayList<>(map.entrySet());
        //利用Collections的sort方法对list排序
        Collections.sort(entryList, (o1, o2) -> {
            //正序排列，倒序反过来
            return o2.getValue() - o1.getValue();
        });
        //遍历排序好的list，一定要放进LinkedHashMap，因为只有LinkedHashMap是根据插入顺序进行存储
        LinkedHashMap<String, Integer> linkedHashMap = new LinkedHashMap<String, Integer>();
        for (Map.Entry<String, Integer> e : entryList
        ) {
            linkedHashMap.put(e.getKey(), e.getValue());
        }
        return linkedHashMap;
    }


    /**
     * key对应value没值，返回默认值
     *
     * @param map
     * @param key
     * @param defaultValue
     * @return
     */
    public static <V> V getOrDefault(Map<String, V> map, String key, V defaultValue) {
        V value = map.get(key);
        if (Objects.isNull(value)) {
            return defaultValue;
        }
        return value;
    }
}
