package com.digiwin.mobile.mobileuibot.common.object;

import com.digiwin.mobile.mobileuibot.common.file.FileUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

/**
 * Object工具类
 *
 * @author xujinc
 * @date 2024/01/16 15:21
 */
public class ObjectUtil {
    private static final Logger logger = LoggerFactory.getLogger(ObjectUtil.class);

    public static String getObjectFieldValByName(Object object, String name) {
        try {
            Field[] fieldList = object.getClass().getDeclaredFields();
            Optional<Field> fieldOptional = Arrays.stream(fieldList).filter(e -> e.getName().equalsIgnoreCase(name)).findFirst();
            if (!fieldOptional.isPresent()) {
                return StringUtils.EMPTY;
            }
            Field field = fieldOptional.get();
            field.setAccessible(true);
            Object val = field.get(object);
            return Objects.isNull(val) ? "" : String.valueOf(val);
        } catch (Exception e) {
            logger.error("ObjectUtil getObjectFieldValByName error :", e);
        }
        return StringUtils.EMPTY;
    }
}
