package com.digiwin.mobile.mobileuibot.common.pinyin;

import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import net.sourceforge.pinyin4j.format.HanyuPinyinVCharType;

/**
 * 汉语拼音工具类
 *
 * @author zhangjj
 * @date 2021/8/30 0030 16:29
 */
public class HypyUtil {

    /**
     * 获取字符串的全汉语拼音(全小写)
     *
     * @param src 待处理字符串
     * @return 字符串的全汉语拼音
     */
    public static String getPinYin(String src) {
        StringBuilder t4 = new StringBuilder();
        if (src != null) {
            char[] t1 = src.toCharArray();
            String[] t2;
            // 设置汉字拼音输出的格式
            HanyuPinyinOutputFormat t3 = new HanyuPinyinOutputFormat();
            t3.setCaseType(HanyuPinyinCaseType.LOWERCASE);
            t3.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
            t3.setVCharType(HanyuPinyinVCharType.WITH_V);
            int t0 = t1.length;
            try {
                for (int i = 0; i < t0; i++) {
                    // 判断是否为汉字字符
                    if (Character.toString(t1[i]).matches("[\\u4E00-\\u9FA5]+")) {
                        // 将汉字的几种全拼都存到t2数组中
                        t2 = PinyinHelper.toHanyuPinyinStringArray(t1[i], t3);
                        // 取出该汉字全拼的第一种读音并连接到字符串t4后
                        t4.append(t2[0]);
                    } else {
                        // 如果不是汉字字符，直接取出字符并连接到字符串t4后
                        t4.append(Character.toString(t1[i]));
                    }
                }
            } catch (Exception e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }
            if (!"".equals(t4.toString())) {
                t4 = new StringBuilder(t4.toString().toLowerCase());
            }
        }
        return t4.toString().toLowerCase();
    }

}
