package com.digiwin.mobile.mobileuibot.common.request;

import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import org.springframework.util.StringUtils;

import javax.servlet.http.HttpServletRequest;
import java.io.BufferedReader;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;

/**
 * 请求body解析工具类
 */
public class RequestParameterUtil {

    /**
     * 获取POST过来的key=value数据并返回数据字符串
     *
     * @param request       请求的request
     * @param needUrlDecode 是否需要进行URLDecode
     * @return POST过来的数据字符串
     * @throws IOException
     */
    public static String getPostData(HttpServletRequest request,
                                     boolean needUrlDecode, String encoding) throws IOException {
        BufferedReader bfReader = request.getReader();
        char[] chayBuf = new char[1024];
        int iLen = 0;
        StringBuffer sb = new StringBuffer();
        while ((iLen = bfReader.read(chayBuf)) != -1) {
            sb.append(chayBuf, 0, iLen);
        }

        // sb为post过来的数据
        return needUrlDecode ? URLDecoder.decode(sb.toString(), encoding) : sb.toString();
    }

    /**
     * 根据请求JSON的数据，转换成对应的Map.Map的key等于请求中数据的key,value等于请求数据key的value.
     *
     * @param request
     * @param needUrlDecode
     * @param encoding
     * @return
     * @throws IOException
     */
    public static Map<String, Object> getPostDataMap(HttpServletRequest request,
                                                     boolean needUrlDecode, String encoding) throws IOException {
        String postData = getPostData(request, needUrlDecode, encoding);
        if (StringUtils.hasLength(postData)) {
            return JsonUtil.jsonStringToObject(getPostData(request, needUrlDecode, encoding), Map.class);
        }
        return new HashMap<>();
    }
}
