package com.digiwin.mobile.mobileuibot.common.string;

import org.springframework.util.CollectionUtils;

import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Map;

/**
 * <p>功能描述：字符串处理工具类</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: StringUtil
 * @Author: Zaregoto
 * @Date: 2022/1/29 22:03
 */
public final class StringUtil {

    public static final String SOURCE_ATHENA = "athena";

    /**
     * 清空入参字符串中常见的控制类型转义字体
     *
     * @param inputString
     * @return
     */
    public static String clearEscapeControlCharacter(String inputString) {
        return inputString
                .replace("\r", "")
                .replace("\n", "")
                .replace("\f", "")
                .replace("\t", "")
                .replace("\b", "");
    }

    public static boolean isEmpty(CharSequence cs) {
        return cs == null || cs.length() == 0;
    }

    public static boolean isEmpty(Object obj) {
        return obj == null || ((String) obj).length() == 0;
    }

    public static boolean isNotEmpty(CharSequence cs) {
        return !isEmpty(cs);
    }

    public static boolean isNotEmpty(Object obj) {
        return !isEmpty(obj);
    }

    public static String valueOf(Object o) {
        return null == o ? "" : o.toString();
    }

    /**
     * 对原始字符串中的 <br>、<br/>、</br>等 换行符转换成 \r\n 换行符
     *
     * @param content 原始字符串
     * @return
     */
    public static String applyLineFeed(String content) {
        if (null == content) {
            return content;
        }
        return content
                .replace("<br>", "\r\n")
                .replace("<br/>", "\r\n")
                .replace("</br>", "\r\n");
    }

    /**
     * 将queryString转成Map
     *
     * @param queryString
     * @return
     */
    public static Map<String, String> parseQueryString(String queryString) {
        Map<String, String> parameters = new java.util.HashMap<>();
        if (queryString != null && !queryString.isEmpty()) {
            for (String param : queryString.split("&")) {
                String[] keyValue = param.split("=");
                if (keyValue.length == 2) {
                    try {
                        parameters.put(URLDecoder.decode(keyValue[0], "UTF-8"),
                                URLDecoder.decode(keyValue[1], "UTF-8"));
                    } catch (Exception e) {
                        // handle exception
                        e.printStackTrace();
                    }
                } else if (keyValue.length == 1) {
                    try {
                        parameters.put(URLDecoder.decode(keyValue[0], "UTF-8"), "");
                    } catch (Exception e) {
                        // handle exception
                        e.printStackTrace();
                    }
                } else {
                    continue;
                }
            }
        }
        return parameters;
    }

    /**
     * 从一个map重新构造出一个queryString。举例：<br/>
     * key="A",value="1"
     * key="B",value=""
     * key="C",value="3"
     * 则queryString是A=1&B=&C=3
     *
     * @param queryStringParamsMap
     * @return queryString字符串
     */
    public static String rebuildQueryStringFromMap(Map<String, String> queryStringParamsMap) {
        if (CollectionUtils.isEmpty(queryStringParamsMap)) {
            return "";
        }
        String queryString = "";
        StringBuilder queryStringBuilder = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, String> entry : queryStringParamsMap.entrySet()) {
            if (first) {
                first = false;
            }
            try {
                queryStringBuilder.append(URLEncoder.encode(entry.getKey(), "UTF-8"))
                        .append("=")
                        .append(URLEncoder.encode(entry.getValue(), "UTF-8"))
                        .append("&");
            } catch (Exception e) {
                // handle exception
            }
        }
        if (queryStringBuilder.charAt(queryStringBuilder.length() - 1) == '&') {
            queryString = queryStringBuilder.substring(0, queryStringBuilder.length());
        } else {
            queryString = queryStringBuilder.toString();
        }
        return queryString;
    }
}
