/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.common.crypto.password;

import com.digiwin.mobile.mobileuibot.common.crypto.digest.SecureAESUtil;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RandomPasswordUtil {
    private static final Logger log = LoggerFactory.getLogger(RandomPasswordUtil.class);
    private static final String LOW_STR = "abcdefghijklmnopqrstuvwxyz";
    private static final String SPECIAL_STR = "~!@#$%^&*()_+/-=[]{};:'<>?.";
    private static final String NUM_STR = "0123456789";

    private static char getRandomChar(String str) {
        SecureRandom random = new SecureRandom();
        return str.charAt(random.nextInt(str.length()));
    }

    private static char getLowChar() {
        return RandomPasswordUtil.getRandomChar(LOW_STR);
    }

    private static char getUpperChar() {
        return Character.toUpperCase(RandomPasswordUtil.getLowChar());
    }

    private static char getNumChar() {
        return RandomPasswordUtil.getRandomChar(NUM_STR);
    }

    private static char getRandomChar(int funNum) {
        switch (funNum) {
            case 0: {
                return RandomPasswordUtil.getLowChar();
            }
            case 1: {
                return RandomPasswordUtil.getUpperChar();
            }
            case 2: {
                return RandomPasswordUtil.getNumChar();
            }
        }
        return RandomPasswordUtil.getNumChar();
    }

    public static String getRandomPwd(int num) {
        if (num < 8 || num > 24) {
            log.error("\u5bc6\u7801\u957f\u5ea6\u8981\u6c42\u4e3a8-24\u4f4d");
            return "";
        }
        ArrayList<Character> list = new ArrayList<Character>(num);
        list.add(Character.valueOf(RandomPasswordUtil.getLowChar()));
        list.add(Character.valueOf(RandomPasswordUtil.getUpperChar()));
        list.add(Character.valueOf(RandomPasswordUtil.getNumChar()));
        list.add(Character.valueOf(RandomPasswordUtil.getNumChar()));
        for (int i = 4; i < num; ++i) {
            SecureRandom random = new SecureRandom();
            int funNum = random.nextInt(4);
            list.add(Character.valueOf(RandomPasswordUtil.getRandomChar(funNum)));
        }
        Collections.shuffle(list);
        StringBuilder stringBuilder = new StringBuilder(list.size());
        for (Character c : list) {
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static void main(String[] args) {
        for (int i = 0; i < 10; ++i) {
            String randompwd = RandomPasswordUtil.getRandomPwd(16);
            String randompwdEncrypt = SecureAESUtil.aesEncryptInIamRegister(randompwd);
            log.error(randompwd + " " + randompwdEncrypt);
        }
    }
}

