package com.digiwin.mobile.mobileuibot.dto;

import com.digiwin.mobile.mobileuibot.model.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * <p>功能描述：版本管理</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: AppClientVo.java
 * @Author: wangjwc
 * @Date: created at 2025/8/12 15:42
 */
@Data
@Accessors(chain = true)
public class AppClientVo extends BaseModel {
    private static final long serialVersionUID = 8978359614996254308L;

    //====================================app_config 表字段=======================================
    /**
     * 应用code-appid
     */
    private String appCode;
    /**
     * 应用名称
     */
    private String appName;
    /**
     * 系统类型：android,ios
     */
    private String appOsType;
    /**
     * 环境：华为正式区、微软测试区、微软正式区、华为测试区
     */
    private String appEnv;
    /**
     * 应用描述
     */
    private String appDescr;


    //====================================app_client 表字段=======================================
    /**
     * 主键id
     */
    private Long id;
    /**
     * 应用ID（关联app_config.id）
     */
    private Long appId;
    /**
     * APP版本号
     */
    private String version;
    /**
     * 优先级，数字越大，优先级越高（优化查询大于version字符串问题）
     * 注意：同一个app_id、version下sequence值一样
     * 新增客户端数据时，查询当前app_id、version下数据是否存在。
     * 1、存在获取sequence值赋予当前新增数据sequence值
     * 2、不存在，获取app_id下sequence最大值 +1 赋予当前新增数据的sequence值
     */
    private Integer sequence;
    /**
     * 描述
     */
    private String descr;
    /**
     * 方式：0:apk上传方式，1链接方式
     * @see com.digiwin.mobile.mobileuibot.versionManage.enums.UpdateMethodsEnum
     */
    private Integer methods;
    /**
     *  下载地址（32位）
     */
    private String url32;
    /**
     *  下载地址（64位）
     */
    private String url64;
    /**
     *  MD5值（32位）
     */
    private String md532;
    /**
     *  MD5值（64位）
     */
    private String md564;
    /**
     * 跳转到应用商店的品牌：xiaomi,huawei,vivo,oppo
     * @see com.digiwin.mobile.mobileuibot.versionManage.enums.BrandEnum
     */
    private String brand;
    /**
     * 提示标题
     */
    private String tipsTitle;
    /**
     * 提示内容
     */
    private String tips;
    /**
     * 多语言配置
     */
    private String lang;
    /**
     * 是否有效 0：无效  1：有效
     * 注意：同一个app_id与version下，只有一个有效（校验中间版本是否强制更新）
     * 内置字段，同一个app_id与version下，点击发布按钮保存的数据设置为有效，其它设置为无效
     * @see com.digiwin.mobile.mobileuibot.versionManage.enums.ValidEnum
     */
    private Integer valid;
    /**
     * 发布状态：0未发布，1已发布，2取消发布
     * 注意：取消发布状态不可再设置其它状态，同一个app_id下只有一个已发布（当前校验的最新版本），其它设置为取消发布
     * @see com.digiwin.mobile.mobileuibot.versionManage.enums.PublishEnum
     */
    private Integer publish;
    /**
     * 删除标志 0：未删除  1：已删除
     * @see com.digiwin.mobile.mobileuibot.mock.enums.DelFlagEnum
     */
    private Integer delFlag;


    //====================================app_update 表字段=======================================
    /**
     * 客户端ID（关联app_client.id）
     */
    private Long appClientId;
    /**
     * 发布类型 0：局部发布，1：全量发布
     * 注意：局部发布下(条件必须配置），满足条件提示更新（强更/提示），不满足条件的一律不提示。
     * 全量发布下（未开启强更条件不可配置），开启强更，无条件全部强更，有条件不满足条件提示更新；关闭强更，没有条件都提示更新。
     * @see com.digiwin.mobile.mobileuibot.versionManage.enums.ReleaseTypeEnum
     */
    private Integer releaseType;
    /**
     * 强制版更 0：否，1：是
     * @see com.digiwin.mobile.mobileuibot.versionManage.enums.StrongUpdateEnum
     */
    private Integer strongUpdate;
    /**
     * 强制版更范围 0：全量，1：局部。
     * 注意：type=1&&strong_update=1有值
     * @see com.digiwin.mobile.mobileuibot.versionManage.enums.UpdateRangeEnum
     */
    private Integer updateRange;
    /**
     * 下发条件配置
     */
    private String conditions;
    /**
     * 历史记录：0否，1是
     * 注意：历史下发条件记录，，根据ID降序排序可查看历史下发条件
     * @see com.digiwin.mobile.mobileuibot.versionManage.enums.BakFlagEnum
     */
    private Integer bakFlag;
}