package com.digiwin.mobile.mobileuibot.mapper.db1;

import com.digiwin.mobile.mobileuibot.mapper.base.MobileBaseMapper;
import com.digiwin.mobile.mobileuibot.model.db1.CallbackInfo;
import org.apache.ibatis.annotations.Mapper;
import org.springframework.stereotype.Component;

import java.util.Map;

@Mapper
@Component
public interface EspCallbackDataRecordMapper extends MobileBaseMapper<CallbackInfo> {

    /**
     * 根据reqID查询回调数据
     *
     * @param reqId
     * @return
     */
    CallbackInfo getCallbacksDataById(String reqId);

    /**
     * 更新回调状态
     *
     * @param params
     * @return
     */
    Boolean updateCallbackStatus(Map<String, Object> params);

    /**
     * 插入回调数据
     *
     * @return
     */
    Boolean insertCallbackData(CallbackInfo callbackInfo);

}
