package com.digiwin.mobile.mobileuibot.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>功能描述：dao层基类</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: AppClient.java
 * @Author: wangjwc
 * @Date: created at 2025/6/26 17:37
 */
@Data
public class BaseModel implements Serializable {
    private static final long serialVersionUID = -6335625892583179220L;
    /**
     * 创建时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;
    /**
     * 更新时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date updateTime;

    /**
     * 更新时调用：清空创建时间和更新时间，走数据库默认值
     */
    public void clearTime() {
        this.createTime = null;
        this.updateTime = null;
    }
}