package com.digiwin.mobile.mobileuibot.model.db1;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * 用户FCM设备记录
 * 表名：fcm_mobile_user
 *
 * @author wuyang
 */
@TableName("fcm_mobile_user")
@Data
@NoArgsConstructor
@AllArgsConstructor
public class FcmMobileUser implements Serializable {
    private static final long serialVersionUID = 5547479733371295675L;
    /**
     * 记录id
     */
    @TableId(type = IdType.AUTO)
    private Long id;
    /**
     * 用户id
     */
    @TableField("user_id")
    private String userId;
    /**
     * 用户id
     */
    @TableField("tenant_id")
    private String tenantId;
    /**
     * 筛选栏的筛选id
     */
    @TableField("fcm_token")
    private String fcmToken;
    /**
     * 设备ID
     */
    @TableField("device_id")
    private String deviceId;
    /**
     * 是否删除该token
     */
    @TableField("delete_token")
    private int deleteToken;
    /**
     * 创建时间
     */
    @TableField("create_time")
    private Date createTime;

}