package com.digiwin.mobile.mobileuibot.model.db1;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;

/**
 * 功能: mock 数据
 *
 * @author: wjw
 * @date: created at 2023/3/23
 */
@Data
@Accessors(chain = true)
@TableName("mock")
public class Mock implements Serializable {
    private static final long serialVersionUID = 5971661036718133098L;
    /**
     * 录制id
     */
    @TableId
    private String mockId;
    /**
     * mock场景名称
     */
    private String mockName;
    /**
     * 应用名称
     */
    private String applicationName;
    /**
     * 录制人id
     */
    private String recordUserId;
    /**
     * 录制人名称
     */
    private String recordUserName;
    /**
     * 录制体验账号id
     */
    private String mockUserId;
    /**
     * 录制体验账号名称
     */
    private String mockUserName;
    /**
     * 是否已发布 0：未发布 1：已发布
     */
    private Integer publish;
    /**
     * 删除标志 0：未删除  1：已删除
     */
    private Integer delFlag;
    /**
     * 创建时间
     */
    private Date createTime;
    /**
     * 更新时间
     */
    private Date updateTime;
    /**
     * 是否启用娜娜 0：否 1：是
     */
    private Integer enableNana;
    /**
     * 租户ID
     */
    private String nanaTenantId;
    /**
     * 超管账号
     */
    private String nanaAdminAccount;
    /**
     * 超管密码
     */
    private String nanaAdminPassword;
    /**
     * 需要授权的应用code
     */
    private String nanaAuthorizationCode;

    /**
     * 目前枚举有华为正式，华为测试，阿里paas，微软正式，微软测试，后续有新地址直接加在枚举类
     */
    @TableField(exist = false)
    private String deployArea;
    /**
     * mock角色id---登录接口使用
     */
    @TableField(exist = false)
    private String mockRoleId;
}