package com.digiwin.mobile.mobileuibot.model.db1;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>功能描述：用户项目配置设置表</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: UserProjectFilter.java
 * @Author: wangjwc
 * @Date: created at 2024/7/24 11:32
 */
@TableName("user_project_filter")
@Accessors(chain = true)
@Data
public class UserProjectFilter implements Serializable {
    private static final long serialVersionUID = -2860348727616694995L;
    /**
     * 记录id
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 用户id
     */
    @TableField("user_id")
    private String userId;
    /**
     * 用户id
     */
    @TableField("tenant_id")
    private String tenantId;

    /**
     * 项目类型：project：我的项目；team-projects：团队项目
     *
     * @see PageFilterCodeEnum
     */
    @TableField("filter_code")
    private String filterCode;
    /**
     * 普通筛选栏的选项
     */
    @TableField("common_filter")
    private String commonFilter;

    /**
     * 高级筛选栏的选项
     */
    @TableField("senior_filter")
    private String seniorFilter;

    /**
     * 分组的配置
     * {
     * "model":"", --- 执行方式：normal:常规分组；senior:高级分组
     * "normal":[CardListGroupOption], -- 选中的选项
     * "senior":[CardListGroupOption] -- 选中的选项
     * }
     * @see UserProjectFilterGroupFilter
     */
    @TableField("group_filter")
    private String groupFilter;

    /**
     * 排序的选项id
     */
    @TableField("sort_filter")
    private String sortFilter;

    /**
     * 是否使用高级筛选
     */
    @TableField("is_use_senior_filter")
    private Boolean isUseSeniorFilter;

    /**
     * 搜索关键字
     */
    @TableField("query_param")
    private String queryParam;
    private Date time;
}