package com.digiwin.mobile.mobileuibot.model.db1;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * 用户筛选记录
 * 表名：user_task_filter
 */
@TableName("user_task_filter")
@Data
@NoArgsConstructor
@AllArgsConstructor
public class UserTaskFilter implements Serializable {
    private static final long serialVersionUID = 5463246528684723847L;
    /**
     * 记录id
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 用户id
     */
    @TableField("user_id")
    private String userId;
    /**
     * 用户id
     */
    @TableField("tenant_id")
    private String tenantId;
    /**
     * 筛选栏的筛选id
     */
    @TableField("filter_ids")
    private String filterIds;

    /**
     * 普通筛选栏的选项
     */
    @TableField("common_filter")
    private String commonFilter;

    /**
     * 高级筛选栏的选项
     */
    @TableField("senior_filter")
    private String seniorFilter;

    /**
     * 分组的选项id
     */
    @TableField("group_filter_ids")
    private String groupFilterIds;

    /**
     * 排序的选项id
     */
    @TableField("sort_filter")
    private String sortFilter;

    /**
     * 是否使用高级筛选
     */
    @TableField("is_use_senior_filter")
    private Boolean isUseSeniorFilter;

    /**
     * 搜索关键字
     */
    @TableField("query_param")
    private String queryParam;
    private Date time;

    public UserTaskFilter(String userId, String tenantId) {
        this.userId = userId;
        this.tenantId = tenantId;
    }
}