package com.digiwin.mobile.mobileuibot.model.db2;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.model.BaseModel;
import com.fasterxml.jackson.core.type.TypeReference;
import lombok.Data;
import lombok.experimental.Accessors;
import org.apache.commons.lang3.StringUtils;

import java.util.Map;

/**
 * <p>功能描述：客户端版本配置表</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: AppClient.java
 * @Author: wangjwc
 * @Date: created at 2025/6/26 17:37
 */
@Data
@Accessors(chain = true)
@TableName("app_client")
public class AppClient extends BaseModel {
    private static final long serialVersionUID = -7186975294331998237L;
    /**
     * 主键id
     */
    @TableId(type = IdType.AUTO)
    private Long id;
    /**
     * 应用ID（关联app_config.id）
     */
    private Long appId;
    /**
     * APP版本号
     */
    private String version;
    /**
     * 优先级，数字越大，优先级越高（优化查询大于version字符串问题）
     * 注意：同一个app_id、version下sequence值一样
     * 新增客户端数据时，查询当前app_id、version下数据是否存在。
     * 1、存在获取sequence值赋予当前新增数据sequence值
     * 2、不存在，获取app_id下sequence最大值 +1 赋予当前新增数据的sequence值
     */
    private Integer sequence;
    /**
     * 描述
     */
    private String descr;
    /**
     * 方式：0:apk上传方式，1链接方式
     * @see com.digiwin.mobile.mobileuibot.versionManage.enums.UpdateMethodsEnum
     */
    private Integer methods;
    /**
     *  下载地址（32位）
     */
    private String url32;
    /**
     *  下载地址（64位）
     */
    private String url64;
    /**
     *  MD5值（32位）
     */
    private String md532;
    /**
     *  MD5值（64位）
     */
    private String md564;
    /**
     * 跳转到应用商店的品牌：xiaomi,huawei,vivo,oppo
     * @see com.digiwin.mobile.mobileuibot.versionManage.enums.BrandEnum
     */
    private String brand;
    /**
     * 提示标题
     */
    private String tipsTitle;
    /**
     * 提示内容
     */
    private String tips;
    /**
     * 多语言配置
     */
    private String lang;
    /**
     * 是否有效 0：无效  1：有效
     * 注意：同一个app_id与version下，只有一个有效（校验中间版本是否强制更新）
     * 内置字段，同一个app_id与version下，点击发布按钮保存的数据设置为有效，其它设置为无效
     * @see com.digiwin.mobile.mobileuibot.versionManage.enums.ValidEnum
     */
    private Integer valid;
    /**
     * 发布状态：0未发布，1已发布，2取消发布
     * 注意：取消发布状态不可再设置其它状态，同一个app_id下只有一个已发布（当前校验的最新版本），其它设置为取消发布
     * @see com.digiwin.mobile.mobileuibot.versionManage.enums.PublishEnum
     */
    private Integer publish;
    /**
     * 删除标志 0：未删除  1：已删除
     * @see com.digiwin.mobile.mobileuibot.mock.enums.DelFlagEnum
     */
    private Integer delFlag;

    public String getTipsTitle(String locale) {
        String value = this.getLanguageValue("tipsTitle", locale);
        return StringUtils.isEmpty(value) ? this.tipsTitle : value;
    }

    public String getTips(String locale) {
        String value = this.getLanguageValue("tips", locale);
        return StringUtils.isEmpty(value) ? this.tips : value;
    }

    /**
     * 获取多语言值
     * @param fieldName 要获取的字段名（如 "tips"）
     * @param languageCode 当前语言代码（如 "zh_CN"）
     * @return 对应语言的字段值，找不到时返回 null
     */
    public String getLanguageValue(String fieldName, String languageCode) {
        try {
            // 将 JSON 字符串解析为嵌套的 Map 结构
            Map<String, Map<String, String>> langMap = JsonUtil.jsonStringToObject(this.lang, new TypeReference<Map<String, Map<String, String>>>() {
            });

            // 获取指定字段的多语言映射
            Map<String, String> fieldMap = langMap.get(fieldName);

            // 返回指定语言的字段值
            return fieldMap != null ? fieldMap.get(languageCode) : null;
        } catch (Exception e) {
            // JSON 解析失败时返回 null
            return null;
        }
    }
}