package com.digiwin.mobile.mobileuibot.model.db2;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.digiwin.mobile.mobileuibot.model.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * <p>功能描述：app用户客户端记录表</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: AppUserClientRecord.java
 * @Author: wangjwc
 * @Date: created at 2025/6/26 17:37
 */
@Data
@Accessors(chain = true)
@TableName("app_user_client_record")
public class AppUserClientRecord extends BaseModel {
    private static final long serialVersionUID = 6649184002936677498L;
    /**
     * 主键id
     */
    @TableId(type = IdType.AUTO)
    private Long id;
    // 应用ID
    private String appId;
    // 应用版本号
    private String version;
    /**
     * 架构类型
     * 注意：--- 其它 32位架构
     * armeabi-v7a: 32-bit ARM 架构（ARMv7）
     * arm64-v8a: 64-bit ARM 架构（ARMv8）
     */
    private String arch;
    // 品牌类型 -- 需后端判断具体品牌
    private String brand;
    // 设备ID(手机唯一)，如：cb93764a-7174-4b94-b5ca-9221fcb89a52
    private String deviceId;
    // 设备型号（model），如：iPhone14,3
    private String deviceType;
    // 系统版本,如：13,14等
    private String osVersion;
    // 系统类型，如：ios/android
    private String osType;
    // 应用包名
    private String packageName;
    // 租户ID
    private String tenantId;
    // 用户ID
    private String userId;
}