/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.abireport;

import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.button.Button;
import com.digiwin.mobile.mobileuibot.core.component.webview.Webview;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.service.DigiwinAtmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.service.DigiwinPcUiBotProxyService;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component(value="uiBotModelBuildAbiReportDetailStrategy")
public class UiBotModelBuildAbiReportDetailStrategy
implements UiBotModelBuildStrategy {
    private static final Logger logger = LoggerFactory.getLogger(UiBotModelBuildAbiReportDetailStrategy.class);
    private static final String SELECT_TAG = "hashCode";
    private static final String STATEMENT_RESID = "STATEMENT__resid";
    @Autowired
    private DigiwinPcUiBotProxyService digiwinPcUiBotProxyService;
    @Autowired
    private LocaleService localeService;
    @Autowired
    private DigiwinAtmcProxyService digiwinAtmcProxyService;

    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        UiBotModel uiBotModel = null;
        Boolean useMockData = AppContext.getUseMockData();
        uiBotModel = useMockData == false ? this.doActually(pageSetting, apiRequest) : this.doMockData(apiRequest);
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest) {
        String hashKey;
        String locale = apiRequest.getLocale();
        String iamUserToken = apiRequest.getIamUserToken();
        String tenantId = apiRequest.getTenantId();
        String dataId = apiRequest.getDataId();
        UiBotModel uiBotModel = pageSetting.getPageModel();
        String resid = "";
        UiBotAction action = null;
        String conditionId = "";
        String conditionName = "";
        Map conditionData = new HashMap();
        Boolean useCommon = false;
        Boolean isFirst = true;
        ApiRawData rawData = apiRequest.getRawData();
        if (rawData.getString(SELECT_TAG) != null) {
            resid = rawData.getString(STATEMENT_RESID);
            hashKey = rawData.getString(SELECT_TAG);
            action = (UiBotAction)JsonUtil.objectToJavaObject((Object)rawData.getJSONObject("action"), UiBotAction.class);
            conditionId = rawData.getString("conditionId");
            conditionName = rawData.getString("conditionName");
            conditionData = (Map)rawData.get((Object)"data");
            useCommon = rawData.getBooleanValue("useCommon");
            isFirst = false;
        } else {
            UiBotModel pcUibotModel = this.digiwinPcUiBotProxyService.conditionShow(locale, iamUserToken, tenantId, dataId);
            HashMap<String, Object> params = new HashMap<String, Object>(2);
            if (pcUibotModel != null && pcUibotModel.getPageData() != null && pcUibotModel.getPageData().get((Object)STATEMENT_RESID) != null) {
                resid = (String)pcUibotModel.getPageData().get((Object)STATEMENT_RESID);
                action = (UiBotAction)pcUibotModel.getActions().get(0);
                params.put("action", action);
                UiBotLayout uiBotLayout = (UiBotLayout)pcUibotModel.getLayout().get(0);
                HashMap<String, Object> data = new HashMap<String, Object>(1);
                data.put(uiBotLayout.getSchema(), pcUibotModel.getPageData().get((Object)uiBotLayout.getSchema()));
                params.put("data", data);
            }
            hashKey = this.digiwinAtmcProxyService.getAbiDataCache(iamUserToken, tenantId, locale, params);
        }
        List appbarButtonList = uiBotModel.getAppbarButtonList();
        appbarButtonList.add(Button.createAbiReport((String)this.localeService.getLanguageValue(locale, "\u67e5\u8be2"), (String)dataId, (UiBotAction)action, (String)conditionId, (String)conditionName, conditionData, (Boolean)useCommon, (Boolean)isFirst));
        List uiBotLayouts = uiBotModel.getLayout();
        UiBotPageData pageData = uiBotModel.getPageData();
        if (!StringUtils.hasLength((String)hashKey)) {
            UiBotModel emptyUiBotModel = UiBotModel.emptyAbiReportUiBotModel((String)locale, (String)"\u8bf7\u8bbe\u5b9a\u6216\u9009\u62e9\u6761\u4ef6\u4ee5\u67e5\u8be2\u62a5\u8868\u5185\u5bb9", (String)"\u9009\u62e9\u6761\u4ef6", (String)dataId);
            emptyUiBotModel.setAppbarButtonList(appbarButtonList);
            return emptyUiBotModel;
        }
        for (UiBotLayout layout : uiBotLayouts) {
            switch (layout.getType()) {
                case "WEBVIEW": {
                    Webview webview = (Webview)JsonUtil.objectToJavaObject((Object)pageData.get((Object)layout.getSchema()), Webview.class);
                    String url = webview.getUrl();
                    url = AppContext.getApiUrlSetting().getBiUrl() + url;
                    if (url.contains("${resid}")) {
                        url = url.replace("${resid}", resid);
                    }
                    if (url.contains("${hashKey}")) {
                        url = url.replace("${hashKey}", hashKey);
                    }
                    if (url.contains("${token}")) {
                        url = url.replace("${token}", iamUserToken);
                    }
                    if (url.contains("${tenantId}")) {
                        url = url.replace("${tenantId}", tenantId);
                    }
                    if (url.contains("${athenaUrl}")) {
                        url = url.replace("${athenaUrl}", AppContext.getApiUrlSetting().getMuiUrl());
                    }
                    webview.setUrl(url);
                    webview.setVerticalScroll(Boolean.valueOf(true));
                    webview.setWidthMode(Integer.valueOf(1));
                    webview.setSizeMode(Integer.valueOf(0));
                    pageData.put((Object)layout.getSchema(), (Object)webview);
                    break;
                }
            }
        }
        return uiBotModel;
    }

    private UiBotModel doMockData(ApiRequest apiRequest) {
        return null;
    }
}

