/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.aiassistant.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.digiwin.mobile.mobileuibot.aiassistant.model.AssistantMockDataModel;
import com.digiwin.mobile.mobileuibot.aiassistant.model.ExampleModel;
import com.digiwin.mobile.mobileuibot.aiassistant.model.QuestionsExampleModel;
import com.digiwin.mobile.mobileuibot.aiassistant.model.request.AssistantMockDataRequest;
import com.digiwin.mobile.mobileuibot.aiassistant.model.request.BulletinRequest;
import com.digiwin.mobile.mobileuibot.aiassistant.model.request.DataCollectConfigQueryDTO;
import com.digiwin.mobile.mobileuibot.aiassistant.model.request.DataCollectionAddRequest;
import com.digiwin.mobile.mobileuibot.aiassistant.model.request.DataCollectionGroupAddOrUpdateDTO;
import com.digiwin.mobile.mobileuibot.aiassistant.model.request.DataCollectionGroupDeleteDTO;
import com.digiwin.mobile.mobileuibot.aiassistant.model.request.DataCollectionGroupQueryDTO;
import com.digiwin.mobile.mobileuibot.aiassistant.model.request.DataCollectionRemoveRequest;
import com.digiwin.mobile.mobileuibot.aiassistant.model.request.DataSubscriptionRequest;
import com.digiwin.mobile.mobileuibot.aiassistant.model.request.MessageInfoRequest;
import com.digiwin.mobile.mobileuibot.aiassistant.model.request.NewRecordOverviewSubmitRequest;
import com.digiwin.mobile.mobileuibot.aiassistant.model.request.TaskDistributeRequest;
import com.digiwin.mobile.mobileuibot.aiassistant.service.AiAssistantService;
import com.digiwin.mobile.mobileuibot.api.AgileDataApiRequest;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.api.ApiResponse;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.exception.ServiceException;
import com.digiwin.mobile.mobileuibot.common.http.HttpService;
import com.digiwin.mobile.mobileuibot.common.http.model.AthenaBasicHttpRequestHead;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.map.MapUtil;
import com.digiwin.mobile.mobileuibot.common.string.StringUtil;
import com.digiwin.mobile.mobileuibot.config.SysEnvConfig;
import com.digiwin.mobile.mobileuibot.file.dto.AgileDataLiteUploadFileQueryDTO;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.ade.DigiwinAdeProxyService;
import com.digiwin.mobile.mobileuibot.proxy.ade.model.AdeDataCollectionGroupListResult;
import com.digiwin.mobile.mobileuibot.proxy.adt.model.DigiwinAdtProcessMessage;
import com.digiwin.mobile.mobileuibot.proxy.adt.model.DigiwinAdtTenantApplicationBilling;
import com.digiwin.mobile.mobileuibot.proxy.adt.model.DigiwinAdtThirdPartyAgileData;
import com.digiwin.mobile.mobileuibot.proxy.adt.request.AgileDataCalculateConfigRequest;
import com.digiwin.mobile.mobileuibot.proxy.adt.request.ProcessMessageRequest;
import com.digiwin.mobile.mobileuibot.proxy.adt.service.DigiwinAdtProxyService;
import com.digiwin.mobile.mobileuibot.proxy.agiledataecho.model.EchoFuzzyMatchingConfigDataResultDTO;
import com.digiwin.mobile.mobileuibot.proxy.agiledataecho.model.EchoGmcBulletinResultDTO;
import com.digiwin.mobile.mobileuibot.proxy.agiledataecho.model.EchoGmcBulletinUnReadResultDTO;
import com.digiwin.mobile.mobileuibot.proxy.agiledataecho.model.EchoInformationModel;
import com.digiwin.mobile.mobileuibot.proxy.agiledataecho.model.EchoInformationModelQueryDTO;
import com.digiwin.mobile.mobileuibot.proxy.agiledataecho.model.EchoInformationResultDTO;
import com.digiwin.mobile.mobileuibot.proxy.agiledataecho.model.EchoInstructionGroupResultDTO;
import com.digiwin.mobile.mobileuibot.proxy.agiledataecho.model.EchoLiteUploadLimitationsConfigDataResultDTO;
import com.digiwin.mobile.mobileuibot.proxy.agiledataecho.model.EchoMetricCheckMongoDataResultDTO;
import com.digiwin.mobile.mobileuibot.proxy.agiledataecho.model.EchoOpeningRemarksConfigResultDTO;
import com.digiwin.mobile.mobileuibot.proxy.agiledataecho.model.EchoPageConfigProductBulletinQueryDTO;
import com.digiwin.mobile.mobileuibot.proxy.agiledataecho.model.EchoPageConfigProductBulletinResultDTO;
import com.digiwin.mobile.mobileuibot.proxy.agiledataecho.service.DigiwinAgileDataEchoProxyService;
import com.digiwin.mobile.mobileuibot.proxy.aim.service.DigiwinAimProxyService;
import com.digiwin.mobile.mobileuibot.proxy.ania.service.DigiwinAniaProxyService;
import com.digiwin.mobile.mobileuibot.proxy.cac.model.DigiwinCacApplicationAuthorizationInformation;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.model.KnowledgeMapsDataCollectionModel;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.model.KnowledgeMapsDataSubscriptionModel;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.model.KnowledgeMapsSceneIntentionModel;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.model.response.KnowledgeMapsResponse;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.service.DigiwinKnowledgeMapsProxyService;
import com.digiwin.mobile.mobileuibot.proxy.tdd.service.TddService;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Resource;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class AiAssistantServiceImpl
implements AiAssistantService {
    private static final Logger logger = LoggerFactory.getLogger(AiAssistantServiceImpl.class);
    @Autowired
    private HttpService httpService;
    @Autowired
    private SysEnvConfig sysEnvConfig;
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private DigiwinAimProxyService digiwinAimProxyService;
    @Autowired
    private DigiwinAniaProxyService digiwinAniaProxyService;
    @Resource(name="defaultThreadPool")
    private ThreadPoolTaskExecutor threadPoolTaskExecutor;
    @Autowired
    private DigiwinKnowledgeMapsProxyService knowledgeMapsProxyService;
    @Autowired
    private DigiwinAdtProxyService adtProxyService;
    @Autowired
    private LocaleService localeService;
    @Autowired
    private DigiwinAgileDataEchoProxyService echoService;
    @Autowired
    private TddService tddService;
    @Autowired
    private DigiwinAdeProxyService adeProxyService;

    public Map<String, Object> getMessageInfo(MessageInfoRequest messageInfoRequest) {
        String url = this.sysEnvConfig.getAsaUrl() + "/asa/message/athena/info";
        AthenaBasicHttpRequestHead athenaBasicHttpRequestHead = new AthenaBasicHttpRequestHead();
        athenaBasicHttpRequestHead.setTenantId(messageInfoRequest.getTenantId());
        athenaBasicHttpRequestHead.setUserToken(messageInfoRequest.getIamUserToken());
        ResponseEntity responseEntity = this.execute(athenaBasicHttpRequestHead, JsonUtil.javaObjectToJsonString((Object)messageInfoRequest.getMessageInfoItemList()), url);
        if (Objects.isNull(responseEntity) || !responseEntity.getStatusCode().is2xxSuccessful()) {
            logger.error("aiAssistant get message info internal error");
            throw new ServiceException("aiAssistant get message info error");
        }
        if (!Objects.equals(((Map)responseEntity.getBody()).get("code"), 0)) {
            logger.error("aiAssistant get message info failed ,e ={}", ((Map)responseEntity.getBody()).get("msg"));
            throw new ServiceException(String.valueOf(((Map)responseEntity.getBody()).get("msg")));
        }
        return (Map)JsonUtil.objectToJavaObject(((Map)responseEntity.getBody()).get("data"), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void submitNewRecordOverview(NewRecordOverviewSubmitRequest newRecordOverviewSubmitRequest) {
        String url = this.sysEnvConfig.getAsaUrl() + "/asa/newRecordOverview/athena/submit";
        AthenaBasicHttpRequestHead athenaBasicHttpRequestHead = new AthenaBasicHttpRequestHead();
        athenaBasicHttpRequestHead.setTenantId(newRecordOverviewSubmitRequest.getTenantId());
        athenaBasicHttpRequestHead.setUserToken(newRecordOverviewSubmitRequest.getIamUserToken());
        ResponseEntity responseEntity = this.execute(athenaBasicHttpRequestHead, JsonUtil.javaObjectToJsonString((Object)newRecordOverviewSubmitRequest), url);
        if (Objects.isNull(responseEntity) || !responseEntity.getStatusCode().is2xxSuccessful()) {
            logger.error("aiAssistant submit newRecordOverview internal error");
            throw new ServiceException("aiAssistant submit newRecordOverview error");
        }
        if (!Objects.equals(((Map)responseEntity.getBody()).get("code"), 0)) {
            logger.error("aiAssistant submit newRecordOverview failed ,e ={}", ((Map)responseEntity.getBody()).get("msg"));
            throw new ServiceException(String.valueOf(((Map)responseEntity.getBody()).get("msg")));
        }
    }

    public String taskDistribute(TaskDistributeRequest taskDistributeRequest) {
        String url = this.sysEnvConfig.getAsaUrl() + "/asa/card/task/athena/distribute?source=athena-mobile&workItemId=" + taskDistributeRequest.getWorkItemId();
        AthenaBasicHttpRequestHead athenaBasicHttpRequestHead = new AthenaBasicHttpRequestHead();
        athenaBasicHttpRequestHead.setTenantId(taskDistributeRequest.getTenantId());
        athenaBasicHttpRequestHead.setUserToken(taskDistributeRequest.getIamUserToken());
        ResponseEntity responseEntity = this.execute(athenaBasicHttpRequestHead, Collections.emptyMap(), url);
        if (Objects.isNull(responseEntity) || !responseEntity.getStatusCode().is2xxSuccessful()) {
            logger.error("aiAssistant card task distribute internal error");
            throw new ServiceException("aiAssistant card task distribute error");
        }
        if (!Objects.equals(((Map)responseEntity.getBody()).get("code"), 0)) {
            logger.error("aiAssistant card task distribute failed ,e ={}", ((Map)responseEntity.getBody()).get("msg"));
            throw new ServiceException(String.valueOf(((Map)responseEntity.getBody()).get("msg")));
        }
        return (String)MapUtil.getOrDefault((Map)((Map)responseEntity.getBody()), (String)"data", (Object)"");
    }

    public int queryAssistantCount(ApiRequest apiRequest) {
        String url = AppContext.getApiUrlSetting().getAniaUrl() + "/ania/athena/assistant/queryAssistantCount?clientType=APP";
        AthenaBasicHttpRequestHead athenaBasicHttpRequestHead = new AthenaBasicHttpRequestHead();
        athenaBasicHttpRequestHead.setUserToken(apiRequest.getIamUserToken());
        ResponseEntity responseEntity = this.execute(athenaBasicHttpRequestHead, Collections.emptyMap(), url);
        if (Objects.isNull(responseEntity) || !responseEntity.getStatusCode().is2xxSuccessful()) {
            logger.error("aiAssistant get assistant list error");
            throw new ServiceException("aiAssistant get assistant list error");
        }
        if (!Objects.equals(((Map)responseEntity.getBody()).get("code"), 0)) {
            logger.error("aiAssistant get assistant list failed ,e ={}", ((Map)responseEntity.getBody()).get("msg"));
            throw new ServiceException(String.valueOf(((Map)responseEntity.getBody()).get("msg")));
        }
        Map returnData = (Map)MapUtil.getOrDefault((Map)((Map)responseEntity.getBody()), (String)"data", Collections.emptyMap());
        if (!returnData.isEmpty()) {
            return Integer.parseInt(String.valueOf(returnData.get("assistantCount")));
        }
        return 0;
    }

    public List<String> getAssistantMockData(AssistantMockDataRequest dto) {
        ArrayList<String> resultList = new ArrayList<String>();
        String locale = dto.getLocale();
        String key = Objects.equals(locale, "zh_CN") ? "CN" : "TW";
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"mockCategoryKey").is((Object)dto.getMockCategoryKey()));
        List assistantMockDataModels = this.mongoTemplate.find(query, AssistantMockDataModel.class);
        if (assistantMockDataModels.isEmpty()) {
            return resultList;
        }
        assistantMockDataModels.sort(Comparator.comparing(o -> Optional.ofNullable(o.getSort()).orElse(1)));
        assistantMockDataModels.forEach(dataModel -> {
            List ketList = (List)dataModel.getQuestionKey().get(key);
            if (!ketList.isEmpty()) {
                if (ketList.stream().anyMatch(dto.getInputSentence()::contains)) {
                    this.handleSendIamMessage(dto, dataModel, key);
                    resultList.add(JsonUtil.javaObjectToJsonString(dataModel.getMockData().get(key)));
                }
            }
        });
        return resultList;
    }

    private void handleSendIamMessage(AssistantMockDataRequest dto, AssistantMockDataModel dataModel, String key) {
        if (BooleanUtils.isTrue((Boolean)dataModel.getSwitchPush())) {
            CompletableFuture.runAsync(() -> this.digiwinAimProxyService.sendUserMessage(dto.getIamUserToken(), JsonUtil.javaObjectToJsonString(dataModel.getPushData().get(key))), (Executor)this.threadPoolTaskExecutor);
        }
        if (BooleanUtils.isTrue((Boolean)dataModel.getSwitchAniaPushMessage())) {
            CompletableFuture.runAsync(() -> this.digiwinAniaProxyService.sendMessage(dto.getIamUserToken(), JsonUtil.javaObjectToJsonString(dataModel.getAniaMessageData().get(key))), (Executor)this.threadPoolTaskExecutor);
        }
    }

    private ResponseEntity<Map> execute(AthenaBasicHttpRequestHead athenaBasicHttpRequestHead, String bodyStr, String url) {
        ResponseEntity responseEntity;
        try {
            responseEntity = this.httpService.doPost(url, athenaBasicHttpRequestHead, bodyStr, Map.class);
        }
        catch (Exception e) {
            logger.error("aiAssistant api execute error :", (Throwable)e);
            throw new ServiceException("aiAssistant api execute error");
        }
        return responseEntity;
    }

    private ResponseEntity<Map> execute(AthenaBasicHttpRequestHead athenaBasicHttpRequestHead, Map<String, Object> uriVariables, String url) {
        ResponseEntity responseEntity;
        try {
            responseEntity = this.httpService.doGet(url, athenaBasicHttpRequestHead, uriVariables, Map.class);
        }
        catch (Exception e) {
            logger.error("aiAssistant api execute error :", (Throwable)e);
            throw new ServiceException("aiAssistant api execute error");
        }
        return responseEntity;
    }

    public String getAgileDataQuestionsExampleFirst(String locale) {
        String dataAssistantQuestionExamplesData = "";
        String athenaMuiUrl = AppContext.getApiUrlSetting().getMuiUrl().trim();
        dataAssistantQuestionExamplesData = Objects.equals("https://athena.digiwincloud.com", athenaMuiUrl) ? (Objects.equals(locale.trim(), Locale.SIMPLIFIED_CHINESE.toString()) ? "{\"greeting\":\"Hi\uff0c\u6211\u662f\u5a1c\u5a1c\uff0c\u5f88\u9ad8\u5174\u89c1\u9762\uff01\",\"introduce\":{\"title\":\"\u8bd5\u8bd5\u8fd9\u6837\u95ee\u6211\",\"template\":{\"text\":\"\u6211\u60f3\u770b\u300c\u67d0\u65f6\u95f4\u300d\u300c\u67d0\u516c\u53f8/\u90e8\u95e8/\u5ba2\u6237/\u4ea7\u54c1\u300d\u7684\u300c\u91d1\u989d/\u8d8b\u52bf/\u589e\u957f\u72b6\u51b5/\u6392\u540d\u72b6\u51b5\u300d\",\"stressIdxes\":[[3,39]]},\"questionExample\":{\"data\":[{\"categoryId\":\"S1C3\",\"categoryName\":\"\u63a5\u5355\",\"categoryItems\":[{\"itemId\":\"3\",\"text\":\"\u4e0a\u6708\u63a5\u5355\u6392\u540d\u524d\u4e94\u7684\u90e8\u95e8\u6709\u54ea\u4e9b?\",\"stressIdxes\":[]}]},{\"categoryId\":\"S1C1\",\"categoryName\":\"\u8425\u6536\",\"categoryItems\":[{\"itemId\":\"1\",\"text\":\"\u4e0a\u4e2a\u6708\u7684\u8425\u6536\u589e\u957f\u72b6\u51b5\u5982\u4f55\",\"stressIdxes\":[]}]},{\"categoryId\":\"S1C2\",\"categoryName\":\"\u6bdb\u5229\",\"categoryItems\":[{\"itemId\":\"2\",\"text\":\"\u53bb\u5e74\u7b2c\u56db\u5b63\u5ea6\u7684\u6bdb\u5229\u91d1\u989d\",\"stressIdxes\":[]}]}]}}}" : "{\"greeting\":\"Hi\uff0c\u6211\u662f\u5a1c\u5a1c\uff0c\u5f88\u9ad8\u8208\u898b\u9762\uff01\",\"introduce\":{\"title\":\"\u8a66\u8a66\u9019\u6a23\u554f\u6211\",\"template\":{\"text\":\"\u6211\u60f3\u770b\u300c\u67d0\u6642\u9593\u300d\u300c\u67d0\u516c\u53f8/\u90e8\u9580/\u5ba2\u6236/\u7522\u54c1\u300d\u7684\u300c\u91d1\u984d/\u8da8\u52e2/\u589e\u9577\u72c0\u6cc1/\u6392\u540d\u72c0\u6cc1\u300d\",\"stressIdxes\":[[3,39]]},\"questionExample\":{\"data\":[{\"categoryId\":\"S1C3\",\"categoryName\":\"\u63a5\u55ae\",\"categoryItems\":[{\"itemId\":\"3\",\"text\":\"\u4e0a\u6708\u63a5\u55ae\u6392\u540d\u524d\u4e94\u7684\u90e8\u9580\u6709\u54ea\u4e9b?\",\"stressIdxes\":[]}]},{\"categoryId\":\"S1C1\",\"categoryName\":\"\u71df\u6536\",\"categoryItems\":[{\"itemId\":\"1\",\"text\":\"\u4e0a\u500b\u6708\u7684\u71df\u6536\u589e\u9577\u72c0\u6cc1\u5982\u4f55\",\"stressIdxes\":[]}]},{\"categoryId\":\"S1C2\",\"categoryName\":\"\u6bdb\u5229\",\"categoryItems\":[{\"itemId\":\"2\",\"text\":\"\u53bb\u5e74\u7b2c\u56db\u5b63\u5ea6\u7684\u6bdb\u5229\u91d1\u984d\",\"stressIdxes\":[]}]}]}}}") : (Objects.equals(locale.trim(), Locale.SIMPLIFIED_CHINESE.toString()) ? "{\"greeting\":\"Hi\uff0c\u6211\u662f\u5a1c\u5a1c\uff0c\u5f88\u9ad8\u5174\u89c1\u9762\uff01\",\"introduce\":{\"title\":\"\u8bd5\u8bd5\u8fd9\u6837\u95ee\u6211\",\"template\":{\"text\":\"\u6211\u60f3\u770b\u300c\u67d0\u65f6\u95f4\u300d\u300c\u67d0\u516c\u53f8/\u90e8\u95e8/\u5ba2\u6237/\u4ea7\u54c1\u300d\u7684\u300c\u91d1\u989d/\u8d8b\u52bf/\u589e\u957f\u72b6\u51b5/\u6392\u540d\u72b6\u51b5\u300d\",\"stressIdxes\":[[3,39]]},\"questionExample\":{\"data\":[{\"categoryId\":\"S1C3\",\"categoryName\":\"\u63a5\u5355\",\"categoryItems\":[{\"itemId\":\"3\",\"text\":\"\u4e0a\u6708\u63a5\u5355\u6392\u540d\u524d\u4e94\u7684\u90e8\u95e8\u6709\u54ea\u4e9b?\",\"stressIdxes\":[]}]},{\"categoryId\":\"S1C1\",\"categoryName\":\"\u8425\u6536\",\"categoryItems\":[{\"itemId\":\"1\",\"text\":\"\u4e0a\u4e2a\u6708\u7684\u8425\u6536\u589e\u957f\u72b6\u51b5\u5982\u4f55\",\"stressIdxes\":[]}]},{\"categoryId\":\"S1C2\",\"categoryName\":\"\u6bdb\u5229\",\"categoryItems\":[{\"itemId\":\"2\",\"text\":\"\u53bb\u5e74\u7b2c\u56db\u5b63\u5ea6\u7684\u6bdb\u5229\u91d1\u989d\",\"stressIdxes\":[]}]},{\"categoryId\":\"S1C4\",\"categoryName\":\"\u56de\u6b3e\",\"categoryItems\":[{\"itemId\":\"4\",\"text\":\"\u4e0a\u6708\u7684\u56de\u6b3e\u91d1\u989d\u5982\u4f55?\",\"stressIdxes\":[]}]}]}}}" : "{\"greeting\":\"Hi\uff0c\u6211\u662f\u5a1c\u5a1c\uff0c\u5f88\u9ad8\u8208\u898b\u9762\uff01\",\"introduce\":{\"title\":\"\u8a66\u8a66\u9019\u6a23\u554f\u6211\",\"template\":{\"text\":\"\u6211\u60f3\u770b\u300c\u67d0\u6642\u9593\u300d\u300c\u67d0\u516c\u53f8/\u90e8\u9580/\u5ba2\u6236/\u7522\u54c1\u300d\u7684\u300c\u91d1\u984d/\u8da8\u52e2/\u589e\u9577\u72c0\u6cc1/\u6392\u540d\u72c0\u6cc1\u300d\",\"stressIdxes\":[[3,39]]},\"questionExample\":{\"data\":[{\"categoryId\":\"S1C3\",\"categoryName\":\"\u63a5\u55ae\",\"categoryItems\":[{\"itemId\":\"3\",\"text\":\"\u4e0a\u6708\u63a5\u55ae\u6392\u540d\u524d\u4e94\u7684\u90e8\u9580\u6709\u54ea\u4e9b?\",\"stressIdxes\":[]}]},{\"categoryId\":\"S1C1\",\"categoryName\":\"\u71df\u6536\",\"categoryItems\":[{\"itemId\":\"1\",\"text\":\"\u4e0a\u500b\u6708\u7684\u71df\u6536\u589e\u9577\u72c0\u6cc1\u5982\u4f55\",\"stressIdxes\":[]}]},{\"categoryId\":\"S1C2\",\"categoryName\":\"\u6bdb\u5229\",\"categoryItems\":[{\"itemId\":\"2\",\"text\":\"\u53bb\u5e74\u7b2c\u56db\u5b63\u5ea6\u7684\u6bdb\u5229\u91d1\u984d\",\"stressIdxes\":[]}]},{\"categoryId\":\"S1C4\",\"categoryName\":\"\u6536\u6b3e\",\"categoryItems\":[{\"itemId\":\"4\",\"text\":\"\u4e0a\u6708\u7684\u6536\u6b3e\u91d1\u984d\u5982\u4f55?\",\"stressIdxes\":[]}]}]}}}");
        return dataAssistantQuestionExamplesData;
    }

    public String getAgileDataQuestionsExample(String locale) {
        String exampleDataString = "";
        String athenaMuiUrl = AppContext.getApiUrlSetting().getMuiUrl().trim();
        exampleDataString = Objects.equals("https://athena.digiwincloud.com", athenaMuiUrl) ? (Objects.equals(locale.trim(), Locale.SIMPLIFIED_CHINESE.toString()) ? "[{\"categoryId\":\"S1C3\",\"categoryName\":\"\u89e3\u6784\u63a5\u5355\u95ee\u9898\",\"categoryItems\":[{\"itemId\":\"1\",\"text\":\"\u67e5\u4e0b\u4e0a\u4e2a\u6708\u7684\u63a5\u5355\u91d1\u989d?\",\"stressIdxes\":[]},{\"itemId\":\"2\",\"text\":\"\u53bb\u5e74\u63a5\u5355\u589e\u957f\u7387\u5982\u4f55\uff1f\",\"stressIdxes\":[]},{\"itemId\":\"3\",\"text\":\"\u4eca\u5e74\u516c\u53f8\u63a5\u5355\u8d8b\u52bf\uff1f\",\"stressIdxes\":[]},{\"itemId\":\"4\",\"text\":\"\u4e0a\u4e2a\u6708\u63a5\u5355\u6700\u597d\u7684\u4ea7\u54c1\uff1f\",\"stressIdxes\":[]},{\"itemId\":\"5\",\"text\":\"\u4e0a\u6708\u524d\u4e94\u5927\u5ba2\u6237\u63a5\u5355\u91d1\u989d\uff1f\",\"stressIdxes\":[]},{\"itemId\":\"6\",\"text\":\"\u53bb\u5e74\u63a5\u5355\u6700\u5c11\u7684\u4e09\u4e2a\u4e1a\u52a1\u5458\uff1f\",\"stressIdxes\":[]},{\"itemId\":\"7\",\"text\":\"\u4eca\u5e74\u8ba2\u5355\u91d1\u989d\u6700\u591a\u7684\u4e09\u4e2a\u90e8\u95e8\uff1f\",\"stressIdxes\":[]},{\"itemId\":\"8\",\"text\":\"\u4eca\u5e74\u5df2\u8d85\u671f\u7684\u91d1\u989d\u6709\u591a\u5c11\",\"stressIdxes\":[]}]},{\"categoryId\":\"S1C1\",\"categoryName\":\"\u89e3\u6784\u8425\u6536\u95ee\u9898\",\"categoryItems\":[{\"itemId\":\"1\",\"text\":\"\u4eca\u5e74\u8425\u6536\u603b\u989d\",\"stressIdxes\":[]},{\"itemId\":\"2\",\"text\":\"\u4eca\u5e74\u8425\u6536\u91d1\u989d\u8d8b\u52bf\uff1f\",\"stressIdxes\":[]},{\"itemId\":\"3\",\"text\":\"\u4e0a\u6708\u8425\u6536\u8ddf\u53bb\u5e74\u5bf9\u6bd4\u6709\u4ec0\u4e48\u589e\u957f\uff1f\",\"stressIdxes\":[]},{\"itemId\":\"4\",\"text\":\"\u53bb\u5e74\u5404\u90e8\u95e8\u8425\u6536\u72b6\u51b5\",\"stressIdxes\":[]},{\"itemId\":\"5\",\"text\":\"\u53bb\u5e74\u8425\u6536\u4e1a\u7ee9\u57ab\u5e95\u76845\u4e2a\u4ea7\u54c1\u662f\u54ea\u4e9b\uff1f\",\"stressIdxes\":[]},{\"itemId\":\"6\",\"text\":\"\u53bb\u5e74\u8425\u6536\u8d21\u732e\u6700\u5dee5\u4e2a\u5ba2\u6237\",\"stressIdxes\":[]},{\"itemId\":\"7\",\"text\":\"\u53bb\u5e74\u5355\u4ef7\u6ce2\u52a8\u524d\u4e94\u4ea7\u54c1\",\"stressIdxes\":[]}]},{\"categoryId\":\"S1C2\",\"categoryName\":\"\u89e3\u6784\u6bdb\u5229\u95ee\u9898\",\"categoryItems\":[{\"itemId\":\"1\",\"text\":\"\u5e2e\u6211\u67e5\u4e00\u4e0b\u4e0a\u4e2a\u6708\u7684\u6bdb\u5229\u91d1\u989d\",\"stressIdxes\":[]},{\"itemId\":\"2\",\"text\":\"\u4eca\u5e74\u516c\u53f8\u7684\u6bdb\u5229\u589e\u957f\u5bf9\u6bd4\u53bb\u5e74\u7684\u53d8\u5316\",\"stressIdxes\":[]},{\"itemId\":\"4\",\"text\":\"\u53bb\u5e74\u4e0a\u534a\u5e74\u6bdb\u5229\u91d1\u989d\u6392\u540d\u524d\u4e94\u7684\u5ba2\u6237\",\"stressIdxes\":[]}]},{\"categoryId\":\"S1C4\",\"categoryName\":\"\u89e3\u6784\u51fa\u8d27\u95ee\u9898\",\"categoryItems\":[{\"itemId\":\"1\",\"text\":\"\u4e0a\u6708\u7684\u4ea4\u8d27\u51c6\u786e\u7387\u600e\u4e48\u6837\",\"stressIdxes\":[]}]}]" : "[{\"categoryId\":\"S1C3\",\"categoryName\":\"\u89e3\u69cb\u63a5\u55ae\u554f\u984c\",\"categoryItems\":[{\"itemId\":\"1\",\"text\":\"\u67e5\u4e0b\u4e0a\u500b\u6708\u7684\u63a5\u55ae\u91d1\u984d?\",\"stressIdxes\":[]},{\"itemId\":\"2\",\"text\":\"\u53bb\u5e74\u63a5\u55ae\u589e\u9577\u7387\u5982\u4f55\uff1f\",\"stressIdxes\":[]},{\"itemId\":\"3\",\"text\":\"\u4eca\u5e74\u516c\u53f8\u63a5\u55ae\u8da8\u52e2\uff1f\",\"stressIdxes\":[]},{\"itemId\":\"4\",\"text\":\"\u4e0a\u500b\u6708\u63a5\u55ae\u6700\u597d\u7684\u7522\u54c1\uff1f\",\"stressIdxes\":[]},{\"itemId\":\"5\",\"text\":\"\u4e0a\u6708\u524d\u4e94\u5927\u5ba2\u6236\u63a5\u55ae\u91d1\u984d\uff1f\",\"stressIdxes\":[]},{\"itemId\":\"6\",\"text\":\"\u53bb\u5e74\u63a5\u55ae\u6700\u5c11\u7684\u4e09\u500b\u696d\u52d9\u54e1\uff1f\",\"stressIdxes\":[]},{\"itemId\":\"7\",\"text\":\"\u4eca\u5e74\u8a02\u55ae\u91d1\u984d\u6700\u591a\u7684\u4e09\u500b\u90e8\u9580\uff1f\",\"stressIdxes\":[]},{\"itemId\":\"8\",\"text\":\"\u4eca\u5e74\u5df2\u8d85\u671f\u7684\u91d1\u984d\u6709\u591a\u5c11\",\"stressIdxes\":[]}]},{\"categoryId\":\"S1C1\",\"categoryName\":\"\u89e3\u69cb\u71df\u6536\u554f\u984c\",\"categoryItems\":[{\"itemId\":\"1\",\"text\":\"\u4eca\u5e74\u71df\u6536\u7e3d\u984d\",\"stressIdxes\":[]},{\"itemId\":\"2\",\"text\":\"\u4eca\u5e74\u71df\u6536\u91d1\u984d\u8da8\u52e2\uff1f\",\"stressIdxes\":[]},{\"itemId\":\"3\",\"text\":\"\u4e0a\u6708\u71df\u6536\u8ddf\u53bb\u5e74\u5c0d\u6bd4\u6709\u4ec0\u9ebc\u589e\u9577\uff1f\",\"stressIdxes\":[]},{\"itemId\":\"4\",\"text\":\"\u53bb\u5e74\u5404\u90e8\u9580\u71df\u6536\u72c0\u6cc1\",\"stressIdxes\":[]},{\"itemId\":\"5\",\"text\":\"\u53bb\u5e74\u71df\u6536\u696d\u7e3e\u588a\u5e95\u76845\u500b\u7522\u54c1\u662f\u54ea\u4e9b\uff1f\",\"stressIdxes\":[]},{\"itemId\":\"6\",\"text\":\"\u53bb\u5e74\u71df\u6536\u8ca2\u737b\u6700\u5dee5\u500b\u5ba2\u6236\",\"stressIdxes\":[]},{\"itemId\":\"7\",\"text\":\"\u53bb\u5e74\u55ae\u50f9\u6ce2\u52d5\u524d\u4e94\u7522\u54c1\",\"stressIdxes\":[]}]},{\"categoryId\":\"S1C2\",\"categoryName\":\"\u89e3\u69cb\u6bdb\u5229\u554f\u984c\",\"categoryItems\":[{\"itemId\":\"1\",\"text\":\"\u5e6b\u6211\u67e5\u4e00\u4e0b\u4e0a\u500b\u6708\u7684\u6bdb\u5229\u91d1\u984d\",\"stressIdxes\":[]},{\"itemId\":\"2\",\"text\":\"\u4eca\u5e74\u516c\u53f8\u7684\u6bdb\u5229\u589e\u9577\u5c0d\u6bd4\u53bb\u5e74\u7684\u8b8a\u5316\",\"stressIdxes\":[]},{\"itemId\":\"4\",\"text\":\"\u53bb\u5e74\u4e0a\u534a\u5e74\u6bdb\u5229\u91d1\u984d\u6392\u540d\u524d\u4e94\u7684\u5ba2\u6236\",\"stressIdxes\":[]}]},{\"categoryId\":\"S1C4\",\"categoryName\":\"\u89e3\u69cb\u51fa\u8ca8\u554f\u984c\",\"categoryItems\":[{\"itemId\":\"1\",\"text\":\"\u4e0a\u6708\u7684\u4ea4\u8ca8\u6e96\u78ba\u7387\u600e\u9ebc\u6a23\",\"stressIdxes\":[]}]}]") : (Objects.equals(locale.trim(), Locale.SIMPLIFIED_CHINESE.toString()) ? "[{\"categoryId\":\"S1C3\",\"categoryName\":\"\u89e3\u6784\u63a5\u5355\u95ee\u9898\",\"categoryItems\":[{\"itemId\":\"1\",\"text\":\"\u67e5\u4e0b\u4e0a\u4e2a\u6708\u7684\u63a5\u5355\u91d1\u989d?\",\"stressIdxes\":[]},{\"itemId\":\"2\",\"text\":\"\u53bb\u5e74\u63a5\u5355\u589e\u957f\u7387\u5982\u4f55\uff1f\",\"stressIdxes\":[]},{\"itemId\":\"3\",\"text\":\"\u4eca\u5e74\u516c\u53f8\u63a5\u5355\u8d8b\u52bf\uff1f\",\"stressIdxes\":[]},{\"itemId\":\"4\",\"text\":\"\u4e0a\u4e2a\u6708\u63a5\u5355\u6700\u597d\u7684\u4ea7\u54c1\uff1f\",\"stressIdxes\":[]},{\"itemId\":\"5\",\"text\":\"\u4e0a\u6708\u524d\u4e94\u5927\u5ba2\u6237\u63a5\u5355\u91d1\u989d\uff1f\",\"stressIdxes\":[]},{\"itemId\":\"6\",\"text\":\"\u53bb\u5e74\u63a5\u5355\u6700\u5c11\u7684\u4e09\u4e2a\u4e1a\u52a1\u5458\uff1f\",\"stressIdxes\":[]},{\"itemId\":\"7\",\"text\":\"\u4eca\u5e74\u8ba2\u5355\u91d1\u989d\u6700\u591a\u7684\u4e09\u4e2a\u90e8\u95e8\uff1f\",\"stressIdxes\":[]},{\"itemId\":\"8\",\"text\":\"\u4eca\u5e74\u5df2\u8d85\u671f\u7684\u91d1\u989d\u6709\u591a\u5c11\",\"stressIdxes\":[]},{\"itemId\":\"9\",\"text\":\"\u4e0a\u6708\u63a5\u5355\u5355\u4ef7\u4f4e\u4e8e\u6807\u51c6\u552e\u4ef7\u7684\u8ba2\u5355\u6709\u54ea\u4e9b\uff1f\",\"stressIdxes\":[]}]},{\"categoryId\":\"S1C1\",\"categoryName\":\"\u89e3\u6784\u8425\u6536\u95ee\u9898\",\"categoryItems\":[{\"itemId\":\"1\",\"text\":\"\u4eca\u5e74\u8425\u6536\u603b\u989d\",\"stressIdxes\":[]},{\"itemId\":\"2\",\"text\":\"\u4eca\u5e74\u8425\u6536\u91d1\u989d\u8d8b\u52bf\uff1f\",\"stressIdxes\":[]},{\"itemId\":\"3\",\"text\":\"\u4e0a\u6708\u8425\u6536\u8ddf\u53bb\u5e74\u5bf9\u6bd4\u6709\u4ec0\u4e48\u589e\u957f\uff1f\",\"stressIdxes\":[]},{\"itemId\":\"4\",\"text\":\"\u53bb\u5e74\u5404\u90e8\u95e8\u8425\u6536\u72b6\u51b5\",\"stressIdxes\":[]},{\"itemId\":\"5\",\"text\":\"\u53bb\u5e74\u8425\u6536\u4e1a\u7ee9\u57ab\u5e95\u76845\u4e2a\u4ea7\u54c1\u662f\u54ea\u4e9b\uff1f\",\"stressIdxes\":[]},{\"itemId\":\"6\",\"text\":\"\u53bb\u5e74\u8425\u6536\u8d21\u732e\u6700\u5dee5\u4e2a\u5ba2\u6237\",\"stressIdxes\":[]},{\"itemId\":\"7\",\"text\":\"\u53bb\u5e74\u5355\u4ef7\u6ce2\u52a8\u524d\u4e94\u4ea7\u54c1\",\"stressIdxes\":[]}]},{\"categoryId\":\"S1C2\",\"categoryName\":\"\u89e3\u6784\u6bdb\u5229\u95ee\u9898\",\"categoryItems\":[{\"itemId\":\"1\",\"text\":\"\u5e2e\u6211\u67e5\u4e00\u4e0b\u4e0a\u4e2a\u6708\u7684\u6bdb\u5229\u91d1\u989d\",\"stressIdxes\":[]},{\"itemId\":\"2\",\"text\":\"\u4eca\u5e74\u516c\u53f8\u7684\u6bdb\u5229\u589e\u957f\u5bf9\u6bd4\u53bb\u5e74\u7684\u53d8\u5316\",\"stressIdxes\":[]},{\"itemId\":\"3\",\"text\":\"\u4eca\u5e74\u6bdb\u5229\u6700\u597d\u7684\u4ea7\u54c1\uff1f\",\"stressIdxes\":[]},{\"itemId\":\"4\",\"text\":\"\u53bb\u5e74\u4e0a\u534a\u5e74\u6bdb\u5229\u91d1\u989d\u6392\u540d\u524d\u4e94\u7684\u5ba2\u6237\",\"stressIdxes\":[]}]},{\"categoryId\":\"S1C4\",\"categoryName\":\"\u89e3\u6784\u56de\u6b3e\u95ee\u9898\",\"categoryItems\":[{\"itemId\":\"1\",\"text\":\"\u53bb\u5e74\u7684\u56de\u6b3e\u603b\u989d\uff1f\",\"stressIdxes\":[]},{\"itemId\":\"2\",\"text\":\"\u4eca\u5e74\u5404\u4e2a\u5ba2\u6237\u56de\u6b3e\u603b\u91d1\u989d\uff1f\",\"stressIdxes\":[]},{\"itemId\":\"3\",\"text\":\"\u4e0a\u4e2a\u6708\u5404\u4e1a\u52a1\u5458\u7684\u603b\u7ed3\u6b3e\u91d1\u989d\uff1f\",\"stressIdxes\":[]}]},{\"categoryId\":\"S1C4\",\"categoryName\":\"\u89e3\u6784\u51fa\u8d27\u95ee\u9898\",\"categoryItems\":[{\"itemId\":\"1\",\"text\":\"\u4e0a\u6708\u7684\u4ea4\u8d27\u51c6\u786e\u7387\u600e\u4e48\u6837\",\"stressIdxes\":[]}]}]" : "[{\"categoryId\":\"S1C3\",\"categoryName\":\"\u89e3\u69cb\u63a5\u55ae\u554f\u984c\",\"categoryItems\":[{\"itemId\":\"1\",\"text\":\"\u67e5\u4e0b\u4e0a\u500b\u6708\u7684\u63a5\u55ae\u91d1\u984d?\",\"stressIdxes\":[]},{\"itemId\":\"2\",\"text\":\"\u53bb\u5e74\u63a5\u55ae\u589e\u9577\u7387\u5982\u4f55\uff1f\",\"stressIdxes\":[]},{\"itemId\":\"3\",\"text\":\"\u4eca\u5e74\u516c\u53f8\u63a5\u55ae\u8da8\u52e2\uff1f\",\"stressIdxes\":[]},{\"itemId\":\"4\",\"text\":\"\u4e0a\u500b\u6708\u63a5\u55ae\u6700\u597d\u7684\u7522\u54c1\uff1f\",\"stressIdxes\":[]},{\"itemId\":\"5\",\"text\":\"\u4e0a\u6708\u524d\u4e94\u5927\u5ba2\u6236\u63a5\u55ae\u91d1\u984d\uff1f\",\"stressIdxes\":[]},{\"itemId\":\"6\",\"text\":\"\u53bb\u5e74\u63a5\u55ae\u6700\u5c11\u7684\u4e09\u500b\u696d\u52d9\u54e1\uff1f\",\"stressIdxes\":[]},{\"itemId\":\"7\",\"text\":\"\u4eca\u5e74\u8a02\u55ae\u91d1\u984d\u6700\u591a\u7684\u4e09\u500b\u90e8\u9580\uff1f\",\"stressIdxes\":[]},{\"itemId\":\"8\",\"text\":\"\u4eca\u5e74\u5df2\u8d85\u671f\u7684\u91d1\u984d\u6709\u591a\u5c11\",\"stressIdxes\":[]},{\"itemId\":\"9\",\"text\":\"\u4e0a\u6708\u63a5\u55ae\u55ae\u50f9\u4f4e\u65bc\u6a19\u6e96\u552e\u50f9\u7684\u8a02\u55ae\u6709\u54ea\u4e9b\uff1f\",\"stressIdxes\":[]}]},{\"categoryId\":\"S1C1\",\"categoryName\":\"\u89e3\u69cb\u71df\u6536\u554f\u984c\",\"categoryItems\":[{\"itemId\":\"1\",\"text\":\"\u4eca\u5e74\u71df\u6536\u7e3d\u984d\",\"stressIdxes\":[]},{\"itemId\":\"2\",\"text\":\"\u4eca\u5e74\u71df\u6536\u91d1\u984d\u8da8\u52e2\uff1f\",\"stressIdxes\":[]},{\"itemId\":\"3\",\"text\":\"\u4e0a\u6708\u71df\u6536\u8ddf\u53bb\u5e74\u5c0d\u6bd4\u6709\u4ec0\u9ebc\u589e\u9577\uff1f\",\"stressIdxes\":[]},{\"itemId\":\"4\",\"text\":\"\u53bb\u5e74\u5404\u90e8\u9580\u71df\u6536\u72c0\u6cc1\",\"stressIdxes\":[]},{\"itemId\":\"5\",\"text\":\"\u53bb\u5e74\u71df\u6536\u696d\u7e3e\u588a\u5e95\u76845\u500b\u7522\u54c1\u662f\u54ea\u4e9b\uff1f\",\"stressIdxes\":[]},{\"itemId\":\"6\",\"text\":\"\u53bb\u5e74\u71df\u6536\u8ca2\u737b\u6700\u5dee5\u500b\u5ba2\u6236\",\"stressIdxes\":[]},{\"itemId\":\"7\",\"text\":\"\u53bb\u5e74\u55ae\u50f9\u6ce2\u52d5\u524d\u4e94\u7522\u54c1\",\"stressIdxes\":[]}]},{\"categoryId\":\"S1C2\",\"categoryName\":\"\u89e3\u69cb\u6bdb\u5229\u554f\u984c\",\"categoryItems\":[{\"itemId\":\"1\",\"text\":\"\u5e6b\u6211\u67e5\u4e00\u4e0b\u4e0a\u500b\u6708\u7684\u6bdb\u5229\u91d1\u984d\",\"stressIdxes\":[]},{\"itemId\":\"2\",\"text\":\"\u4eca\u5e74\u516c\u53f8\u7684\u6bdb\u5229\u589e\u9577\u5c0d\u6bd4\u53bb\u5e74\u7684\u8b8a\u5316\",\"stressIdxes\":[]},{\"itemId\":\"3\",\"text\":\"\u4eca\u5e74\u6bdb\u5229\u6700\u597d\u7684\u7522\u54c1\uff1f\",\"stressIdxes\":[]},{\"itemId\":\"4\",\"text\":\"\u53bb\u5e74\u4e0a\u534a\u5e74\u6bdb\u5229\u91d1\u984d\u6392\u540d\u524d\u4e94\u7684\u5ba2\u6236\",\"stressIdxes\":[]}]},{\"categoryId\":\"S1C4\",\"categoryName\":\"\u89e3\u69cb\u6536\u6b3e\u554f\u984c\",\"categoryItems\":[{\"itemId\":\"1\",\"text\":\"\u53bb\u5e74\u7684\u6536\u6b3e\u7e3d\u984d\uff1f\",\"stressIdxes\":[]},{\"itemId\":\"2\",\"text\":\"\u4eca\u5e74\u5404\u500b\u5ba2\u6236\u6536\u6b3e\u7e3d\u91d1\u984d\uff1f\",\"stressIdxes\":[]},{\"itemId\":\"3\",\"text\":\"\u4e0a\u500b\u6708\u5404\u696d\u52d9\u54e1\u7684\u7e3d\u7d50\u6b3e\u91d1\u984d\uff1f\",\"stressIdxes\":[]}]},{\"categoryId\":\"S1C4\",\"categoryName\":\"\u89e3\u69cb\u51fa\u8ca8\u554f\u984c\",\"categoryItems\":[{\"itemId\":\"1\",\"text\":\"\u4e0a\u6708\u7684\u4ea4\u8ca8\u6e96\u78ba\u7387\u600e\u9ebc\u6a23\",\"stressIdxes\":[]}]}]");
        return exampleDataString;
    }

    public String getDocumentAssistantQuestionsExample(String locale) {
        return "[]";
    }

    public String getAdministrativeQuestionsExample(String locale) {
        String exampleDataString = "";
        exampleDataString = Objects.equals(locale.trim(), Locale.SIMPLIFIED_CHINESE.toString()) ? "[{\"categoryId\":\"S1C1\",\"categoryName\":\"\u6536\u96c6\u4e8b\u9879\",\"categoryItems\":[{\"itemId\":\"1\",\"text\":\"\u5a1c\u5a1c\uff0c\u8bf7\u5e2e\u6211\u5411[\u5f20\u4e09\u3001\u674e\u56db\u3001\u738b\u4e94]\u6536\u96c6\u4e00\u4e0b[\u5468\u62a5]\",\"stressIdxes\":[[7,16],[21,24]]},{\"itemId\":\"1\",\"text\":\"\u5a1c\u5a1c\uff0c\u8bf7[\u5f20\u4e09\u3001\u674e\u56db\u3001\u738b\u4e94]\u5c06\u4ed6\u4eec\u7684[\u9879\u76ee\u8fdb\u5ea6]\u56de\u62a5\u7ed9\u6211\",\"stressIdxes\":[[4,13],[18,23]]},{\"itemId\":\"1\",\"text\":\"\u5a1c\u5a1c\uff0c\u8bf7[\u5f20\u4e09\u3001\u674e\u56db\u3001\u738b\u4e94]\u4ed6\u4eec\u5728[A\u3001B\u3001C]\u4e2d\u8fdb\u884c\u6295\u7968\",\"stressIdxes\":[[4,13],[17,23]]}]},{\"categoryId\":\"S1C2\",\"categoryName\":\"\u901a\u77e5\u4e8b\u9879\",\"categoryItems\":[{\"itemId\":\"2\",\"text\":\"\u5a1c\u5a1c\uff0c\u8bf7\u5e2e\u6211\u901a\u77e5[\u5f20\u4e09\u3001\u674e\u56db\u3001\u738b\u4e94][\u660e\u5929\u8bb0\u5f97\u65e9\u70b9\u5230]\",\"stressIdxes\":[[8,26]]},{\"itemId\":\"2\",\"text\":\"\u5a1c\u5a1c\uff0c\u8bf7\u5e2e\u6211\u901a\u77e5[\u8bbe\u8ba1\u90e8]\u53d1\u9001\u4e00\u4e2a\u901a\u77e5\uff0c\u8be6\u60c5\u89c1\u9644\u4ef6\",\"stressIdxes\":[[8,12]]}]}]" : "[{\"categoryId\":\"S1C1\",\"categoryName\":\"\u6536\u96c6\u4e8b\u9805\",\"categoryItems\":[{\"itemId\":\"1\",\"text\":\"\u5a1c\u5a1c\uff0c\u8acb\u5e6b\u6211\u5411[\u5f35\u4e09\u3001\u674e\u56db\u3001\u738b\u4e94]\u6536\u96c6\u4e00\u4e0b[\u9031\u5831]\",\"stressIdxes\":[[7,16],[21,24]]},{\"itemId\":\"1\",\"text\":\"\u5a1c\u5a1c\uff0c\u8acb[\u5f35\u4e09\u3001\u674e\u56db\u3001\u738b\u4e94]\u5c07\u4ed6\u5011\u7684[\u5c08\u6848\u9032\u5ea6]\u56de\u5831\u7d66\u6211\",\"stressIdxes\":[[4,13],[18,23]]},{\"itemId\":\"1\",\"text\":\"\u5a1c\u5a1c\uff0c\u8acb[\u5f35\u4e09\u3001\u674e\u56db\u3001\u738b\u4e94]\u4ed6\u5011\u5728[A\u3001B\u3001C]\u4e2d\u9032\u884c\u6295\u7968\",\"stressIdxes\":[[4,13],[17,23]]}]},{\"categoryId\":\"S1C2\",\"categoryName\":\"\u901a\u77e5\u4e8b\u9805\",\"categoryItems\":[{\"itemId\":\"2\",\"text\":\"\u5a1c\u5a1c\uff0c\u8acb\u5e6b\u6211\u901a\u77e5[\u5f35\u4e09\u3001\u674e\u56db\u3001\u738b\u4e94][\u660e\u5929\u8a18\u5f97\u65e9\u9ede\u5230]\",\"stressIdxes\":[[8,26]]},{\"itemId\":\"2\",\"text\":\"\u5a1c\u5a1c\uff0c\u8acb\u5e6b\u6211\u901a\u77e5[\u8a2d\u8a08\u90e8]\u767c\u9001\u4e00\u500b\u901a\u77e5\uff0c\u8a73\u60c5\u898b\u9644\u6a94\",\"stressIdxes\":[[8,12]]}]}]";
        return exampleDataString;
    }

    public List<KnowledgeMapsDataSubscriptionModel> getDataSubscriptionList(DataSubscriptionRequest request) {
        List subscriptionList = this.knowledgeMapsProxyService.queryDataSubscriptionList(request);
        subscriptionList.sort((a, b) -> Boolean.compare(b.getScheduleParam().getUndeletable(), a.getScheduleParam().getUndeletable()));
        return subscriptionList;
    }

    public Boolean addOrUpdateDataSubscription(DataSubscriptionRequest request) {
        KnowledgeMapsDataSubscriptionModel dataSubscriptionModel = request.getDataSubscriptionModel();
        KnowledgeMapsDataSubscriptionModel.ScheduleParam scheduleParam = dataSubscriptionModel.getScheduleParam();
        scheduleParam.setUserId(request.getUserId());
        scheduleParam.setUserName(request.getUserName());
        scheduleParam.setShowType(request.getShowType());
        scheduleParam.setSnapshotId(request.getSnapshotId());
        if (CollectionUtils.isEmpty((Collection)request.getMetricIdList()) && CollectionUtils.isEmpty((Collection)request.getDatasetIdList())) {
            if (StringUtils.isBlank((CharSequence)request.getSceneCode())) {
                Assert.notNull((Object)request.getSnapshotId(), (String)"snapshotId must not null");
                String sceneCode = this.adtProxyService.getSceneCode(request.getIamUserToken(), request.getSnapshotId());
                if (StringUtils.isBlank((CharSequence)sceneCode)) {
                    return false;
                }
                scheduleParam.setSceneCode(sceneCode);
            } else {
                scheduleParam.setSceneCode(request.getSceneCode());
            }
        } else {
            if (ObjectUtil.isEmpty((Object)scheduleParam.getSolutionStep())) {
                AgileDataApiRequest agileDataApiRequest = AgileDataApiRequest.builder().iamUserToken(request.getIamUserToken()).tenantId(request.getTenantId()).locale(request.getLocale()).dataId(request.getSnapshotId()).build();
                Map solutionStepBySnapshotMap = this.adtProxyService.getSolutionStepBySnapshotId(agileDataApiRequest);
                if (ObjectUtil.isEmpty((Object)solutionStepBySnapshotMap)) {
                    return false;
                }
                scheduleParam.setSolutionStep(solutionStepBySnapshotMap);
            }
            if (!CollectionUtils.isEmpty((Collection)request.getDatasetIdList())) {
                scheduleParam.setDatasetIdList(request.getDatasetIdList());
            }
            if (!CollectionUtils.isEmpty((Collection)request.getMetricIdList())) {
                scheduleParam.setMetricIdList(request.getMetricIdList());
            }
        }
        return this.knowledgeMapsProxyService.addDataSubscriptionConfig(request);
    }

    public Boolean removeDataSubscription(DataSubscriptionRequest request) {
        Assert.notNull((Object)request.getQuestion(), (String)"question must not null");
        if (CollectionUtils.isEmpty((Collection)request.getMetricIdList()) && CollectionUtils.isEmpty((Collection)request.getDatasetIdList())) {
            this.getSceneCode(request);
            if (StringUtils.isBlank((CharSequence)request.getSceneCode())) {
                return false;
            }
        }
        return this.knowledgeMapsProxyService.removeDataSubscriptionConfig(request);
    }

    public KnowledgeMapsDataSubscriptionModel getDataSubscriptionInfo(String iamUserToken, String ruleId) {
        return this.knowledgeMapsProxyService.singleDataSubscriptionConfig(iamUserToken, ruleId);
    }

    public Boolean canDataSubscription(DataSubscriptionRequest request) {
        Assert.notNull((Object)request.getLocale(), (String)"locale must not null");
        Assert.notNull((Object)request.getQuestion(), (String)"question must not null");
        this.getSceneCode(request);
        List dataSubscriptionModels = this.knowledgeMapsProxyService.queryDataSubscriptionList(request);
        return CollectionUtils.isEmpty((Collection)dataSubscriptionModels);
    }

    public List<KnowledgeMapsDataCollectionModel> queryDataCollectConfig(DataCollectConfigQueryDTO queryDTO) {
        return this.knowledgeMapsProxyService.queryDataCollectConfig(queryDTO);
    }

    public ApiResponse addDataCollectConfig(DataCollectionAddRequest request) {
        String sceneCode = request.getSceneCode();
        if (CollectionUtils.isEmpty((Collection)request.getMetricIdList()) && CollectionUtils.isEmpty((Collection)request.getDatasetIdList()) && request.getIfAdd().booleanValue() && StringUtils.isBlank((CharSequence)(sceneCode = this.adtProxyService.getSceneCode(request.getIamUserToken(), request.getSnapshotId())))) {
            return ApiResponse.buildError((String)this.localeService.getLanguageValue(request.getLocale(), "\u6dfb\u52a0\u5931\u8d25,\u65e0\u5bf9\u5e94\u573a\u666f"));
        }
        ArrayList<KnowledgeMapsDataCollectionModel.DataCollectQuestion> dataCollectQuestions = new ArrayList<KnowledgeMapsDataCollectionModel.DataCollectQuestion>(1);
        KnowledgeMapsDataCollectionModel.DataCollectQuestion dataCollectQuestion = new KnowledgeMapsDataCollectionModel.DataCollectQuestion();
        dataCollectQuestion.setQuestion(request.getQuestion());
        dataCollectQuestion.setSceneCode(sceneCode);
        dataCollectQuestion.setMetricIdList(request.getMetricIdList());
        dataCollectQuestion.setGroupType(request.getGroupType());
        dataCollectQuestion.setGroupValue(request.getGroupValue());
        dataCollectQuestion.setGroupId(request.getGroupId());
        dataCollectQuestion.setDatasetIdList(request.getDatasetIdList());
        dataCollectQuestion.setQuestionId(request.getQuestionId());
        dataCollectQuestion.setShowType(request.getShowType());
        dataCollectQuestion.setSnapshotId(request.getSnapshotId());
        Map solutionStep = request.getSolutionStep();
        if (ObjectUtil.isEmpty((Object)solutionStep)) {
            AgileDataApiRequest agileDataApiRequest = AgileDataApiRequest.builder().iamUserToken(request.getIamUserToken()).tenantId(request.getTenantId()).locale(request.getLocale()).dataId(request.getSnapshotId()).build();
            Map solutionStepBySnapshotMap = this.adtProxyService.getSolutionStepBySnapshotId(agileDataApiRequest);
            dataCollectQuestion.setSolutionStep(solutionStepBySnapshotMap);
        } else {
            dataCollectQuestion.setSolutionStep(solutionStep);
        }
        dataCollectQuestions.add(dataCollectQuestion);
        request.setDataCollectQuestions(dataCollectQuestions);
        request.setSolutionStep(null);
        request.setDatasetIdList(null);
        request.setQuestionId(null);
        KnowledgeMapsResponse knowledgeMapsResponse = this.knowledgeMapsProxyService.addDataCollectConfig(request);
        if (HttpStatus.OK.value() == knowledgeMapsResponse.getStatus().intValue()) {
            return ApiResponse.buildOK((String)this.localeService.getLanguageValue(request.getLocale(), "\u6536\u85cf\u6210\u529f")).setData((Object)sceneCode);
        }
        if (StringUtil.isNotEmpty((CharSequence)knowledgeMapsResponse.getErrorCode()) && ("P.KG.500.99999".equals(knowledgeMapsResponse.getErrorCode()) || "P.KG.500.99990".equals(knowledgeMapsResponse.getErrorCode()))) {
            return ApiResponse.buildError((String)this.localeService.getLanguageValue(request.getLocale(), knowledgeMapsResponse.getErrorMessage()));
        }
        return ApiResponse.buildError((String)this.localeService.getLanguageValue(request.getLocale(), "\u6dfb\u52a0\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5"));
    }

    public ApiResponse removeDataCollectConfig(DataCollectionRemoveRequest request) {
        if (BooleanUtils.isFalse((Boolean)this.knowledgeMapsProxyService.removeDataCollectConfig(request))) {
            return ApiResponse.buildError((String)this.localeService.getLanguageValue(request.getLocale(), "\u5220\u9664\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5"));
        }
        return ApiResponse.buildOK();
    }

    public ExampleModel getExample(String iamUserToken, String locale) {
        ExampleModel model = new ExampleModel();
        List sceneIntentionModels = this.knowledgeMapsProxyService.querySceneIntention(iamUserToken, locale);
        if (CollectionUtils.isEmpty((Collection)sceneIntentionModels)) {
            return null;
        }
        List list = this.getQuestionsExampleModels(sceneIntentionModels, Boolean.valueOf(false), locale);
        if (list.size() > 4) {
            list = list.subList(0, 4);
        }
        ExampleModel.Example questionExample = new ExampleModel.Example();
        questionExample.setData(list);
        ExampleModel.Template template = new ExampleModel.Template();
        ArrayList<List<Integer>> stressIdxes = new ArrayList<List<Integer>>();
        stressIdxes.add(Arrays.asList(3, 39));
        template.setStressIdxes(stressIdxes);
        if (Objects.equals(locale.trim(), Locale.SIMPLIFIED_CHINESE.toString())) {
            model.setGreeting("Hi,\u6211\u662f\u5a1c\u5a1c,\u5f88\u9ad8\u5174\u89c1\u9762!");
            template.setText("\u6211\u60f3\u770b\u300c\u67d0\u65f6\u95f4\u300d\u300c\u67d0\u516c\u53f8/\u90e8\u95e8/\u5ba2\u6237/\u4ea7\u54c1\u300d\u7684\u300c\u91d1\u989d/\u8d8b\u52bf/\u589e\u957f\u72b6\u51b5/\u6392\u540d\u72b6\u51b5\u300d");
        } else {
            model.setGreeting("Hi,\u6211\u662f\u5a1c\u5a1c,\u5f88\u9ad8\u8208\u898b\u9762!");
            template.setText("\u6211\u60f3\u770b\u300c\u67d0\u6642\u9593\u300d\u300c\u67d0\u516c\u53f8/\u90e8\u9580/\u5ba2\u6236/\u7523\u54c1\u300d\u7684\u300c\u91d1\u984d/\u8da8\u52e2/\u589e\u9577\u72c0\u6cc1/\u6392\u540d\u72c0\u6cc1\u300d");
        }
        ExampleModel.Introduce introduce = new ExampleModel.Introduce();
        introduce.setTitle(this.localeService.getLanguageValue(locale, "\u8bd5\u8bd5\u8fd9\u6837\u95ee\u6211"));
        introduce.setTemplate(template);
        introduce.setQuestionExample(questionExample);
        model.setIntroduce(introduce);
        return model;
    }

    public List<QuestionsExampleModel> querySceneIntentions(String iamUserToken, String locale) {
        List sceneIntentionModels = this.knowledgeMapsProxyService.querySceneIntentions(iamUserToken, locale);
        if (CollectionUtils.isEmpty((Collection)sceneIntentionModels)) {
            return new ArrayList<QuestionsExampleModel>();
        }
        return this.getQuestionsExampleModels(sceneIntentionModels, Boolean.valueOf(true), locale);
    }

    public ApiResponse processMessage(ProcessMessageRequest request) {
        DigiwinAdtProcessMessage response = this.adtProxyService.processMessage(request);
        if (null == response) {
            return ApiResponse.buildError();
        }
        if (response.getAlarm().booleanValue()) {
            return ApiResponse.buildError((String)response.getMsg());
        }
        return ApiResponse.buildOK().setData((Object)response);
    }

    public List<EchoGmcBulletinResultDTO> queryReadBulletinList(ApiRequest apiRequest) {
        return this.echoService.queryReadBulletinList(apiRequest);
    }

    public EchoGmcBulletinUnReadResultDTO queryUnreadBulletinList(ApiRequest apiRequest) {
        return this.echoService.queryUnreadBulletinList(apiRequest);
    }

    public DigiwinCacApplicationAuthorizationInformation queryApplicationAuthorizationInformation(ApiRequest request) {
        DigiwinCacApplicationAuthorizationInformation information = this.adtProxyService.queryCalculateCacByConfig(request);
        if (information == null) {
            return null;
        }
        information.setQuantityUsage(Integer.valueOf(information.getTotalUsage() - information.getRemainingUsage()));
        return information;
    }

    public Boolean saveUserCloseTrafficThresholdAlert(AgileDataCalculateConfigRequest request) {
        return this.adtProxyService.saveUserCloseTrafficThresholdAlert(request);
    }

    public Boolean checkIsItUser(ApiRequest apiRequest) {
        return this.tddService.checkIsItUser(apiRequest);
    }

    public DigiwinAdtTenantApplicationBilling getTenantApplicationIsBilling(ApiRequest request) {
        return this.adtProxyService.getTenantApplicationIsBilling(request);
    }

    public Map<String, Object> getInfoAndSchemaByMessageId(EchoInformationModelQueryDTO queryDTO) {
        return this.echoService.getInfoAndSchemaByMessageId(queryDTO);
    }

    public List<EchoPageConfigProductBulletinResultDTO> queryProductBulletinList(EchoPageConfigProductBulletinQueryDTO queryDTO) {
        return this.echoService.queryProductBulletinList(queryDTO);
    }

    public EchoOpeningRemarksConfigResultDTO queryOpeningRemarksConfig(EchoPageConfigProductBulletinQueryDTO queryDTO) {
        if ("DigiwinGptDemo".equalsIgnoreCase(queryDTO.getTenantId())) {
            EchoOpeningRemarksConfigResultDTO resultDTO = new EchoOpeningRemarksConfigResultDTO();
            if (Locale.TRADITIONAL_CHINESE.toString().equalsIgnoreCase(queryDTO.getLocale())) {
                resultDTO.setTitle("Hi~ \u5a1c\u5a1c" + queryDTO.getAssistantName() + "\u4e3a\u60a8\u670d\u52a1");
                resultDTO.setContent("\u4f60\u53ef\u5728\u5e95\u90e8\u9ede\u64ca\u201c+\u201d\u865f\uff0c\u4e0a\u50b3excel\u6587\u4ef6\uff0c\u6211\u80fd\u5e6b\u4f60\u9032\u884c\u67e5\u8a62\u3001\u6578\u64da\u7d71\u8a08\u7b49\u5206\u6790");
            } else {
                resultDTO.setTitle("Hi~ \u5a1c\u5a1c" + queryDTO.getAssistantName() + "\u4e3a\u60a8\u670d\u52a1");
                resultDTO.setContent("\u4f60\u53ef\u5728\u5e95\u90e8\u70b9\u51fb\u300c+\u300d\u53f7\uff0c\u4e0a\u4f20Excel\u6587\u4ef6\uff0c\u6211\u80fd\u5e2e\u4f60\u8fdb\u884c\u67e5\u8be2\u3001\u6570\u636e\u7edf\u8ba1\u7b49\u5206\u6790");
            }
            return resultDTO;
        }
        return this.echoService.queryOpeningRemarksConfig(queryDTO);
    }

    public Map<String, Boolean> queryLiteTenantId(ApiRequest apiRequest) {
        String tenantId = apiRequest.getTenantId();
        boolean isHwLiteTenant = "DigiwinGptDemo".equalsIgnoreCase(tenantId);
        boolean demonstrationTenantId = "AgileDataDemo".equalsIgnoreCase(tenantId);
        boolean isAnnualReportTenant = "DigiwinNaNaDemo".equalsIgnoreCase(tenantId);
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        map.put("showAddFile", isHwLiteTenant);
        map.put("showCollectionAndKanban", !isHwLiteTenant && !isAnnualReportTenant);
        map.put("executiveAssistantUploadFileIfOpen", !demonstrationTenantId);
        return map;
    }

    public void sendLiteNanaMessage(AgileDataLiteUploadFileQueryDTO queryDTO) {
        this.adtProxyService.sendLiteNanaMessage(queryDTO);
    }

    public Boolean saveReadBulletin(BulletinRequest request) {
        return this.echoService.saveReadBulletin(request);
    }

    public EchoInformationResultDTO getExceptionInfoByMessageId(EchoInformationModelQueryDTO queryDTO) {
        List informationModelList = this.echoService.getExceptionInfoByMessageId(queryDTO);
        if (CollectionUtils.isEmpty((Collection)informationModelList)) {
            return null;
        }
        EchoInformationModel informationModel = (EchoInformationModel)informationModelList.get(0);
        if (null == informationModel) {
            return null;
        }
        if (null == informationModel.getExtend()) {
            return null;
        }
        EchoInformationResultDTO informationResultDTO = (EchoInformationResultDTO)JsonUtil.jsonStringToObject((String)informationModel.getExtend(), EchoInformationResultDTO.class);
        informationResultDTO.setSelectMultiple(informationModel.getSelectMultiple());
        informationResultDTO.setDataTipMessage(informationModel.getDataTipMessage());
        informationResultDTO.setStepAnalysis(informationModel.getStepAnalysis());
        return informationResultDTO;
    }

    public EchoLiteUploadLimitationsConfigDataResultDTO queryLiteUploadLimitationsConfig(ApiRequest apiRequest) {
        return this.echoService.queryLiteUploadLimitationsConfig(apiRequest);
    }

    public List<EchoMetricCheckMongoDataResultDTO> getMongoDbMetricInfoList(ApiRequest apiRequest) {
        return this.echoService.getMongoDbMetricInfoList(apiRequest);
    }

    public AdeDataCollectionGroupListResult queryDataCollectionGroup(DataCollectionGroupQueryDTO request) {
        return this.adeProxyService.queryDataCollectionGroup(request);
    }

    public Boolean addOrUpdateDataCollectionGroup(DataCollectionGroupAddOrUpdateDTO request) {
        return this.knowledgeMapsProxyService.addOrUpdateDataCollectionGroup(request);
    }

    public Boolean deleteDataCollectionGroup(DataCollectionGroupDeleteDTO request) {
        return this.knowledgeMapsProxyService.deleteDataCollectionGroup(request);
    }

    public List<EchoInstructionGroupResultDTO> queryCommandIntentions(ApiRequest apiRequest) {
        return this.echoService.queryCommandIntentions(apiRequest);
    }

    public EchoFuzzyMatchingConfigDataResultDTO queryFuzzyMatchingConfig(ApiRequest apiRequest) {
        return this.echoService.queryFuzzyMatchingConfig(apiRequest);
    }

    public DigiwinAdtThirdPartyAgileData getThirdPartyAgileData(ApiRequest request) {
        return this.adtProxyService.getThirdPartyAgileData(request);
    }

    private List<QuestionsExampleModel> getQuestionsExampleModels(List<KnowledgeMapsSceneIntentionModel> sceneIntentionModels, Boolean isSplice, String locale) {
        ArrayList<QuestionsExampleModel> list = new ArrayList<QuestionsExampleModel>(sceneIntentionModels.size());
        sceneIntentionModels.forEach(data -> {
            QuestionsExampleModel questionExampleModel = new QuestionsExampleModel();
            if (isSplice.booleanValue()) {
                questionExampleModel.setCategoryName(this.localeService.getLanguageValue(locale, "\u89e3\u6784") + data.getTargetName() + this.localeService.getLanguageValue(locale, "\u95ee\u9898"));
            } else {
                questionExampleModel.setCategoryName(data.getTargetName());
            }
            ArrayList categoryItems = new ArrayList();
            data.getIntentions().forEach(intention -> {
                QuestionsExampleModel.CategoryItem categoryItem = new QuestionsExampleModel.CategoryItem();
                categoryItem.setText(intention.getIntention());
                categoryItems.add(categoryItem);
            });
            questionExampleModel.setCategoryItems(categoryItems);
            list.add(questionExampleModel);
        });
        return list;
    }

    private void getSceneCode(DataSubscriptionRequest request) {
        if (StringUtils.isBlank((CharSequence)request.getSceneCode())) {
            Assert.notNull((Object)request.getSnapshotId(), (String)"snapshotId must not null");
            String sceneCode = this.adtProxyService.getSceneCode(request.getIamUserToken(), request.getSnapshotId());
            request.setSceneCode(sceneCode);
        }
    }
}

