/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.api;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;

public class ApiResponse<T>
implements Serializable {
    private static final long serialVersionUID = 1875635261853798470L;
    public static final String SUCCESS_CODE = "0";
    public static final String ERROR_CODE = "-1";
    public static final String SERVICE_ERROR_CODE = "-2";
    private String code;
    private String msg;
    private String errorMsg;
    private T data;
    private String traceId;

    public static <T> ApiResponse<T> buildOK() {
        return new ApiResponse(SUCCESS_CODE, "success");
    }

    public static <T> ApiResponse<T> buildOK(String message) {
        return new ApiResponse(SUCCESS_CODE, message);
    }

    public static <T> ApiResponse<T> buildError() {
        return new ApiResponse(ERROR_CODE, "error");
    }

    public static <T> ApiResponse<T> buildError(String message) {
        return new ApiResponse(ERROR_CODE, message);
    }

    public static <T> ApiResponse<T> buildError(String message, String errorMsg) {
        return new ApiResponse(ERROR_CODE, message, errorMsg);
    }

    public static <T> ApiResponse<T> buildServiceError(String message, String errorMsg) {
        return new ApiResponse(SERVICE_ERROR_CODE, message, errorMsg);
    }

    public static <T> ApiResponse<T> buildMockError(String message) {
        return new ApiResponse("201", message);
    }

    public ApiResponse() {
    }

    public <T> ApiResponse(String code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public <T> ApiResponse(String code, String msg, String errorMsg) {
        this.code = code;
        this.msg = msg;
        this.errorMsg = errorMsg;
    }

    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    @JSONField(serialize=false)
    public boolean isOK() {
        return SUCCESS_CODE.equals(this.getCode());
    }

    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    @JSONField(serialize=false)
    public boolean isError() {
        return !this.isOK();
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public T getData() {
        return (T)this.data;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    public ApiResponse setData(T data) {
        this.data = data;
        return this;
    }

    public String getTraceId() {
        return this.traceId;
    }

    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }
}

