/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core;

import com.digiwin.mobile.mobileuibot.api.ApiRequestSubmit;
import com.digiwin.mobile.mobileuibot.api.ApiResponse;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionService;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionSubmitResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/mobile/v1/action"})
public class ActionController {
    private static final Logger logger = LoggerFactory.getLogger(ActionController.class);
    @Autowired
    private ActionService actionService;

    @RequestMapping(value={"/submit"}, method={RequestMethod.POST})
    public ApiResponse<String> submit(@RequestBody ApiRequestSubmit request) {
        ActionSubmitResult submitResult;
        boolean useMockData = AppContext.getUseMockData();
        if (useMockData) {
            submitResult = new ActionSubmitResult();
            submitResult.setCompleted(Boolean.valueOf(true));
            submitResult.setPromptMsg(LocaleUtil.getMobileTextByKey((String)request.getLocale(), (String)"\u63d0\u4ea4\u6210\u529f"));
        } else {
            submitResult = this.actionService.submit(request);
        }
        if (null != submitResult) {
            if (!submitResult.getCompleted().booleanValue()) {
                return ApiResponse.buildServiceError((String)submitResult.getPromptMsg(), (String)"");
            }
            return ApiResponse.buildOK().setData((Object)submitResult);
        }
        return ApiResponse.buildError();
    }
}

