/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.api.ApiResponse;
import com.digiwin.mobile.mobileuibot.common.calculate.UUIDUtil;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.core.UiBotController;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponentWrapper;
import com.digiwin.mobile.mobileuibot.core.component.MobileRenderMetaData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/mobile/v2/uibot"})
public class UiBotControllerV2 {
    @Autowired
    private UiBotController controller;

    @RequestMapping(value={"/model"}, method={RequestMethod.POST})
    public ApiResponse<UiBotModel> buildRenderPageModel(@RequestBody ApiRequest apiRequest) throws IOException {
        AppRequestContext.getContextEntity().setRenderVersion(MobileRenderMetaData.RENDER_VERSION_2);
        return this.controller.buildRenderPageModel(apiRequest);
    }

    @RequestMapping(value={"/component"}, method={RequestMethod.POST})
    public ApiResponse<BaseMobileComponentWrapper<BaseMobileComponent>> buildComponentData(@RequestParam(name="clientId", required=false) String clientId, @RequestParam(name="tenantId", required=false) String tenantId, @RequestBody ApiRequest apiRequest) throws IOException {
        ApiResponse v1ApiResponse = this.controller.buildComponentData(clientId, tenantId, apiRequest);
        BaseMobileComponent baseMobileComponent = (BaseMobileComponent)v1ApiResponse.getData();
        baseMobileComponent.forceSetCmptVersion2();
        BaseMobileComponentWrapper wrappedComponent = new BaseMobileComponentWrapper(baseMobileComponent, "DW_" + baseMobileComponent.returnComponentType(), UUIDUtil.getUuid());
        ApiResponse v2ApiResponse = new ApiResponse();
        v2ApiResponse.setCode(v1ApiResponse.getCode());
        v2ApiResponse.setMsg(v1ApiResponse.getMsg());
        v2ApiResponse.setTraceId(v1ApiResponse.getTraceId());
        v2ApiResponse.setErrorMsg(v1ApiResponse.getErrorMsg());
        v2ApiResponse.setData((Object)wrappedComponent);
        return v2ApiResponse;
    }
}

