/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.component;

import com.digiwin.mobile.mobileuibot.common.calculate.UUIDUtil;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import java.io.Serializable;
import java.util.Optional;
import org.springframework.util.StringUtils;

public class BaseMobileComponentWrapper<T extends BaseMobileComponent>
implements Serializable {
    private static final long serialVersionUID = -4721350868250067627L;
    protected String componentType;
    protected T data;
    protected String schema;
    protected String mobilePath;

    public String getSchema() {
        if (StringUtils.hasLength((String)this.schema)) {
            return this.schema;
        }
        this.schema = Optional.ofNullable(this.data).map(BaseMobileComponent::getCmptUuid).orElse(UUIDUtil.getUuid());
        return this.schema;
    }

    public T getData() {
        if (this.data == null) {
            return (T)this.data;
        }
        if (StringUtils.hasLength((String)this.data.getSchema())) {
            return (T)this.data;
        }
        this.data.setSchema(this.getSchema());
        return (T)this.data;
    }

    public String returnComponentId() {
        if (this.data == null) {
            return "";
        }
        String componentId = this.data.getComponentId();
        return componentId == null ? "" : componentId;
    }

    public BaseMobileComponentWrapper(T data) {
        this.componentType = data.returnComponentType();
        this.data = data;
    }

    public BaseMobileComponentWrapper(T data, String componentType) {
        this.componentType = componentType;
        this.data = data;
    }

    public BaseMobileComponentWrapper(T data, String componentType, String schema) {
        this.componentType = componentType;
        this.data = data;
        this.schema = schema;
    }

    public BaseMobileComponentWrapper(T data, String componentType, String schema, String mobilePath) {
        this.componentType = componentType;
        this.data = data;
        this.schema = schema;
        this.mobilePath = mobilePath;
    }

    public String getComponentType() {
        return this.componentType;
    }

    public String getMobilePath() {
        return this.mobilePath;
    }

    public void setComponentType(String componentType) {
        this.componentType = componentType;
    }

    public void setData(T data) {
        this.data = data;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public void setMobilePath(String mobilePath) {
        this.mobilePath = mobilePath;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseMobileComponentWrapper)) {
            return false;
        }
        BaseMobileComponentWrapper other = (BaseMobileComponentWrapper)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$componentType = this.getComponentType();
        String other$componentType = other.getComponentType();
        if (this$componentType == null ? other$componentType != null : !this$componentType.equals(other$componentType)) {
            return false;
        }
        BaseMobileComponent this$data = this.getData();
        BaseMobileComponent other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        String this$schema = this.getSchema();
        String other$schema = other.getSchema();
        if (this$schema == null ? other$schema != null : !this$schema.equals(other$schema)) {
            return false;
        }
        String this$mobilePath = this.getMobilePath();
        String other$mobilePath = other.getMobilePath();
        return !(this$mobilePath == null ? other$mobilePath != null : !this$mobilePath.equals(other$mobilePath));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BaseMobileComponentWrapper;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $componentType = this.getComponentType();
        result = result * 59 + ($componentType == null ? 43 : $componentType.hashCode());
        BaseMobileComponent $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        String $schema = this.getSchema();
        result = result * 59 + ($schema == null ? 43 : $schema.hashCode());
        String $mobilePath = this.getMobilePath();
        result = result * 59 + ($mobilePath == null ? 43 : $mobilePath.hashCode());
        return result;
    }

    public String toString() {
        return "BaseMobileComponentWrapper(componentType=" + this.getComponentType() + ", data=" + this.getData() + ", schema=" + this.getSchema() + ", mobilePath=" + this.getMobilePath() + ")";
    }
}

