/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.component.business.bizapproval;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.common.string.StringUtil;
import com.digiwin.mobile.mobileuibot.core.columntag.ColumnTagService;
import com.digiwin.mobile.mobileuibot.core.component.MobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.MobileComponentBuilder;
import com.digiwin.mobile.mobileuibot.core.component.business.bizapproval.BizApprovalDataItemV2;
import com.digiwin.mobile.mobileuibot.core.component.business.bizapproval.BizApprovalDataList;
import com.digiwin.mobile.mobileuibot.core.component.business.bizapproval.BizApprovalTab;
import com.digiwin.mobile.mobileuibot.core.component.business.bizapproval.BizApprovalTabList;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableColumnDefinition;
import com.digiwin.mobile.mobileuibot.proxy.uibot.parser.TableUiBotParser;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.script.ScriptException;
import jdk.nashorn.api.scripting.NashornScriptEngine;
import jdk.nashorn.api.scripting.NashornScriptEngineFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Component(value="bizApprovalTabBuilder")
public class BizApprovalTabBuilder
implements MobileComponentBuilder<BizApprovalTabList> {
    @Autowired
    private ColumnTagService columnTagService;
    @Autowired
    private LocaleService localeService;

    public String getMobileComponentType() {
        return "TABS";
    }

    public BizApprovalTabList build(ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel, Class<BizApprovalTabList> clazz, Object ... args) {
        String locale = apiRequest.getLocale();
        ArrayList<String> parentLayoutTypeList = new ArrayList<String>();
        parentLayoutTypeList.add("SPLIT_LAYOUT");
        parentLayoutTypeList.add("FORM_LIST");
        parentLayoutTypeList.add("FORMGROUP");
        parentLayoutTypeList.add("TABS");
        ArrayList<String> layoutTypeList = new ArrayList<String>();
        layoutTypeList.add("TABLE");
        UiBotModel uiBotModel = pcUiBotModel.searchPcTargetModel(layoutTypeList, parentLayoutTypeList, false);
        BizApprovalTabList resultList = null;
        if (uiBotModel.getLayout().isEmpty()) {
            return BizApprovalTabList.createEmpty();
        }
        UiBotLayout dataLayout = (UiBotLayout)uiBotModel.getLayout().get(0);
        resultList = dataLayout.isTypeOfTable() ? this.getBizApprovalTabsWithPcTable(apiRequest, uiBotModel, locale, dataLayout, Boolean.valueOf(false)) : BizApprovalTabList.createEmpty();
        return resultList;
    }

    private BizApprovalTabList getBizApprovalTabsWithPcTable(ApiRequest apiRequest, UiBotModel pcUiBotModel, String locale, UiBotLayout pcDataLayout, Boolean isShowRealTabName) {
        List tableColumnDefinitionList = pcDataLayout.getColumnDefs();
        if (tableColumnDefinitionList == null) {
            return BizApprovalTabList.createEmpty();
        }
        List drawerUiBotTableColumnDefinition = tableColumnDefinitionList.stream().filter(columnDefinition -> {
            List columns = columnDefinition.getColumns();
            if (CollectionUtils.isEmpty((Collection)columns)) {
                return false;
            }
            return columns.stream().anyMatch(c -> "DRAWER_BUTTON".equals(c.getType()));
        }).collect(Collectors.toList());
        tableColumnDefinitionList.removeAll(drawerUiBotTableColumnDefinition);
        List tableColumns = UiBotTableColumnDefinition.decomposeTableColumnDefinitions((List)tableColumnDefinitionList);
        String path = pcDataLayout.getPath();
        String schema = pcDataLayout.getSchema();
        boolean hasParentSchema = StringUtils.hasLength((String)pcUiBotModel.getParentSchema());
        List bizDataList = (List)pcUiBotModel.getPageData().getBizDataByPathAndSchema(path, schema, hasParentSchema);
        List fieldDataListList = TableUiBotParser.parseTableUiBotData((UiBotLayout)pcDataLayout, (UiBotPageData)pcUiBotModel.getPageData(), (boolean)hasParentSchema);
        if (pcUiBotModel.getPageData().containsKey((Object)path) && CollectionUtils.isEmpty((Collection)bizDataList)) {
            return BizApprovalTabList.createEmpty();
        }
        BizApprovalTabList bizApprovalTabList = new BizApprovalTabList();
        List columnTagList = this.columnTagService.listColumnTagsByPath(schema);
        List scriptFilters = pcDataLayout.getScriptFilters();
        if (scriptFilters == null || scriptFilters.isEmpty()) {
            String name;
            BizApprovalTab tab = new BizApprovalTab(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u5168\u90e8"));
            if (isShowRealTabName.booleanValue() && StringUtils.hasLength((String)(name = Optional.ofNullable(pcDataLayout.getTitle()).orElse(pcDataLayout.getHeaderName())))) {
                tab.setName(this.localeService.getLanguageValue(locale, StringUtil.valueOf((Object)name)));
            }
            BizApprovalDataList bizApprovalDataList = new BizApprovalDataList();
            tab.setContent((MobileComponent)bizApprovalDataList);
            for (int i = 0; i < bizDataList.size(); ++i) {
                Map bizData = (Map)bizDataList.get(i);
                bizApprovalDataList.add((Object)BizApprovalDataItemV2.createWithPcTABS((ApiRequest)apiRequest, (UiBotModel)pcUiBotModel, (String)schema, (List)tableColumns, (Map)bizData, (List)columnTagList, (List)((List)fieldDataListList.get(i)), drawerUiBotTableColumnDefinition));
            }
            bizApprovalTabList.add((Object)tab);
        } else {
            scriptFilters.forEach(scriptFilter -> {
                block3: {
                    BizApprovalDataList bizApprovalDataList;
                    block2: {
                        BizApprovalTab tab = new BizApprovalTab(scriptFilter.getTitle());
                        tab.setDesc(scriptFilter.getDescription());
                        bizApprovalDataList = new BizApprovalDataList();
                        tab.setContent((MobileComponent)bizApprovalDataList);
                        bizApprovalTabList.add((Object)tab);
                        String filterScript = scriptFilter.getFilterScript();
                        if (!StringUtils.hasLength((String)filterScript) || !filterScript.contains("item.value.local_curr_amount>")) break block2;
                        Double amount = Double.parseDouble(filterScript.substring(filterScript.indexOf("item.value.local_curr_amount>") + 29));
                        if (amount == null) break block3;
                        for (int i = 0; i < bizDataList.size(); ++i) {
                            Map bizData = (Map)bizDataList.get(i);
                            Double currAmount = 0.0;
                            currAmount = bizData.get("local_curr_amount") instanceof Integer ? Double.valueOf(1.0 * (double)((Integer)bizData.get("local_curr_amount")).intValue()) : (Double)bizData.get("local_curr_amount");
                            if (currAmount == null || !(currAmount > amount)) continue;
                            bizApprovalDataList.add((Object)BizApprovalDataItemV2.createWithPcTable((ApiRequest)apiRequest, (UiBotModel)pcUiBotModel, (String)schema, (List)tableColumns, (Map)bizData, (List)columnTagList, (List)((List)fieldDataListList.get(i))));
                        }
                        break block3;
                    }
                    for (int i = 0; i < bizDataList.size(); ++i) {
                        Map bizData = (Map)bizDataList.get(i);
                        bizApprovalDataList.add((Object)BizApprovalDataItemV2.createWithPcTable((ApiRequest)apiRequest, (UiBotModel)pcUiBotModel, (String)schema, (List)tableColumns, (Map)bizData, (List)columnTagList, (List)((List)fieldDataListList.get(i))));
                    }
                }
            });
        }
        return bizApprovalTabList;
    }

    private BizApprovalTabList getBizApprovalTabsWithPcFormList(ApiRequest apiRequest, UiBotModel pcUiBotModel, String locale, UiBotLayout pcDataLayout) {
        String schema = pcDataLayout.getSchema();
        Map bizData = (Map)pcUiBotModel.getPageData().get((Object)schema);
        Assert.notNull((Object)bizData, (String)("pagedata." + schema + " cannot be null"));
        if (bizData.isEmpty()) {
            return BizApprovalTabList.createEmpty();
        }
        List pcFieldLayoutList = pcDataLayout.decomposeFieldsWithPcFormList(null);
        BizApprovalTabList bizApprovalTabList = new BizApprovalTabList();
        BizApprovalTab tab = new BizApprovalTab(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u5168\u90e8"));
        BizApprovalDataList bizApprovalDataList = new BizApprovalDataList();
        tab.setContent((MobileComponent)bizApprovalDataList);
        List columnTagList = this.columnTagService.listColumnTagsByPath(schema);
        bizApprovalDataList.add((Object)BizApprovalDataItemV2.createWithPcFormList((ApiRequest)apiRequest, (UiBotModel)pcUiBotModel, (String)schema, (List)pcFieldLayoutList, (Map)bizData, (List)columnTagList));
        bizApprovalTabList.add((Object)tab);
        return bizApprovalTabList;
    }

    public static void main(String[] args) {
        BizApprovalTabBuilder.doJs((String)"moweijie");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object doJs(String params) {
        String[] options = new String[]{"--language=es6"};
        NashornScriptEngineFactory factory = new NashornScriptEngineFactory();
        NashornScriptEngine engine = (NashornScriptEngine)factory.getScriptEngine(options);
        InputStream inputStream = null;
        String js = "";
        try {
            ClassPathResource classPathResource = new ClassPathResource("sample.js");
            inputStream = classPathResource.getInputStream();
            byte[] buffer = new byte[inputStream.available()];
            inputStream.read(buffer);
            js = new String(buffer, StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (null != inputStream) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        Object result = null;
        try {
            engine.eval(js);
            NashornScriptEngine inv = engine;
            result = inv.invokeFunction("sayHi", params);
        }
        catch (NoSuchMethodException | ScriptException e) {
            e.printStackTrace();
        }
        return result;
    }

    public BizApprovalTabList buildAllTabs(ApiRequest apiRequest, UiBotModel tabUiBotModel) {
        String locale = apiRequest.getLocale();
        ArrayList<String> parentLayoutTypeList = new ArrayList<String>();
        parentLayoutTypeList.add("TABS");
        ArrayList<String> layoutTypeList = new ArrayList<String>();
        layoutTypeList.add("TABLE");
        UiBotModel uiBotModel = tabUiBotModel.searchPcTargetModel(layoutTypeList, parentLayoutTypeList, false);
        BizApprovalTabList resultList = BizApprovalTabList.createEmpty();
        if (uiBotModel.getLayout().isEmpty()) {
            return BizApprovalTabList.createEmpty();
        }
        if (!PageSettingIdPresetEnum.MOBILE_MY_BIZ_DATA_ENTRY_DRIVEN_TASK_DETAIL.name().equals(apiRequest.getPageId())) {
            uiBotModel.setParentSchema("TABS");
        }
        for (UiBotLayout dataLayout : uiBotModel.getLayout()) {
            if (!dataLayout.isTypeOfTable()) continue;
            resultList.addAll((Collection)this.getBizApprovalTabsWithPcTable(apiRequest, uiBotModel, locale, dataLayout, Boolean.valueOf(true)));
        }
        return resultList;
    }
}

