/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.component.business.bizprocess;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.columntag.ColumnTag;
import com.digiwin.mobile.mobileuibot.core.columntag.ColumnTagDefinitionCodeEnum;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.business.bizprocess.BizProcessDataItem;
import com.digiwin.mobile.mobileuibot.core.rule.Rule;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotActionSubmitType;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableColumn;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class BizProcessDataList
extends BaseMobileComponent
implements Serializable {
    public static final String COMPONENT_TYPE = "MULTI_LEVEL_SUBMITTABLE_LIST";
    private static final long serialVersionUID = 1380251415040439L;
    private static final Integer MAX_THEME_SIZE_TO_USE_FINISHED_TEXT = 2;
    private static final Integer MAX_DATA_SIZE_TO_USE_FINISHED_TEXT = 2;
    private static final String GROUPING_SPLITTER_TITLE = "\ue05a";
    private static final String GROUPING_SPLITTER_SUBTITLE = " ";
    private List<BizProcessDataItem> data;
    private String finishedText = "";
    private Boolean selectable;
    private String toastMsg;

    public static BizProcessDataList create(ApiRequest apiRequest, UiBotLayout bizProcessDataListLayout, List<Map<String, Object>> bizDataList, UiBotModel pcUiBotModel, List<UiBotTableColumn> tableColumns, List<ColumnTag> columnTagList, List<Rule> mobileRuleList) {
        UiBotTableColumn themeTitleColumn;
        String locale = apiRequest.getLocale();
        BizProcessDataList bizProcessDataList = new BizProcessDataList();
        boolean selectable = pcUiBotModel.getActions().stream().anyMatch(uiBotAction -> Optional.ofNullable(uiBotAction.getSubmitType()).map(UiBotActionSubmitType::getIsBatch).orElse(false));
        bizProcessDataList.setSelectable(Boolean.valueOf(selectable));
        Optional<ColumnTag> optThemeTitleTag = columnTagList.stream().filter(ct -> ColumnTagDefinitionCodeEnum.DISPLAY_THEME_TITLE.getCode().equalsIgnoreCase(ct.getTagDefinition().getCode())).findFirst();
        if (!optThemeTitleTag.isPresent()) {
            themeTitleColumn = tableColumns.stream().filter(uiBotTableColumn -> !uiBotTableColumn.canEdit()).findFirst().orElse(null);
        } else {
            ColumnTag themeTitleTag = optThemeTitleTag.get();
            String themeTagSchema = themeTitleTag.getSchema();
            themeTitleColumn = tableColumns.stream().filter(col -> col.getSchema().equalsIgnoreCase(themeTagSchema)).findFirst().orElse(null);
        }
        ArrayList themeSubtitleColumnList = new ArrayList();
        List<ColumnTag> themeSubtitleColumnTagList = columnTagList.stream().filter(ct -> ColumnTagDefinitionCodeEnum.DISPLAY_THEME_SUBTITLE.getCode().equalsIgnoreCase(ct.getTagDefinition().getCode())).sorted(Comparator.comparingInt(ColumnTag::getOrderNo)).collect(Collectors.toList());
        themeSubtitleColumnTagList.forEach(ct -> tableColumns.stream().filter(col -> col.getSchema().equalsIgnoreCase(ct.getSchema())).findFirst().ifPresent(themeSubtitleColumnList::add));
        Map<String, List<Map>> byThemeTagSchema = bizDataList.stream().collect(Collectors.groupingBy(bizData -> {
            String themeTitleBizValue = themeTitleColumn.getValueForDisplay(bizData);
            if (themeSubtitleColumnList.isEmpty()) {
                return themeTitleBizValue;
            }
            String themeSubtitleBizValueConcated = themeSubtitleColumnList.stream().map(column -> column.getValueForDisplay(bizData)).collect(Collectors.joining(GROUPING_SPLITTER_SUBTITLE));
            return themeTitleBizValue + GROUPING_SPLITTER_TITLE + themeSubtitleBizValueConcated;
        }));
        if (!byThemeTagSchema.isEmpty()) {
            for (String key : byThemeTagSchema.keySet()) {
                String[] splitKey = key.split(GROUPING_SPLITTER_TITLE);
                String title = splitKey[0];
                String subtitle = splitKey.length > 1 ? splitKey[1] : "";
                bizProcessDataList.getData().add(BizProcessDataItem.create((ApiRequest)apiRequest, (UiBotLayout)bizProcessDataListLayout, (String)title, (String)subtitle, (UiBotModel)pcUiBotModel, byThemeTagSchema.get(key), tableColumns, columnTagList, mobileRuleList));
            }
        }
        if (bizProcessDataList.getData().size() > MAX_THEME_SIZE_TO_USE_FINISHED_TEXT || bizDataList.size() > MAX_DATA_SIZE_TO_USE_FINISHED_TEXT) {
            bizProcessDataList.setFinishedText(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u5df2\u7ecf\u5230\u5e95\u5566"));
        }
        bizProcessDataList.setToastMsg(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u8fd8\u672a\u52fe\u9009\u4efb\u4f55\u6570\u636e"));
        return bizProcessDataList;
    }

    public static BizProcessDataList createEmpty() {
        return new BizProcessDataList();
    }

    public String returnComponentType() {
        return COMPONENT_TYPE;
    }

    public int bizDataSize() {
        int sum = 0;
        if (null == this.data || this.data.isEmpty()) {
            return sum;
        }
        for (BizProcessDataItem dataItem : this.data) {
            if (null == dataItem.getChildren()) continue;
            int dataItemChildrenSize = dataItem.getChildren().size();
            sum += dataItemChildrenSize;
        }
        return sum;
    }

    public Boolean getSelectable() {
        return this.selectable;
    }

    public void setSelectable(Boolean selectable) {
        this.selectable = selectable;
    }

    public String getFinishedText() {
        return this.finishedText;
    }

    public void setFinishedText(String finishedText) {
        this.finishedText = finishedText;
    }

    public List<BizProcessDataItem> getData() {
        if (null == this.data) {
            this.data = new ArrayList();
        }
        return this.data;
    }

    public void setData(List<BizProcessDataItem> data) {
        this.data = data;
    }

    public String getToastMsg() {
        return this.toastMsg;
    }

    public void setToastMsg(String toastMsg) {
        this.toastMsg = toastMsg;
    }
}

