/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.component.button;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.MobileComponentListBuilder;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonStyleEnum;
import com.digiwin.mobile.mobileuibot.core.component.button.ButtonRawData;
import com.digiwin.mobile.mobileuibot.core.component.button.SubmitButton;
import com.digiwin.mobile.mobileuibot.core.component.button.SubmitButtonTypeEnum;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotTargetLayoutSearchResult;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component(value="submitButtonBuilder")
public class SubmitButtonBuilder
implements MobileComponentListBuilder<SubmitButton> {
    private static final Logger logger = LoggerFactory.getLogger(SubmitButtonBuilder.class);

    public String getMobileComponentType() {
        return "SUBMIT_BUTTON";
    }

    public List<SubmitButton> build(ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel, Class<SubmitButton> clazz, Object ... args) {
        Assert.notNull((Object)args, (String)"args must not null!");
        Assert.notEmpty((Object[])args, (String)"args must not empty!");
        String locale = apiRequest.getLocale();
        UiBotTargetLayoutSearchResult searchResult = pcUiBotModel.searchPcTargetLayout();
        if (!searchResult.found()) {
            return Collections.emptyList();
        }
        UiBotLayout targetLayout = searchResult.getTargetUiBotLayout();
        String bizDataSchema = pcUiBotModel.searchBizDataSchema();
        if (bizDataSchema.trim().isEmpty()) {
            return Collections.emptyList();
        }
        List uiBotActions = searchResult.getHasCustomData() != false ? targetLayout.getActions() : pcUiBotModel.getActions();
        if (null == uiBotActions || uiBotActions.isEmpty()) {
            return Collections.emptyList();
        }
        Object bizData = pcUiBotModel.getPageData().get((Object)bizDataSchema);
        if (bizData == null) {
            return Collections.emptyList();
        }
        if (bizData instanceof List && ((List)bizData).isEmpty()) {
            return Collections.emptyList();
        }
        if (bizData instanceof Map && ((Map)bizData).isEmpty()) {
            return Collections.emptyList();
        }
        UiBotLayout subTabChild = (UiBotLayout)args[0];
        boolean selectable = (Boolean)Optional.ofNullable(args[1]).orElse(false);
        ArrayList<SubmitButton> result = new ArrayList<SubmitButton>();
        for (UiBotAction uiBotAction : uiBotActions) {
            SubmitButton submitButton = new SubmitButton();
            if (null != subTabChild.getMSubmitType()) {
                submitButton.setSubmitType(subTabChild.getMSubmitType());
            }
            if (null != subTabChild.getMSelectAllText()) {
                submitButton.setSelectAllText(LocaleUtil.getMobileTextByDatabaseKey((String)locale, (String)subTabChild.getMSelectAllText()));
            }
            submitButton.setName(uiBotAction.getTitle());
            if (uiBotAction.getDefaultAction().booleanValue()) {
                submitButton.setType(BottomButtonStyleEnum.STRESS.getValue());
            } else {
                submitButton.setType(BottomButtonStyleEnum.NORMAL.getValue());
            }
            Action action = new Action(ActionTypeEnum.CALL_API.getValue());
            action.setRawData((Object)new ButtonRawData(uiBotAction, (Map)pcUiBotModel.getPageData()));
            submitButton.setAction(action);
            submitButton.setSubmitType(selectable ? SubmitButtonTypeEnum.INCLUDE_SELECT_ALL.getType() : SubmitButtonTypeEnum.SELF_ONLY.getType());
            result.add(submitButton);
        }
        return result;
    }
}

