/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.component.chart.chartseries;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import com.digiwin.mobile.mobileuibot.common.exception.ServiceException;
import com.digiwin.mobile.mobileuibot.core.component.chart.ChartTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.chart.chartelement.markline.ChartMarkLine;
import com.digiwin.mobile.mobileuibot.core.component.chart.chartseries.ChartData;
import com.digiwin.mobile.mobileuibot.core.component.chart.chartseries.OneDimensionalChartData;
import com.digiwin.mobile.mobileuibot.core.component.chart.chartseries.PieChartData;
import com.digiwin.mobile.mobileuibot.core.component.chart.chartseries.RectangleCoordinateChartData;
import com.digiwin.mobile.mobileuibot.core.component.chart.chartseries.YDifferLabel;
import com.digiwin.mobile.mobileuibot.core.component.chart.chartseries.YDifferLabelDataItem;
import com.digiwin.mobile.mobileuibot.core.component.chart.chartstyle.ChartColorPalette;
import com.digiwin.mobile.mobileuibot.core.component.chart.chartstyle.ChartElementStyle;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata.AgileDataIntermediateDataItem;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata.chart.AgileDataChartPointField;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata.chart.AgileDataChartValueField;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata.chart.ChartRenderSetting;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata.chart.measure.GrowthRateInterpreter;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata.chart.measure.GrowthRateInterpreterResult;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata.chart.measure.GrowthRateMeasurePresent;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata.chart.measure.MeasurePresetnFormulationIdEnum;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;

public class ChartSeries<T extends ChartData>
implements Serializable {
    private static final long serialVersionUID = -7824082283273768445L;
    @JsonIgnore
    @JSONField(serialize=false, deserialize=false)
    private List<AgileDataChartValueField> valueFields = new ArrayList(2);
    private String type;
    private String name;
    private List<T> data = new ArrayList();
    @JSONField(name="xAxisIndex")
    @JsonProperty(value="xAxisIndex")
    private Integer xAxisIndex;
    @JSONField(name="yAxisIndex")
    @JsonProperty(value="yAxisIndex")
    private Integer yAxisIndex;
    private ChartMarkLine markLine;
    private ChartElementStyle lineStyle;

    public void setLineStyle(ChartElementStyle lineStyle) {
        this.lineStyle = lineStyle;
    }

    public void addData(T chartData) {
        this.data.add(chartData);
    }

    public void addDataAll(List<T> chartData) {
        this.data.addAll(chartData);
    }

    public void addValueField(AgileDataChartValueField valueField) {
        this.valueFields.add(valueField);
    }

    public static List<ChartSeries<RectangleCoordinateChartData>> buildLineChartSeries(String locale, AgileDataIntermediateDataItem intermediateDataItem, ChartTypeEnum chartTypeEnum) {
        ChartRenderSetting chartRenderSetting = intermediateDataItem.getChartRenderSetting();
        List points = chartRenderSetting.getPoints();
        List values = chartRenderSetting.getValues();
        List pageData = intermediateDataItem.getPageData();
        ArrayList<ChartSeries<RectangleCoordinateChartData>> dataSeries = new ArrayList<ChartSeries<RectangleCoordinateChartData>>();
        int colorIdx = 0;
        for (int i = 0; i < points.size(); ++i) {
            AgileDataChartPointField pointField = (AgileDataChartPointField)points.get(i);
            for (int j = 0; j < values.size(); ++j) {
                String lineColor;
                AgileDataChartValueField valueField = (AgileDataChartValueField)values.get(j);
                String dataColor = lineColor = ChartColorPalette.getColorFromCategoryPalette((int)colorIdx);
                ChartSeries series = new ChartSeries();
                series.setName(valueField.getTitle());
                series.setXAxisIndex(Integer.valueOf(i));
                series.setYAxisIndex(valueField.getGroup());
                series.setType(chartTypeEnum.getType());
                series.setLineStyle(new ChartElementStyle().setColor(lineColor));
                series.setMarkLine(ChartMarkLine.buildLineChartMarkLine((AgileDataIntermediateDataItem)intermediateDataItem));
                for (JSONObject pageDatum : pageData) {
                    ArrayList<OneDimensionalChartData> oneDimDataList = new ArrayList<OneDimensionalChartData>();
                    OneDimensionalChartData oneDimData = new OneDimensionalChartData().setValue(Double.valueOf(pageDatum.getDoubleValue(valueField.getName()))).setLabel(intermediateDataItem.getLabelWithValueField(locale, valueField, Double.valueOf(pageDatum.getDoubleValue(valueField.getName())))).setShowLabel(Boolean.valueOf(false));
                    oneDimData.setColor(dataColor);
                    oneDimDataList.add(oneDimData);
                    RectangleCoordinateChartData data = new RectangleCoordinateChartData().setX(pageDatum.getString(pointField.getName())).setY(oneDimDataList);
                    series.addData((ChartData)data);
                }
                dataSeries.add((ChartSeries<RectangleCoordinateChartData>)series);
                ++colorIdx;
            }
        }
        return dataSeries;
    }

    public static List<ChartSeries<RectangleCoordinateChartData>> buildBarChartSeries(String locale, AgileDataIntermediateDataItem intermediateDataItem, ChartTypeEnum chartTypeEnum) {
        ChartRenderSetting chartRenderSetting = intermediateDataItem.getChartRenderSetting();
        List points = chartRenderSetting.getPoints();
        List values = chartRenderSetting.getValues();
        List pageData = intermediateDataItem.getPageData();
        Map formulationIdGroupedMap = null;
        if (null != chartRenderSetting.getMeasurePresents()) {
            formulationIdGroupedMap = chartRenderSetting.getMeasurePresents().stream().collect(Collectors.groupingBy(mp -> mp.getFormulationId(), LinkedHashMap::new, Collectors.toCollection(ArrayList::new)));
        }
        ArrayList<ChartSeries<RectangleCoordinateChartData>> dataSeries = new ArrayList<ChartSeries<RectangleCoordinateChartData>>();
        for (int i = 0; i < points.size(); ++i) {
            AgileDataChartPointField pointField = (AgileDataChartPointField)points.get(i);
            ChartSeries series = new ChartSeries();
            HashMap<String, String> valueFieldColorMap = new HashMap<String, String>(values.size());
            for (JSONObject pageDatum : pageData) {
                int colorIdx = 0;
                RectangleCoordinateChartData chartData = new RectangleCoordinateChartData();
                series.addData((ChartData)chartData);
                chartData.setX(pageDatum.getString(pointField.getName()));
                ArrayList<OneDimensionalChartData> oneDimDataList = new ArrayList<OneDimensionalChartData>();
                chartData.setY(oneDimDataList);
                for (int j = 0; j < values.size(); ++j) {
                    AgileDataChartValueField valueField = (AgileDataChartValueField)values.get(j);
                    String dataColor = ChartColorPalette.getColorFromCategoryPalette((int)colorIdx);
                    ++colorIdx;
                    valueFieldColorMap.put(valueField.getName(), dataColor);
                    OneDimensionalChartData oneDimData = new OneDimensionalChartData().setValue(Double.valueOf(pageDatum.getDoubleValue(valueField.getName()))).setLabel(intermediateDataItem.getLabelWithValueField(locale, valueField, Double.valueOf(pageDatum.getDoubleValue(valueField.getName())))).setShowLabel(Boolean.valueOf(false)).setYAxisIndex(valueField.getGroup());
                    oneDimData.setName(valueField.getTitle());
                    oneDimData.setColor(dataColor);
                    oneDimDataList.add(oneDimData);
                }
                if (CollectionUtils.isEmpty((Map)formulationIdGroupedMap) || !formulationIdGroupedMap.containsKey(MeasurePresetnFormulationIdEnum.GROWTH_RATE.getValue())) continue;
                YDifferLabel yDifferLabel = new YDifferLabel();
                chartData.setYDifferLabel(yDifferLabel);
                GrowthRateInterpreter growthRateInterpreter = new GrowthRateInterpreter();
                List measurePresents = (List)formulationIdGroupedMap.get(MeasurePresetnFormulationIdEnum.GROWTH_RATE.getValue());
                measurePresents.forEach(mp -> {
                    GrowthRateInterpreterResult result = growthRateInterpreter.interpret(pageDatum, values, (GrowthRateMeasurePresent)mp);
                    if (null != result) {
                        YDifferLabelDataItem yDifferLabelDataItem = new YDifferLabelDataItem(mp.getFormat()).setDifferRate(result.getDifferRate()).setStartIndex(result.getStartIndex()).setEndIndex(result.getEndIndex());
                        yDifferLabel.addYDifferLabelDataItem(yDifferLabelDataItem);
                    }
                });
            }
            series.setXAxisIndex(Integer.valueOf(i));
            series.setType(chartTypeEnum.getType());
            series.setMarkLine(ChartMarkLine.buildBarChartMarkLine((AgileDataIntermediateDataItem)intermediateDataItem, valueFieldColorMap));
            dataSeries.add((ChartSeries<RectangleCoordinateChartData>)series);
        }
        return dataSeries;
    }

    public static List<ChartSeries<RectangleCoordinateChartData>> buildMixedChartSeries(String locale, AgileDataIntermediateDataItem intermediateDataItem, ChartTypeEnum chartTypeEnum) {
        ChartRenderSetting chartRenderSetting = intermediateDataItem.getChartRenderSetting();
        List points = chartRenderSetting.getPoints();
        List values = chartRenderSetting.getValues();
        Map groupedValueFields = intermediateDataItem.getGroupedValueFields();
        List pageData = intermediateDataItem.getPageData();
        for (int i = 0; i < values.size(); ++i) {
            AgileDataChartValueField valueField = (AgileDataChartValueField)values.get(i);
            valueField.setColorIdx(Integer.valueOf(i));
        }
        ArrayList<ChartSeries<RectangleCoordinateChartData>> dataSeries = new ArrayList<ChartSeries<RectangleCoordinateChartData>>();
        boolean hasBarTypeSeries = false;
        for (Integer groupNo : groupedValueFields.keySet()) {
            List valueFields = (List)groupedValueFields.get(groupNo);
            for (int i = 0; i < valueFields.size(); ++i) {
                AgileDataChartValueField currentValueField = (AgileDataChartValueField)valueFields.get(i);
                String currentChartType = currentValueField.getChartType();
                if (hasBarTypeSeries && ChartTypeEnum.BAR.getType().equalsIgnoreCase(currentChartType)) {
                    ChartSeries barSeries = dataSeries.stream().filter(s -> s.getType().equals(ChartTypeEnum.BAR.getType())).findFirst().orElseThrow(() -> new ServiceException("bar type series lost..."));
                    barSeries.addValueField(currentValueField);
                    continue;
                }
                ChartSeries series = new ChartSeries();
                if (!ChartTypeEnum.BAR.getType().equals(currentChartType)) {
                    series.setYAxisIndex(groupNo);
                }
                series.setType(currentChartType);
                series.addValueField(currentValueField);
                dataSeries.add((ChartSeries<RectangleCoordinateChartData>)series);
                hasBarTypeSeries = ChartTypeEnum.BAR.getType().equals(currentChartType);
            }
        }
        for (int i = 0; i < points.size(); ++i) {
            AgileDataChartPointField pointField = (AgileDataChartPointField)points.get(i);
            String lineColor = "";
            String dataColor = "";
            for (int j = 0; j < dataSeries.size(); ++j) {
                ChartSeries series = (ChartSeries)dataSeries.get(j);
                boolean specifiedChartTypeIsBar = false;
                if (Objects.equals(ChartTypeEnum.BAR.getType(), series.getType())) {
                    specifiedChartTypeIsBar = true;
                }
                for (JSONObject pageDatum : pageData) {
                    List valueFields = series.getValueFields();
                    ArrayList<OneDimensionalChartData> oneDimDataList = new ArrayList<OneDimensionalChartData>();
                    for (int k = 0; k < valueFields.size(); ++k) {
                        AgileDataChartValueField valueField = (AgileDataChartValueField)valueFields.get(k);
                        int colorIdx = valueField.getColorIdx();
                        OneDimensionalChartData oneDimData = new OneDimensionalChartData().setValue(Double.valueOf(pageDatum.getDoubleValue(valueField.getName()))).setLabel(intermediateDataItem.getLabelWithValueField(locale, valueField, Double.valueOf(pageDatum.getDoubleValue(valueField.getName())))).setShowLabel(Boolean.valueOf(false));
                        if (specifiedChartTypeIsBar) {
                            oneDimData.setYAxisIndex(valueField.getGroup());
                        }
                        lineColor = ChartColorPalette.getColorFromCategoryPalette((int)colorIdx);
                        dataColor = ChartColorPalette.getColorFromCategoryPalette((int)colorIdx);
                        oneDimData.setName(valueField.getTitle());
                        oneDimData.setColor(dataColor);
                        oneDimDataList.add(oneDimData);
                    }
                    RectangleCoordinateChartData data = new RectangleCoordinateChartData().setX(pageDatum.getString(pointField.getName())).setY(oneDimDataList);
                    series.addData((ChartData)data);
                }
                if (!Objects.equals(ChartTypeEnum.LINE.getType(), series.getType())) continue;
                series.setLineStyle(new ChartElementStyle().setColor(lineColor));
            }
        }
        return dataSeries;
    }

    public static List<ChartSeries<PieChartData>> buildPieChartSeries(String locale, AgileDataIntermediateDataItem intermediateDataItem) {
        ChartRenderSetting chartRenderSetting = intermediateDataItem.getChartRenderSetting();
        List points = chartRenderSetting.getPoints();
        List values = chartRenderSetting.getValues();
        List pageData = intermediateDataItem.getPageData();
        ArrayList<ChartSeries<PieChartData>> dataSeries = new ArrayList<ChartSeries<PieChartData>>();
        for (int i = 0; i < points.size(); ++i) {
            for (int j = 0; j < values.size(); ++j) {
                AgileDataChartPointField pointField = (AgileDataChartPointField)points.get(i);
                AgileDataChartValueField valueField = (AgileDataChartValueField)values.get(j);
                ChartSeries series = new ChartSeries();
                series.setName(valueField.getTitle());
                for (int k = 0; k < pageData.size(); ++k) {
                    JSONObject pageDatum = (JSONObject)pageData.get(k);
                    PieChartData data = new PieChartData().setValue(Double.valueOf(pageDatum.getDoubleValue(valueField.getName()))).setLabel(pageDatum.getString(pointField.getName())).setShowLabel(Boolean.valueOf(true));
                    data.setColor(ChartColorPalette.getColorFromCategoryPalette((int)k));
                    series.addData((ChartData)data);
                }
                dataSeries.add((ChartSeries<PieChartData>)series);
            }
        }
        return dataSeries;
    }

    public List<AgileDataChartValueField> getValueFields() {
        return this.valueFields;
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public List<T> getData() {
        return this.data;
    }

    public Integer getXAxisIndex() {
        return this.xAxisIndex;
    }

    public Integer getYAxisIndex() {
        return this.yAxisIndex;
    }

    public ChartMarkLine getMarkLine() {
        return this.markLine;
    }

    public ChartElementStyle getLineStyle() {
        return this.lineStyle;
    }

    @JsonIgnore
    public ChartSeries<T> setValueFields(List<AgileDataChartValueField> valueFields) {
        this.valueFields = valueFields;
        return this;
    }

    public ChartSeries<T> setType(String type) {
        this.type = type;
        return this;
    }

    public ChartSeries<T> setName(String name) {
        this.name = name;
        return this;
    }

    public ChartSeries<T> setData(List<T> data) {
        this.data = data;
        return this;
    }

    @JsonProperty(value="xAxisIndex")
    public ChartSeries<T> setXAxisIndex(Integer xAxisIndex) {
        this.xAxisIndex = xAxisIndex;
        return this;
    }

    @JsonProperty(value="yAxisIndex")
    public ChartSeries<T> setYAxisIndex(Integer yAxisIndex) {
        this.yAxisIndex = yAxisIndex;
        return this;
    }

    public ChartSeries<T> setMarkLine(ChartMarkLine markLine) {
        this.markLine = markLine;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChartSeries)) {
            return false;
        }
        ChartSeries other = (ChartSeries)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Integer this$xAxisIndex = this.getXAxisIndex();
        Integer other$xAxisIndex = other.getXAxisIndex();
        if (this$xAxisIndex == null ? other$xAxisIndex != null : !((Object)this$xAxisIndex).equals(other$xAxisIndex)) {
            return false;
        }
        Integer this$yAxisIndex = this.getYAxisIndex();
        Integer other$yAxisIndex = other.getYAxisIndex();
        if (this$yAxisIndex == null ? other$yAxisIndex != null : !((Object)this$yAxisIndex).equals(other$yAxisIndex)) {
            return false;
        }
        List this$valueFields = this.getValueFields();
        List other$valueFields = other.getValueFields();
        if (this$valueFields == null ? other$valueFields != null : !((Object)this$valueFields).equals(other$valueFields)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        List this$data = this.getData();
        List other$data = other.getData();
        if (this$data == null ? other$data != null : !((Object)this$data).equals(other$data)) {
            return false;
        }
        ChartMarkLine this$markLine = this.getMarkLine();
        ChartMarkLine other$markLine = other.getMarkLine();
        if (this$markLine == null ? other$markLine != null : !this$markLine.equals(other$markLine)) {
            return false;
        }
        ChartElementStyle this$lineStyle = this.getLineStyle();
        ChartElementStyle other$lineStyle = other.getLineStyle();
        return !(this$lineStyle == null ? other$lineStyle != null : !this$lineStyle.equals(other$lineStyle));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ChartSeries;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $xAxisIndex = this.getXAxisIndex();
        result = result * 59 + ($xAxisIndex == null ? 43 : ((Object)$xAxisIndex).hashCode());
        Integer $yAxisIndex = this.getYAxisIndex();
        result = result * 59 + ($yAxisIndex == null ? 43 : ((Object)$yAxisIndex).hashCode());
        List $valueFields = this.getValueFields();
        result = result * 59 + ($valueFields == null ? 43 : ((Object)$valueFields).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        List $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        ChartMarkLine $markLine = this.getMarkLine();
        result = result * 59 + ($markLine == null ? 43 : $markLine.hashCode());
        ChartElementStyle $lineStyle = this.getLineStyle();
        result = result * 59 + ($lineStyle == null ? 43 : $lineStyle.hashCode());
        return result;
    }

    public String toString() {
        return "ChartSeries(valueFields=" + this.getValueFields() + ", type=" + this.getType() + ", name=" + this.getName() + ", data=" + this.getData() + ", xAxisIndex=" + this.getXAxisIndex() + ", yAxisIndex=" + this.getYAxisIndex() + ", markLine=" + this.getMarkLine() + ", lineStyle=" + this.getLineStyle() + ")";
    }

    public ChartSeries() {
    }

    public ChartSeries(List<AgileDataChartValueField> valueFields, String type, String name, List<T> data, Integer xAxisIndex, Integer yAxisIndex, ChartMarkLine markLine, ChartElementStyle lineStyle) {
        this.valueFields = valueFields;
        this.type = type;
        this.name = name;
        this.data = data;
        this.xAxisIndex = xAxisIndex;
        this.yAxisIndex = yAxisIndex;
        this.markLine = markLine;
        this.lineStyle = lineStyle;
    }
}

