/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.component.chart.chartseries;

import com.alibaba.fastjson.annotation.JSONField;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata.chart.AgileDataChartFieldDisplayFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YDifferLabelDataItem
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(YDifferLabelDataItem.class);
    private static final long serialVersionUID = -7440790156485828816L;
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    @JSONField(serialize=false)
    private AgileDataChartFieldDisplayFormat format;
    private Integer startIndex;
    private Integer endIndex;
    private Double differRate;
    private String label;

    public YDifferLabelDataItem(AgileDataChartFieldDisplayFormat format) {
        this.format = format;
    }

    public String getLabel() {
        if (null != this.format && null != this.differRate) {
            String tempLabel = this.format.getFormattedString(this.differRate);
            return this.differRate > 0.0 ? "+" + tempLabel : tempLabel;
        }
        log.debug("differ label cannot be generated...");
        return "";
    }

    public AgileDataChartFieldDisplayFormat getFormat() {
        return this.format;
    }

    public Integer getStartIndex() {
        return this.startIndex;
    }

    public Integer getEndIndex() {
        return this.endIndex;
    }

    public Double getDifferRate() {
        return this.differRate;
    }

    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    public YDifferLabelDataItem setFormat(AgileDataChartFieldDisplayFormat format) {
        this.format = format;
        return this;
    }

    public YDifferLabelDataItem setStartIndex(Integer startIndex) {
        this.startIndex = startIndex;
        return this;
    }

    public YDifferLabelDataItem setEndIndex(Integer endIndex) {
        this.endIndex = endIndex;
        return this;
    }

    public YDifferLabelDataItem setDifferRate(Double differRate) {
        this.differRate = differRate;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof YDifferLabelDataItem)) {
            return false;
        }
        YDifferLabelDataItem other = (YDifferLabelDataItem)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Integer this$startIndex = this.getStartIndex();
        Integer other$startIndex = other.getStartIndex();
        if (this$startIndex == null ? other$startIndex != null : !((Object)this$startIndex).equals(other$startIndex)) {
            return false;
        }
        Integer this$endIndex = this.getEndIndex();
        Integer other$endIndex = other.getEndIndex();
        if (this$endIndex == null ? other$endIndex != null : !((Object)this$endIndex).equals(other$endIndex)) {
            return false;
        }
        Double this$differRate = this.getDifferRate();
        Double other$differRate = other.getDifferRate();
        if (this$differRate == null ? other$differRate != null : !((Object)this$differRate).equals(other$differRate)) {
            return false;
        }
        AgileDataChartFieldDisplayFormat this$format = this.getFormat();
        AgileDataChartFieldDisplayFormat other$format = other.getFormat();
        if (this$format == null ? other$format != null : !this$format.equals(other$format)) {
            return false;
        }
        String this$label = this.getLabel();
        String other$label = other.getLabel();
        return !(this$label == null ? other$label != null : !this$label.equals(other$label));
    }

    protected boolean canEqual(Object other) {
        return other instanceof YDifferLabelDataItem;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $startIndex = this.getStartIndex();
        result = result * 59 + ($startIndex == null ? 43 : ((Object)$startIndex).hashCode());
        Integer $endIndex = this.getEndIndex();
        result = result * 59 + ($endIndex == null ? 43 : ((Object)$endIndex).hashCode());
        Double $differRate = this.getDifferRate();
        result = result * 59 + ($differRate == null ? 43 : ((Object)$differRate).hashCode());
        AgileDataChartFieldDisplayFormat $format = this.getFormat();
        result = result * 59 + ($format == null ? 43 : $format.hashCode());
        String $label = this.getLabel();
        result = result * 59 + ($label == null ? 43 : $label.hashCode());
        return result;
    }

    public String toString() {
        return "YDifferLabelDataItem(format=" + this.getFormat() + ", startIndex=" + this.getStartIndex() + ", endIndex=" + this.getEndIndex() + ", differRate=" + this.getDifferRate() + ", label=" + this.getLabel() + ")";
    }
}

