/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.component.input.addersubstracter;

import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.BaseInputMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.ComponentContext;
import com.digiwin.mobile.mobileuibot.core.component.MobilePageRawData;
import com.digiwin.mobile.mobileuibot.core.component.card.card.Card;
import com.digiwin.mobile.mobileuibot.designer.uibot.service.UiBotDesignerRenderService;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import org.springframework.util.StringUtils;

public class AdderSubstracter
extends BaseInputMobileComponent
implements Serializable {
    public static final String COMPONENT_TYPE = "ADDER_SUBSTRACTER";
    private static final long serialVersionUID = 5243367271181883447L;
    private String title;
    private Double stepValue = new Double(1.0);
    private Double maxNumber = new Double(100.0);
    private String maxHint;
    private Double minNumber = new Double(0.0);
    private String minHint;
    private Double defaultNumber;
    private Boolean useManualInput = true;
    private Boolean containsZero = false;

    public static AdderSubstracter create(String locale, LocaleService localeService, String maxNumber, String unReceiptQty, Double minNumber, Boolean containsZero, Boolean showHint) {
        AdderSubstracter adderSubstacter = new AdderSubstracter();
        if (!StringUtils.hasLength((String)maxNumber)) {
            maxNumber = unReceiptQty;
        }
        adderSubstacter.setMaxNumber(Double.valueOf(StringUtils.hasLength((String)maxNumber) ? Double.parseDouble(maxNumber) : 0.0));
        adderSubstacter.setMinNumber(minNumber);
        if (showHint.booleanValue()) {
            adderSubstacter.setMaxHint(localeService.getLanguageValue(locale, "\u5df2\u5168\u90e8\u51fa\u5e93"));
            adderSubstacter.setMinHint(localeService.getLanguageValue(locale, "\u5df2\u8fbe\u5230\u6700\u5c0f\u6570\u91cf"));
        }
        adderSubstacter.setDefaultNumber(Double.valueOf(StringUtils.hasLength((String)unReceiptQty) ? Double.parseDouble(unReceiptQty) : 0.0));
        adderSubstacter.setContainsZero(containsZero);
        return adderSubstacter;
    }

    public String returnComponentType() {
        return COMPONENT_TYPE;
    }

    private Double returnDefaultValue(Object value) {
        if (value == null) {
            return null;
        }
        try {
            return new Double(value.toString());
        }
        catch (Exception e) {
            return null;
        }
    }

    public void handleComponentParam(ComponentContext cmptContext, String mobilePath, String schema, Map<String, Object> data, PcUiBotExecuteContext executeContext, MobilePageRawData mobilePageRawData) {
        super.handleComponentParam(cmptContext, mobilePath, schema, data, executeContext, mobilePageRawData);
        this.defaultNumber = this.returnDefaultValue(UiBotDesignerRenderService.getDataByPathAndSchema(data, (String)mobilePath, (String)schema));
        if (Objects.isNull(this.defaultNumber)) {
            this.defaultNumber = (this.maxNumber + this.minNumber) / 2.0;
        }
    }

    public static BaseMobileComponent cardContentConvertComponent(Card.DesignerRawCard.Content rawContent, ComponentContext cmptContext, Map<String, Object> data, PcUiBotExecuteContext executeContext, MobilePageRawData mobilePageRawData) {
        AdderSubstracter adderSubstracter = new AdderSubstracter();
        adderSubstracter.setComponentId(rawContent.getComponentId());
        adderSubstracter.setTitle(rawContent.getLabel());
        adderSubstracter.setEnable(rawContent.getEditable());
        Card.DesignerRawCard.Content.AdderSubstracterObj adderSubstracterObj = (Card.DesignerRawCard.Content.AdderSubstracterObj)JsonUtil.objectToJavaObject((Object)rawContent.getSetting(), Card.DesignerRawCard.Content.AdderSubstracterObj.class);
        if (adderSubstracterObj != null) {
            adderSubstracter.setMinHint(adderSubstracterObj.getMinHint());
            adderSubstracter.setMaxHint(adderSubstracterObj.getMaxHint());
            adderSubstracter.setMaxNumber(adderSubstracterObj.getMaxNumber());
            adderSubstracter.setMinNumber(adderSubstracterObj.getMinNumber());
            adderSubstracter.setStepValue(adderSubstracterObj.getStepValue());
            adderSubstracter.setUseManualInput(adderSubstracterObj.getUseManualInput());
            adderSubstracter.setContainsZero(adderSubstracterObj.getContainsZero());
        }
        adderSubstracter.handleComponentParam(cmptContext, rawContent.getFullPath(), rawContent.getSchema(), data, executeContext, mobilePageRawData);
        return adderSubstracter;
    }

    public String getTitle() {
        return this.title;
    }

    public Double getStepValue() {
        return this.stepValue;
    }

    public Double getMaxNumber() {
        return this.maxNumber;
    }

    public String getMaxHint() {
        return this.maxHint;
    }

    public Double getMinNumber() {
        return this.minNumber;
    }

    public String getMinHint() {
        return this.minHint;
    }

    public Double getDefaultNumber() {
        return this.defaultNumber;
    }

    public Boolean getUseManualInput() {
        return this.useManualInput;
    }

    public Boolean getContainsZero() {
        return this.containsZero;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setStepValue(Double stepValue) {
        this.stepValue = stepValue;
    }

    public void setMaxNumber(Double maxNumber) {
        this.maxNumber = maxNumber;
    }

    public void setMaxHint(String maxHint) {
        this.maxHint = maxHint;
    }

    public void setMinNumber(Double minNumber) {
        this.minNumber = minNumber;
    }

    public void setMinHint(String minHint) {
        this.minHint = minHint;
    }

    public void setDefaultNumber(Double defaultNumber) {
        this.defaultNumber = defaultNumber;
    }

    public void setUseManualInput(Boolean useManualInput) {
        this.useManualInput = useManualInput;
    }

    public void setContainsZero(Boolean containsZero) {
        this.containsZero = containsZero;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AdderSubstracter)) {
            return false;
        }
        AdderSubstracter other = (AdderSubstracter)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Double this$stepValue = this.getStepValue();
        Double other$stepValue = other.getStepValue();
        if (this$stepValue == null ? other$stepValue != null : !((Object)this$stepValue).equals(other$stepValue)) {
            return false;
        }
        Double this$maxNumber = this.getMaxNumber();
        Double other$maxNumber = other.getMaxNumber();
        if (this$maxNumber == null ? other$maxNumber != null : !((Object)this$maxNumber).equals(other$maxNumber)) {
            return false;
        }
        Double this$minNumber = this.getMinNumber();
        Double other$minNumber = other.getMinNumber();
        if (this$minNumber == null ? other$minNumber != null : !((Object)this$minNumber).equals(other$minNumber)) {
            return false;
        }
        Double this$defaultNumber = this.getDefaultNumber();
        Double other$defaultNumber = other.getDefaultNumber();
        if (this$defaultNumber == null ? other$defaultNumber != null : !((Object)this$defaultNumber).equals(other$defaultNumber)) {
            return false;
        }
        Boolean this$useManualInput = this.getUseManualInput();
        Boolean other$useManualInput = other.getUseManualInput();
        if (this$useManualInput == null ? other$useManualInput != null : !((Object)this$useManualInput).equals(other$useManualInput)) {
            return false;
        }
        Boolean this$containsZero = this.getContainsZero();
        Boolean other$containsZero = other.getContainsZero();
        if (this$containsZero == null ? other$containsZero != null : !((Object)this$containsZero).equals(other$containsZero)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$maxHint = this.getMaxHint();
        String other$maxHint = other.getMaxHint();
        if (this$maxHint == null ? other$maxHint != null : !this$maxHint.equals(other$maxHint)) {
            return false;
        }
        String this$minHint = this.getMinHint();
        String other$minHint = other.getMinHint();
        return !(this$minHint == null ? other$minHint != null : !this$minHint.equals(other$minHint));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AdderSubstracter;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Double $stepValue = this.getStepValue();
        result = result * 59 + ($stepValue == null ? 43 : ((Object)$stepValue).hashCode());
        Double $maxNumber = this.getMaxNumber();
        result = result * 59 + ($maxNumber == null ? 43 : ((Object)$maxNumber).hashCode());
        Double $minNumber = this.getMinNumber();
        result = result * 59 + ($minNumber == null ? 43 : ((Object)$minNumber).hashCode());
        Double $defaultNumber = this.getDefaultNumber();
        result = result * 59 + ($defaultNumber == null ? 43 : ((Object)$defaultNumber).hashCode());
        Boolean $useManualInput = this.getUseManualInput();
        result = result * 59 + ($useManualInput == null ? 43 : ((Object)$useManualInput).hashCode());
        Boolean $containsZero = this.getContainsZero();
        result = result * 59 + ($containsZero == null ? 43 : ((Object)$containsZero).hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $maxHint = this.getMaxHint();
        result = result * 59 + ($maxHint == null ? 43 : $maxHint.hashCode());
        String $minHint = this.getMinHint();
        result = result * 59 + ($minHint == null ? 43 : $minHint.hashCode());
        return result;
    }

    public String toString() {
        return "AdderSubstracter(title=" + this.getTitle() + ", stepValue=" + this.getStepValue() + ", maxNumber=" + this.getMaxNumber() + ", maxHint=" + this.getMaxHint() + ", minNumber=" + this.getMinNumber() + ", minHint=" + this.getMinHint() + ", defaultNumber=" + this.getDefaultNumber() + ", useManualInput=" + this.getUseManualInput() + ", containsZero=" + this.getContainsZero() + ")";
    }

    public AdderSubstracter() {
    }

    public AdderSubstracter(String title, Double stepValue, Double maxNumber, String maxHint, Double minNumber, String minHint, Double defaultNumber, Boolean useManualInput, Boolean containsZero) {
        this.title = title;
        this.stepValue = stepValue;
        this.maxNumber = maxNumber;
        this.maxHint = maxHint;
        this.minNumber = minNumber;
        this.minHint = minHint;
        this.defaultNumber = defaultNumber;
        this.useManualInput = useManualInput;
        this.containsZero = containsZero;
    }
}

