/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.component.input.numeric;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.SpringContextHolder;
import com.digiwin.mobile.mobileuibot.common.datetime.DateTimeUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.common.math.MathUtil;
import com.digiwin.mobile.mobileuibot.core.component.BaseInputMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.ComponentContext;
import com.digiwin.mobile.mobileuibot.core.component.MobilePageRawData;
import com.digiwin.mobile.mobileuibot.core.component.button.Button;
import com.digiwin.mobile.mobileuibot.core.component.card.card.Card;
import com.digiwin.mobile.mobileuibot.core.component.input.numeric.InputNumericTypeEnum;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.bean.PcModuleEnum;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.util.ModuleUtils;
import com.digiwin.mobile.mobileuibot.core.rule.Rule;
import com.digiwin.mobile.mobileuibot.core.rule.relation.RelationRule;
import com.digiwin.mobile.mobileuibot.core.rule.relation.RelationRuleText;
import com.digiwin.mobile.mobileuibot.core.rule.validate.ValidateRule;
import com.digiwin.mobile.mobileuibot.core.rule.validate.ValidateRuleScopeEnum;
import com.digiwin.mobile.mobileuibot.core.rule.validate.ValidateRuleTypeEnum;
import com.digiwin.mobile.mobileuibot.designer.uibot.service.UiBotDesignerRenderService;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.rule.UiBotMaxLengthRuleAnalyzer;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.rule.UiBotRule;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableColumn;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableColumnEditor;
import com.digiwin.mobile.mobileuibot.proxy.uibot.parser.ParseFieldData;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class InputNumeric
extends BaseInputMobileComponent
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(InputNumeric.class);
    private static final long serialVersionUID = -5052577231874837283L;
    public static final String COMPONENT_TYPE = "INPUT_NUMERIC";
    private Integer maxLength;
    private Integer precision;
    private String text;
    private String title;
    private Integer type;
    private String unit;
    private Button button;
    private String buttonValue;
    private Map<String, Object> rawData;
    private Boolean thousandthPlace;

    public static InputNumeric create(Integer maxLength, Integer precision, String text, String title, Integer type) {
        InputNumeric inputNumeric = new InputNumeric();
        inputNumeric.setMaxLength(maxLength);
        inputNumeric.setPrecision(precision);
        inputNumeric.setText(text);
        inputNumeric.setTitle(title);
        inputNumeric.setType(type);
        inputNumeric.setErrorMessage("");
        return inputNumeric;
    }

    public static InputNumeric create(Integer maxLength, Integer precision, String text, String title, Integer type, Boolean isRequired, String unit) {
        InputNumeric inputNumeric = new InputNumeric();
        inputNumeric.setMaxLength(maxLength);
        inputNumeric.setPrecision(precision);
        inputNumeric.setText(text);
        inputNumeric.setTitle(title);
        inputNumeric.setType(type);
        inputNumeric.setErrorMessage("");
        inputNumeric.setRequired(isRequired);
        inputNumeric.setUnit(unit);
        return inputNumeric;
    }

    public static InputNumeric create(Integer maxLength, Integer precision, String text, String title, Integer type, RelationRule relationRule, Boolean required) {
        InputNumeric inputNumeric = new InputNumeric();
        inputNumeric.setMaxLength(maxLength);
        inputNumeric.setPrecision(precision);
        inputNumeric.setText(text);
        inputNumeric.setTitle(title);
        inputNumeric.setType(type);
        inputNumeric.setErrorMessage("");
        inputNumeric.setRelationRule(relationRule);
        inputNumeric.setRequired(required);
        inputNumeric.setEnable(required);
        return inputNumeric;
    }

    public static InputNumeric create(Integer maxLength, Integer precision, String title, Integer type, Boolean required, Boolean enable, String locale, List<UiBotRule> uiBotRuleList, String schema, LocaleService localeService) {
        InputNumeric inputNumeric = new InputNumeric();
        inputNumeric.setMaxLength(maxLength);
        inputNumeric.setPrecision(precision);
        inputNumeric.setTitle(title);
        inputNumeric.setType(type);
        inputNumeric.setRequired(required);
        inputNumeric.setEnable(enable);
        ArrayList<ValidateRule> validateRules = new ArrayList<ValidateRule>(1);
        ValidateRule validateRule = new ValidateRule();
        validateRule.setSchema(schema);
        validateRule.setParameter("^\\d*\\.{0,1}\\d{0,1}$");
        validateRule.setScope("EDIT");
        validateRule.setType("pattern");
        validateRules.add(validateRule);
        inputNumeric.setValidateRuleList(validateRules);
        inputNumeric.setErrorMessage(localeService.getLanguageValue(locale, "\u8bf7\u8f93\u5165\u6b63\u786e\u6570\u5b57"));
        return inputNumeric;
    }

    public static InputNumeric create(String locale, UiBotTableColumn column, List<UiBotRule> uiBotRuleList, Map<String, Object> bizData, List<Rule> mobileRuleList, ApiRequest apiRequest, Map<String, Object> variableMaps, LocaleService localeService) {
        InputNumeric inputNumeric = new InputNumeric();
        inputNumeric.setPlaceholder(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u8bf7\u8f93\u5165"));
        inputNumeric.setTitle(column.getHeaderName());
        inputNumeric.setType(InputNumericTypeEnum.INTEGER.getValue());
        String rawValueString = String.valueOf(bizData.get(column.getSchema()) == null ? Integer.valueOf(0) : bizData.get(column.getSchema()));
        rawValueString = rawValueString.equalsIgnoreCase("0.0") ? "0" : rawValueString;
        BigDecimal bd = new BigDecimal(rawValueString);
        rawValueString = bd.toPlainString();
        inputNumeric.setText(rawValueString);
        if ("PERCENT_INPUT".equalsIgnoreCase(Optional.ofNullable(column.getEditor()).map(UiBotTableColumnEditor::getType).orElse(""))) {
            Double value = Double.parseDouble(rawValueString) * 100.0;
            inputNumeric.setType(InputNumericTypeEnum.PERCENTAGE.getValue());
            inputNumeric.setText(String.valueOf(MathUtil.getDecimalPoint((double)value, (int)2, (Boolean)true)));
        }
        StringBuffer errMsgBuffer = new StringBuffer();
        if ("task_info".equalsIgnoreCase(column.getPath()) && "complete_rate".equalsIgnoreCase(column.getSchema())) {
            String text = new BigDecimal(rawValueString).multiply(new BigDecimal(100)).stripTrailingZeros().toPlainString();
            inputNumeric.setText(text);
            if (CollUtil.isNotEmpty(variableMaps) && ObjectUtil.isNotEmpty((Object)variableMaps.get("isReportableWork")) && !((Boolean)variableMaps.get("isReportableWork")).booleanValue()) {
                ArrayList<ValidateRule> validateRuleList = new ArrayList<ValidateRule>(1);
                ValidateRule validateRule1 = new ValidateRule();
                validateRule1.setSchema(column.getSchema());
                validateRule1.setScope(ValidateRuleScopeEnum.EDIT.getScope());
                validateRule1.setType(ValidateRuleTypeEnum.APPOINT.getType());
                validateRule1.setParameter("100");
                validateRule1.setErrorMessage(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u524d\u7f6e\u4efb\u52a1\u672a\u5b8c\u6210\u4e0d\u53ef100%\u62a5\u5de5"));
                validateRuleList.add(validateRule1);
                inputNumeric.setValidateRuleList(validateRuleList);
            }
            uiBotRuleList.forEach(a -> {
                if (null != a.getErrorMessage() && errMsgBuffer.length() == 0) {
                    errMsgBuffer.append(a.getErrorMessage());
                }
            });
        } else {
            uiBotRuleList.forEach(uiBotRule -> {
                if (null != uiBotRule.getErrorMessage()) {
                    if (errMsgBuffer.length() == 0) {
                        errMsgBuffer.append(uiBotRule.getErrorMessage());
                    } else {
                        errMsgBuffer.append(" ").append(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u6216")).append(" ").append(uiBotRule.getErrorMessage());
                    }
                }
            });
        }
        inputNumeric.setErrorMessage(errMsgBuffer.toString());
        Optional<UiBotRule> optColumnRequiredRule = uiBotRuleList.stream().filter(uiBotRule -> null != uiBotRule.getSchema() && "required".equalsIgnoreCase(uiBotRule.getKey()) && "EDIT".equalsIgnoreCase(uiBotRule.getScope())).findFirst();
        inputNumeric.setRequired(Boolean.valueOf(optColumnRequiredRule.isPresent()));
        Optional<Rule> optionalRequiredRule = mobileRuleList.stream().filter(rule -> column.getSchema().equalsIgnoreCase(rule.getSchema()) && "required".equalsIgnoreCase(rule.getType())).findFirst();
        if (optionalRequiredRule.isPresent()) {
            inputNumeric.setRequired(Boolean.valueOf(true));
        }
        UiBotMaxLengthRuleAnalyzer ruleAnalyzer = (UiBotMaxLengthRuleAnalyzer)SpringContextHolder.getBean(UiBotMaxLengthRuleAnalyzer.class);
        UiBotRule artificialUiBotRule = new UiBotRule();
        artificialUiBotRule.setSchema(column.getSchema());
        artificialUiBotRule.setKey("maxLength");
        inputNumeric.setMaxLength(ruleAnalyzer.analyzeByDefault(artificialUiBotRule));
        inputNumeric.setEnable(Boolean.valueOf(true));
        if (!CollectionUtils.isEmpty(variableMaps) && MapUtils.getBooleanValue(variableMaps, (Object)"withdraw") && ("complete_rate".equalsIgnoreCase(column.getSchema()) && !column.canEdit() || "work_hours".equalsIgnoreCase(column.getSchema()) && !column.canEdit())) {
            inputNumeric.setValidateRuleList(Collections.emptyList());
            inputNumeric.setRelationRule(null);
            inputNumeric.setRequired(Boolean.valueOf(false));
        } else {
            inputNumeric.addAllMobileRule(bizData, column.getSchema(), mobileRuleList, locale, apiRequest, variableMaps, inputNumeric.getText());
        }
        RelationRule relationRule = inputNumeric.getRelationRule();
        if (relationRule != null && !CollectionUtils.isEmpty((Collection)relationRule.getTextRuleList())) {
            List textRuleList = relationRule.getTextRuleList();
            ArrayList<RelationRuleText> newTextRuleList = new ArrayList<RelationRuleText>(textRuleList.size());
            for (RelationRuleText relationRuleText : textRuleList) {
                if ("report_work_description".equalsIgnoreCase(relationRuleText.getTargetSchema())) {
                    String data = (String)bizData.get("plan_finish_date");
                    Boolean isWorkReportRequired = false;
                    if (!CollectionUtils.isEmpty(variableMaps)) {
                        isWorkReportRequired = (Boolean)variableMaps.get("isWorkReportRequired");
                    }
                    if (!isWorkReportRequired.booleanValue() || !StringUtils.hasLength((String)data) || !DateTimeUtil.isBeforeNowDate((String)data).booleanValue()) continue;
                    relationRuleText.setTargetPlaceholder(localeService.getLanguageValue(locale, relationRuleText.getTargetPlaceholder()));
                    newTextRuleList.add(relationRuleText);
                    continue;
                }
                newTextRuleList.add(relationRuleText);
            }
            relationRule.setTextRuleList(newTextRuleList);
        }
        return inputNumeric;
    }

    public static InputNumeric create(String locale, ParseFieldData fieldData, List<UiBotRule> uiBotRuleList) {
        String rawValueString;
        InputNumeric inputNumeric = new InputNumeric();
        inputNumeric.setPlaceholder(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u8bf7\u8f93\u5165"));
        inputNumeric.setTitle(fieldData.getLabel());
        if (fieldData.getData() instanceof Integer || fieldData.getData() instanceof Double || fieldData.getData() instanceof Float) {
            if (PcModuleEnum.PERCENT_INPUT.getValue().equals(fieldData.getType())) {
                inputNumeric.setType(InputNumericTypeEnum.PERCENTAGE.getValue());
            } else {
                inputNumeric.setType(InputNumericTypeEnum.INTEGER.getValue());
            }
            rawValueString = String.valueOf(fieldData.getData());
        } else {
            inputNumeric.setType(InputNumericTypeEnum.INTEGER.getValue());
            rawValueString = "0";
        }
        inputNumeric.setText(rawValueString);
        StringBuffer errMsgBuffer = new StringBuffer();
        uiBotRuleList.forEach(uiBotRule -> {
            if (null != uiBotRule.getErrorMessage()) {
                if (errMsgBuffer.length() == 0) {
                    errMsgBuffer.append(uiBotRule.getErrorMessage());
                } else {
                    errMsgBuffer.append(" ").append(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u6216")).append(" ").append(uiBotRule.getErrorMessage());
                }
            }
        });
        inputNumeric.setErrorMessage(errMsgBuffer.toString());
        Optional<UiBotRule> optColumnRequiredRule = uiBotRuleList.stream().filter(uiBotRule -> null != uiBotRule.getSchema() && "required".equalsIgnoreCase(uiBotRule.getKey()) && "EDIT".equalsIgnoreCase(uiBotRule.getScope())).findFirst();
        inputNumeric.setRequired(Boolean.valueOf(optColumnRequiredRule.isPresent()));
        UiBotMaxLengthRuleAnalyzer ruleAnalyzer = (UiBotMaxLengthRuleAnalyzer)SpringContextHolder.getBean(UiBotMaxLengthRuleAnalyzer.class);
        UiBotRule artificialUiBotRule = new UiBotRule();
        artificialUiBotRule.setSchema(fieldData.getSchema());
        artificialUiBotRule.setKey("maxLength");
        inputNumeric.setMaxLength(ruleAnalyzer.analyzeByDefault(artificialUiBotRule));
        inputNumeric.setEnable(Boolean.valueOf(true));
        return inputNumeric;
    }

    public static InputNumeric create(String locale, ParseFieldData fieldData, List<UiBotRule> uiBotRuleList, Button button, String buttonValue, boolean isRequire) {
        InputNumeric inputNumeric = new InputNumeric();
        inputNumeric.setPlaceholder(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u8bf7\u8f93\u5165"));
        inputNumeric.setTitle(fieldData.getLabel());
        if (fieldData.getData() instanceof Integer || fieldData.getData() instanceof Double || fieldData.getData() instanceof Float) {
            if (PcModuleEnum.PERCENT_INPUT.getValue().equals(fieldData.getType())) {
                inputNumeric.setType(InputNumericTypeEnum.PERCENTAGE.getValue());
            } else {
                inputNumeric.setType(InputNumericTypeEnum.INTEGER.getValue());
            }
        } else {
            inputNumeric.setType(InputNumericTypeEnum.INTEGER.getValue());
        }
        StringBuffer errMsgBuffer = new StringBuffer();
        uiBotRuleList.forEach(uiBotRule -> {
            if (null != uiBotRule.getErrorMessage()) {
                if (errMsgBuffer.length() == 0) {
                    errMsgBuffer.append(uiBotRule.getErrorMessage());
                } else {
                    errMsgBuffer.append(" ").append(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u6216")).append(" ").append(uiBotRule.getErrorMessage());
                }
            }
        });
        inputNumeric.setErrorMessage(errMsgBuffer.toString());
        Optional<UiBotRule> optColumnRequiredRule = uiBotRuleList.stream().filter(uiBotRule -> null != uiBotRule.getSchema() && "required".equalsIgnoreCase(uiBotRule.getKey()) && "EDIT".equalsIgnoreCase(uiBotRule.getScope())).findFirst();
        inputNumeric.setRequired(Boolean.valueOf(optColumnRequiredRule.isPresent()));
        UiBotMaxLengthRuleAnalyzer ruleAnalyzer = (UiBotMaxLengthRuleAnalyzer)SpringContextHolder.getBean(UiBotMaxLengthRuleAnalyzer.class);
        UiBotRule artificialUiBotRule = new UiBotRule();
        artificialUiBotRule.setSchema(fieldData.getSchema());
        artificialUiBotRule.setKey("maxLength");
        inputNumeric.setMaxLength(ruleAnalyzer.analyzeByDefault(artificialUiBotRule));
        inputNumeric.setEnable(Boolean.valueOf(true));
        inputNumeric.setRequired(Boolean.valueOf(isRequire));
        inputNumeric.setButton(button);
        inputNumeric.setButtonValue(buttonValue);
        return inputNumeric;
    }

    public void addValidateRule(ValidateRule validateRule) {
        if (null != validateRule && !validateRule.ruleIsEmpty()) {
            this.getValidateRuleList().add(validateRule);
        }
    }

    public Integer getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(Integer maxLength) {
        this.maxLength = maxLength;
    }

    public Integer getPrecision() {
        return this.precision;
    }

    public void setPrecision(Integer precision) {
        this.precision = precision;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Integer getType() {
        return this.type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String returnComponentType() {
        return COMPONENT_TYPE;
    }

    public void handleComponentParam(ComponentContext cmptContext, String mobilePath, String schema, Map<String, Object> data, PcUiBotExecuteContext executeContext, MobilePageRawData mobilePageRawData) {
        super.handleComponentParam(cmptContext, mobilePath, schema, data, executeContext, mobilePageRawData);
        String value = Optional.ofNullable(UiBotDesignerRenderService.getDataByPathAndSchema(data, (String)mobilePath, (String)schema)).map(Object::toString).orElse(null);
        this.text = StringUtils.hasLength((String)value) ? this.removeExcessZero(value) : "";
        if (ObjectUtils.isEmpty((Object)this.placeholder)) {
            this.placeholder = ModuleUtils.localeService.getLanguageValue(executeContext.getLocale(), "\u8bf7\u8f93\u5165");
        }
        if (Objects.equals(InputNumericTypeEnum.INTEGER.getValue(), this.type)) {
            this.precision = 0;
        }
    }

    private String removeExcessZero(String value) {
        try {
            return new BigDecimal(value).stripTrailingZeros().toPlainString();
        }
        catch (Exception e) {
            log.error("removeExcessZero error, text:{}, error:{}", (Object)value, (Object)e.getMessage());
            return value;
        }
    }

    public static BaseMobileComponent cardContentConvertComponent(Card.DesignerRawCard.Content rawContent, ComponentContext cmptContext, Map<String, Object> data, PcUiBotExecuteContext executeContext, MobilePageRawData mobilePageRawData) {
        InputNumeric inputNumeric = new InputNumeric();
        inputNumeric.setComponentId(rawContent.getComponentId());
        inputNumeric.setTitle(rawContent.getLabel());
        inputNumeric.setEnable(rawContent.getEditable());
        Card.DesignerRawCard.Content.NumericalObj numericalObj = (Card.DesignerRawCard.Content.NumericalObj)JsonUtil.objectToJavaObject((Object)rawContent.getSetting(), Card.DesignerRawCard.Content.NumericalObj.class);
        if (numericalObj != null) {
            inputNumeric.setPlaceholder(numericalObj.getPlaceholder());
            inputNumeric.setUnit(numericalObj.getUnit());
            inputNumeric.setPrecision(numericalObj.getDecimalPoint());
            inputNumeric.setThousandthPlace(numericalObj.getThousandthPlace());
            inputNumeric.setType(numericalObj.getType());
        }
        inputNumeric.setType(InputNumericTypeEnum.INTEGER.getValue());
        inputNumeric.handleComponentParam(cmptContext, rawContent.getFullPath(), rawContent.getSchema(), data, executeContext, mobilePageRawData);
        return inputNumeric;
    }

    public InputNumeric(Integer maxLength, Integer precision, String text, String title, Integer type, String unit, Button button, String buttonValue, Map<String, Object> rawData, Boolean thousandthPlace) {
        this.maxLength = maxLength;
        this.precision = precision;
        this.text = text;
        this.title = title;
        this.type = type;
        this.unit = unit;
        this.button = button;
        this.buttonValue = buttonValue;
        this.rawData = rawData;
        this.thousandthPlace = thousandthPlace;
    }

    public InputNumeric() {
    }

    public String getUnit() {
        return this.unit;
    }

    public Button getButton() {
        return this.button;
    }

    public String getButtonValue() {
        return this.buttonValue;
    }

    public Map<String, Object> getRawData() {
        return this.rawData;
    }

    public Boolean getThousandthPlace() {
        return this.thousandthPlace;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public void setButton(Button button) {
        this.button = button;
    }

    public void setButtonValue(String buttonValue) {
        this.buttonValue = buttonValue;
    }

    public void setRawData(Map<String, Object> rawData) {
        this.rawData = rawData;
    }

    public void setThousandthPlace(Boolean thousandthPlace) {
        this.thousandthPlace = thousandthPlace;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InputNumeric)) {
            return false;
        }
        InputNumeric other = (InputNumeric)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Integer this$maxLength = this.getMaxLength();
        Integer other$maxLength = other.getMaxLength();
        if (this$maxLength == null ? other$maxLength != null : !((Object)this$maxLength).equals(other$maxLength)) {
            return false;
        }
        Integer this$precision = this.getPrecision();
        Integer other$precision = other.getPrecision();
        if (this$precision == null ? other$precision != null : !((Object)this$precision).equals(other$precision)) {
            return false;
        }
        Integer this$type = this.getType();
        Integer other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)this$type).equals(other$type)) {
            return false;
        }
        Boolean this$thousandthPlace = this.getThousandthPlace();
        Boolean other$thousandthPlace = other.getThousandthPlace();
        if (this$thousandthPlace == null ? other$thousandthPlace != null : !((Object)this$thousandthPlace).equals(other$thousandthPlace)) {
            return false;
        }
        String this$text = this.getText();
        String other$text = other.getText();
        if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$unit = this.getUnit();
        String other$unit = other.getUnit();
        if (this$unit == null ? other$unit != null : !this$unit.equals(other$unit)) {
            return false;
        }
        Button this$button = this.getButton();
        Button other$button = other.getButton();
        if (this$button == null ? other$button != null : !this$button.equals(other$button)) {
            return false;
        }
        String this$buttonValue = this.getButtonValue();
        String other$buttonValue = other.getButtonValue();
        if (this$buttonValue == null ? other$buttonValue != null : !this$buttonValue.equals(other$buttonValue)) {
            return false;
        }
        Map this$rawData = this.getRawData();
        Map other$rawData = other.getRawData();
        return !(this$rawData == null ? other$rawData != null : !((Object)this$rawData).equals(other$rawData));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InputNumeric;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $maxLength = this.getMaxLength();
        result = result * 59 + ($maxLength == null ? 43 : ((Object)$maxLength).hashCode());
        Integer $precision = this.getPrecision();
        result = result * 59 + ($precision == null ? 43 : ((Object)$precision).hashCode());
        Integer $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)$type).hashCode());
        Boolean $thousandthPlace = this.getThousandthPlace();
        result = result * 59 + ($thousandthPlace == null ? 43 : ((Object)$thousandthPlace).hashCode());
        String $text = this.getText();
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $unit = this.getUnit();
        result = result * 59 + ($unit == null ? 43 : $unit.hashCode());
        Button $button = this.getButton();
        result = result * 59 + ($button == null ? 43 : $button.hashCode());
        String $buttonValue = this.getButtonValue();
        result = result * 59 + ($buttonValue == null ? 43 : $buttonValue.hashCode());
        Map $rawData = this.getRawData();
        result = result * 59 + ($rawData == null ? 43 : ((Object)$rawData).hashCode());
        return result;
    }

    public String toString() {
        return "InputNumeric(maxLength=" + this.getMaxLength() + ", precision=" + this.getPrecision() + ", text=" + this.getText() + ", title=" + this.getTitle() + ", type=" + this.getType() + ", unit=" + this.getUnit() + ", button=" + this.getButton() + ", buttonValue=" + this.getButtonValue() + ", rawData=" + this.getRawData() + ", thousandthPlace=" + this.getThousandthPlace() + ")";
    }
}

