/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.component.input.scan.standard;

import com.digiwin.mobile.mobileuibot.core.component.BaseInputMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.ComponentContext;
import com.digiwin.mobile.mobileuibot.core.component.MobilePageRawData;
import com.digiwin.mobile.mobileuibot.core.component.input.scan.standard.InputScanTypeEnum;
import com.digiwin.mobile.mobileuibot.designer.uibot.service.UiBotDesignerRenderService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.util.StringUtils;

public class InputScan
extends BaseInputMobileComponent
implements Serializable {
    private static final long serialVersionUID = 6835905431866833719L;
    public static final String COMPONENT_TYPE = "INPUT_SCAN";
    private String title;
    private String text;
    private Integer scanType = InputScanTypeEnum.SINGLE_TEXT_SCAN.getValue();
    private String actionJsEvent;

    public String returnComponentType() {
        return COMPONENT_TYPE;
    }

    public void handleComponentParam(ComponentContext cmptContext, String mobilePath, String schema, Map<String, Object> data, PcUiBotExecuteContext executeContext, MobilePageRawData mobilePageRawData) {
        super.handleComponentParam(cmptContext, mobilePath, schema, data, executeContext, mobilePageRawData);
        String value = Optional.ofNullable(UiBotDesignerRenderService.getDataByPathAndSchema(data, (String)mobilePath, (String)schema)).map(Object::toString).orElse(null);
        if (StringUtils.hasLength((String)value)) {
            this.text = value;
        } else if (!BooleanUtils.isTrue((Boolean)this.enable)) {
            this.text = "";
        }
    }

    public String getTitle() {
        return this.title;
    }

    public String getText() {
        return this.text;
    }

    public Integer getScanType() {
        return this.scanType;
    }

    public String getActionJsEvent() {
        return this.actionJsEvent;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setScanType(Integer scanType) {
        this.scanType = scanType;
    }

    public void setActionJsEvent(String actionJsEvent) {
        this.actionJsEvent = actionJsEvent;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InputScan)) {
            return false;
        }
        InputScan other = (InputScan)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Integer this$scanType = this.getScanType();
        Integer other$scanType = other.getScanType();
        if (this$scanType == null ? other$scanType != null : !((Object)this$scanType).equals(other$scanType)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$text = this.getText();
        String other$text = other.getText();
        if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
            return false;
        }
        String this$actionJsEvent = this.getActionJsEvent();
        String other$actionJsEvent = other.getActionJsEvent();
        return !(this$actionJsEvent == null ? other$actionJsEvent != null : !this$actionJsEvent.equals(other$actionJsEvent));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InputScan;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $scanType = this.getScanType();
        result = result * 59 + ($scanType == null ? 43 : ((Object)$scanType).hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $text = this.getText();
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        String $actionJsEvent = this.getActionJsEvent();
        result = result * 59 + ($actionJsEvent == null ? 43 : $actionJsEvent.hashCode());
        return result;
    }

    public String toString() {
        return "InputScan(title=" + this.getTitle() + ", text=" + this.getText() + ", scanType=" + this.getScanType() + ", actionJsEvent=" + this.getActionJsEvent() + ")";
    }
}

