/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.component.progress;

import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.DataSource;
import com.digiwin.mobile.mobileuibot.core.component.card.card.Card;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.Attachment;
import com.digiwin.mobile.mobileuibot.core.component.progress.TaskProgress;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcTaskProgress;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcTaskProgressWorkItem;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcWorkflowPreSign;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcWorkflowSignHistory;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinReassignReport;
import com.digiwin.mobile.mobileuibot.proxy.bpm.model.DigiwinBpmRedoTask;
import com.digiwin.mobile.mobileuibot.proxy.eoc.model.EocPersonInfo;
import com.digiwin.mobile.mobileuibot.proxy.eoc.service.DigiwinEocProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.attachment.UiBotAttachment;
import com.digiwin.mobile.mobileuibot.task.model.ApcTaskProgressStateEnum;
import com.digiwin.mobile.mobileuibot.task.model.TaskProgressPerson;
import com.digiwin.mobile.mobileuibot.task.model.TaskProgressStateEnum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

public class TaskProgress
extends BaseMobileComponent {
    private static final long serialVersionUID = 2506512381261018371L;
    public static final String COMPONENT_TYPE = "TASK_PROGRESS";
    private String id;
    private String name;
    private Card.DesignerRawCard.Content nameSetting;
    private Integer styleType = 1;
    private List<TaskProgressPerson> personList = new ArrayList(8);
    private Integer state;
    private String status;
    private Card.DesignerRawCard.Content statusSetting;
    private DataSource dataSource;
    private List<TaskProgressContent> data;
    private String node;
    private String nodePath;
    private List<Card.DesignerRawCard.Content> contentList;

    public String returnComponentType() {
        return COMPONENT_TYPE;
    }

    public static TaskProgress createApcProgress(int i, Map<String, Object> reportAbnormal, String locale, LocaleService localeService, String iamUserToken, DigiwinEocProxyService digiwinEocProxyService) {
        TaskProgress progress = new TaskProgress();
        progress.setId((String)reportAbnormal.get("abnormal_doc_no"));
        progress.setName((String)reportAbnormal.get("abnormal_reason_name"));
        if (i == 0) {
            progress.setState(TaskProgressStateEnum.DOING.getValue());
        } else {
            progress.setState(TaskProgressStateEnum.DONE.getValue());
        }
        List personList = progress.getPersonList();
        TaskProgressPerson person = new TaskProgressPerson();
        person.setName((String)reportAbnormal.get("process_person_name"));
        String userId = "";
        if (reportAbnormal.get("process_person_no") != null) {
            EocPersonInfo personInfo = digiwinEocProxyService.getEocPersonInfo((String)reportAbnormal.get("process_person_no"), iamUserToken, 1);
            userId = personInfo.getUserId();
        }
        person.setUserId(userId);
        person.setComment((String)reportAbnormal.get("process_description"));
        person.setClosedTime((String)reportAbnormal.get("process_datetime"));
        int status = Integer.valueOf((String)reportAbnormal.get("process_status"));
        person.setState(Integer.valueOf(status));
        if (ApcTaskProgressStateEnum.\u5f85\u5904\u7406.getValue() == status) {
            person.setReassignContent(localeService.getLanguageValue(locale, ApcTaskProgressStateEnum.\u5f85\u5904\u7406.name()));
        } else if (ApcTaskProgressStateEnum.\u5df2\u5904\u7406.getValue() == status) {
            person.setReassignContent(localeService.getLanguageValue(locale, ApcTaskProgressStateEnum.\u5df2\u5904\u7406.name()));
        } else if (ApcTaskProgressStateEnum.\u56de\u590d.getValue() == status) {
            person.setReassignContent(localeService.getLanguageValue(locale, ApcTaskProgressStateEnum.\u56de\u590d.name()));
        } else if (ApcTaskProgressStateEnum.\u8f6c\u6d3e.getValue() == status) {
            person.setReassignContent(localeService.getLanguageValue(locale, ApcTaskProgressStateEnum.\u8f6c\u6d3e.name()));
        } else if (ApcTaskProgressStateEnum.\u9000\u56de.getValue() == status) {
            person.setReassignContent(localeService.getLanguageValue(locale, ApcTaskProgressStateEnum.\u9000\u56de.name()));
        } else if (ApcTaskProgressStateEnum.\u7ed3\u6848.getValue() == status) {
            person.setReassignContent(localeService.getLanguageValue(locale, ApcTaskProgressStateEnum.\u7ed3\u6848.name()));
        }
        UiBotAttachment attachment = (UiBotAttachment)JsonUtil.objectToJavaObject((Object)reportAbnormal.get("abnormal_handle_attachment"), UiBotAttachment.class);
        if (attachment != null && !CollectionUtils.isEmpty((Collection)attachment.getData())) {
            person.setFile(Attachment.uibotAttachmentparseAttachment((UiBotAttachment)attachment, (String)locale, (String)"\u9644\u4ef6"));
        }
        personList.add(person);
        return progress;
    }

    public static TaskProgress create(String locale, DigiwinAtmcTaskProgress digiwinAtmcTaskProcess) {
        TaskProgress taskProgress = new TaskProgress();
        taskProgress.setId(digiwinAtmcTaskProcess.getBpmActivityId());
        taskProgress.setName(digiwinAtmcTaskProcess.getBpmActivityName());
        if (null == digiwinAtmcTaskProcess.getState()) {
            digiwinAtmcTaskProcess.setState(Integer.valueOf(3));
        }
        taskProgress.setState(TaskProgressStateEnum.getByPcStateNumber((Integer)digiwinAtmcTaskProcess.getState()).getValue());
        if (null != digiwinAtmcTaskProcess.getWorkitemList()) {
            taskProgress.setPersonList(digiwinAtmcTaskProcess.getWorkitemList().stream().map(digiwinAtmcTaskProcessWorkItem -> {
                TaskProgressPerson person = TaskProgressPerson.create((String)locale, (DigiwinAtmcTaskProgressWorkItem)digiwinAtmcTaskProcessWorkItem);
                List attachments = digiwinAtmcTaskProcessWorkItem.getAttachments();
                if (!CollectionUtils.isEmpty((Collection)attachments)) {
                    person.setFile(Attachment.uibotAttachmentparseAttachment((List)attachments, (String)locale, (String)"\u9644\u4ef6"));
                }
                return person;
            }).collect(Collectors.toList()));
        } else {
            taskProgress.setPersonList(Collections.emptyList());
        }
        return taskProgress;
    }

    public static TaskProgress create(String locale, DigiwinAtmcWorkflowSignHistory digiwinAtmcWorkflowSignHistory) {
        TaskProgress taskProgress = new TaskProgress();
        taskProgress.setId(digiwinAtmcWorkflowSignHistory.getActivityId());
        taskProgress.setName(digiwinAtmcWorkflowSignHistory.getActivityName());
        if (ObjectUtils.isEmpty((Object)digiwinAtmcWorkflowSignHistory.getState())) {
            digiwinAtmcWorkflowSignHistory.setState(Integer.valueOf(3));
        }
        taskProgress.setState(TaskProgressStateEnum.getByPcStateNumber((Integer)digiwinAtmcWorkflowSignHistory.getState()).getValue());
        if (CollectionUtils.isEmpty((Collection)digiwinAtmcWorkflowSignHistory.getWorkItems())) {
            taskProgress.setPersonList(Collections.emptyList());
        } else {
            ArrayList progressPeople = new ArrayList();
            String activityType = digiwinAtmcWorkflowSignHistory.getActivityType();
            List workItems = digiwinAtmcWorkflowSignHistory.getWorkItems();
            for (int i = 0; i < workItems.size(); ++i) {
                List items = ((DigiwinAtmcWorkflowSignHistory.WorkItem)workItems.get(i)).getItem();
                progressPeople.addAll(items.stream().map(item -> {
                    TaskProgressPerson person = TaskProgressPerson.create((DigiwinAtmcTaskProgressWorkItem)item, (String)activityType, (String)locale);
                    List attachments = item.getAttachments();
                    if (!CollectionUtils.isEmpty((Collection)attachments)) {
                        person.setFile(Attachment.uibotAttachmentparseAttachment((List)attachments, (String)locale, (String)"\u9644\u4ef6"));
                    }
                    return person;
                }).collect(Collectors.toList()));
            }
            taskProgress.setPersonList(progressPeople);
        }
        return taskProgress;
    }

    public static TaskProgress create(String locale, DigiwinAtmcWorkflowPreSign digiwinAtmcWorkflowPreSign) {
        TaskProgress taskProgress = new TaskProgress();
        taskProgress.setId("");
        taskProgress.setName(digiwinAtmcWorkflowPreSign.getActivityName());
        taskProgress.setState(TaskProgressStateEnum.getByPcStateNumber((Integer)0).getValue());
        if (CollectionUtils.isEmpty((Collection)digiwinAtmcWorkflowPreSign.getWorkItems())) {
            taskProgress.setPersonList(Collections.emptyList());
        } else {
            ArrayList progressPeople = new ArrayList();
            List workItems = digiwinAtmcWorkflowPreSign.getWorkItems();
            for (int i = 0; i < workItems.size(); ++i) {
                List items = ((DigiwinAtmcWorkflowPreSign.WorkItem)workItems.get(i)).getItem();
                progressPeople.addAll(items.stream().map(item -> {
                    TaskProgressPerson person = TaskProgressPerson.create((DigiwinAtmcWorkflowPreSign.Item)item);
                    return person;
                }).collect(Collectors.toList()));
            }
            taskProgress.setPersonList(progressPeople);
        }
        return taskProgress;
    }

    public static TaskProgress create(String locale, DigiwinBpmRedoTask digiwinBpmRedoTask) {
        TaskProgress taskProgress = new TaskProgress();
        taskProgress.setId(digiwinBpmRedoTask.getBpmActivityId());
        taskProgress.setName(digiwinBpmRedoTask.getBpmActivityName());
        ArrayList<TaskProgressPerson> personList = new ArrayList<TaskProgressPerson>();
        personList.add(TaskProgressPerson.create((String)locale, (DigiwinBpmRedoTask)digiwinBpmRedoTask));
        taskProgress.setPersonList(personList);
        taskProgress.setState(TaskProgressStateEnum.DONE.getValue());
        return taskProgress;
    }

    public static TaskProgress create(String locale, DigiwinReassignReport reassignReport, Integer state) {
        TaskProgress taskProgress = new TaskProgress();
        taskProgress.setStyleType(Integer.valueOf(2));
        taskProgress.setId(String.valueOf(reassignReport.getId()));
        taskProgress.setName(reassignReport.getOldPerformerName() + LocaleUtil.getMobileTextByKey((String)locale, (String)"\u8f6c\u6d3e\u81f3") + reassignReport.getNewPerformerName());
        ArrayList<TaskProgressPerson> personList = new ArrayList<TaskProgressPerson>();
        personList.add(TaskProgressPerson.create((String)locale, (DigiwinReassignReport)reassignReport, (Integer)state));
        taskProgress.setPersonList(personList);
        taskProgress.setState(state);
        return taskProgress;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Card.DesignerRawCard.Content getNameSetting() {
        return this.nameSetting;
    }

    public Integer getStyleType() {
        return this.styleType;
    }

    public List<TaskProgressPerson> getPersonList() {
        return this.personList;
    }

    public Integer getState() {
        return this.state;
    }

    public String getStatus() {
        return this.status;
    }

    public Card.DesignerRawCard.Content getStatusSetting() {
        return this.statusSetting;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public List<TaskProgressContent> getData() {
        return this.data;
    }

    public String getNode() {
        return this.node;
    }

    public String getNodePath() {
        return this.nodePath;
    }

    public List<Card.DesignerRawCard.Content> getContentList() {
        return this.contentList;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setNameSetting(Card.DesignerRawCard.Content nameSetting) {
        this.nameSetting = nameSetting;
    }

    public void setStyleType(Integer styleType) {
        this.styleType = styleType;
    }

    public void setPersonList(List<TaskProgressPerson> personList) {
        this.personList = personList;
    }

    public void setState(Integer state) {
        this.state = state;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setStatusSetting(Card.DesignerRawCard.Content statusSetting) {
        this.statusSetting = statusSetting;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setData(List<TaskProgressContent> data) {
        this.data = data;
    }

    public void setNode(String node) {
        this.node = node;
    }

    public void setNodePath(String nodePath) {
        this.nodePath = nodePath;
    }

    public void setContentList(List<Card.DesignerRawCard.Content> contentList) {
        this.contentList = contentList;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TaskProgress)) {
            return false;
        }
        TaskProgress other = (TaskProgress)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Integer this$styleType = this.getStyleType();
        Integer other$styleType = other.getStyleType();
        if (this$styleType == null ? other$styleType != null : !((Object)this$styleType).equals(other$styleType)) {
            return false;
        }
        Integer this$state = this.getState();
        Integer other$state = other.getState();
        if (this$state == null ? other$state != null : !((Object)this$state).equals(other$state)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Card.DesignerRawCard.Content this$nameSetting = this.getNameSetting();
        Card.DesignerRawCard.Content other$nameSetting = other.getNameSetting();
        if (this$nameSetting == null ? other$nameSetting != null : !this$nameSetting.equals(other$nameSetting)) {
            return false;
        }
        List this$personList = this.getPersonList();
        List other$personList = other.getPersonList();
        if (this$personList == null ? other$personList != null : !((Object)this$personList).equals(other$personList)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        Card.DesignerRawCard.Content this$statusSetting = this.getStatusSetting();
        Card.DesignerRawCard.Content other$statusSetting = other.getStatusSetting();
        if (this$statusSetting == null ? other$statusSetting != null : !this$statusSetting.equals(other$statusSetting)) {
            return false;
        }
        DataSource this$dataSource = this.getDataSource();
        DataSource other$dataSource = other.getDataSource();
        if (this$dataSource == null ? other$dataSource != null : !this$dataSource.equals(other$dataSource)) {
            return false;
        }
        List this$data = this.getData();
        List other$data = other.getData();
        if (this$data == null ? other$data != null : !((Object)this$data).equals(other$data)) {
            return false;
        }
        String this$node = this.getNode();
        String other$node = other.getNode();
        if (this$node == null ? other$node != null : !this$node.equals(other$node)) {
            return false;
        }
        String this$nodePath = this.getNodePath();
        String other$nodePath = other.getNodePath();
        if (this$nodePath == null ? other$nodePath != null : !this$nodePath.equals(other$nodePath)) {
            return false;
        }
        List this$contentList = this.getContentList();
        List other$contentList = other.getContentList();
        return !(this$contentList == null ? other$contentList != null : !((Object)this$contentList).equals(other$contentList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TaskProgress;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $styleType = this.getStyleType();
        result = result * 59 + ($styleType == null ? 43 : ((Object)$styleType).hashCode());
        Integer $state = this.getState();
        result = result * 59 + ($state == null ? 43 : ((Object)$state).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Card.DesignerRawCard.Content $nameSetting = this.getNameSetting();
        result = result * 59 + ($nameSetting == null ? 43 : $nameSetting.hashCode());
        List $personList = this.getPersonList();
        result = result * 59 + ($personList == null ? 43 : ((Object)$personList).hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        Card.DesignerRawCard.Content $statusSetting = this.getStatusSetting();
        result = result * 59 + ($statusSetting == null ? 43 : $statusSetting.hashCode());
        DataSource $dataSource = this.getDataSource();
        result = result * 59 + ($dataSource == null ? 43 : $dataSource.hashCode());
        List $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        String $node = this.getNode();
        result = result * 59 + ($node == null ? 43 : $node.hashCode());
        String $nodePath = this.getNodePath();
        result = result * 59 + ($nodePath == null ? 43 : $nodePath.hashCode());
        List $contentList = this.getContentList();
        result = result * 59 + ($contentList == null ? 43 : ((Object)$contentList).hashCode());
        return result;
    }

    public String toString() {
        return "TaskProgress(id=" + this.getId() + ", name=" + this.getName() + ", nameSetting=" + this.getNameSetting() + ", styleType=" + this.getStyleType() + ", personList=" + this.getPersonList() + ", state=" + this.getState() + ", status=" + this.getStatus() + ", statusSetting=" + this.getStatusSetting() + ", dataSource=" + this.getDataSource() + ", data=" + this.getData() + ", node=" + this.getNode() + ", nodePath=" + this.getNodePath() + ", contentList=" + this.getContentList() + ")";
    }
}

