/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.component.progressbar;

import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.BaseInputMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.ComponentContext;
import com.digiwin.mobile.mobileuibot.core.component.MobilePageRawData;
import com.digiwin.mobile.mobileuibot.core.component.card.card.Card;
import com.digiwin.mobile.mobileuibot.core.component.progressbar.ProgressBarDecimalsEnum;
import com.digiwin.mobile.mobileuibot.core.component.progressbar.ProgressBarTypeEnum;
import com.digiwin.mobile.mobileuibot.designer.uibot.service.UiBotDesignerRenderService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Map;

public class ProgressBar
extends BaseInputMobileComponent
implements Serializable {
    private static final long serialVersionUID = 1174984245387959107L;
    public static final String COMPONENT_TYPE = "PROGRESS_BAR";
    private String title;
    private BigDecimal minValue = BigDecimal.ZERO;
    private BigDecimal maxValue = new BigDecimal("100");
    private BigDecimal defaultValue;
    private Integer type = ProgressBarTypeEnum.INTEGER_TYPE.getValue();
    private Integer decimals = ProgressBarDecimalsEnum.DECIMALS_TWO.getValue();
    private String unit = "%";
    private String activeColor1;
    private String activeColor2;

    public String returnComponentType() {
        return COMPONENT_TYPE;
    }

    private BigDecimal returnDefaultValue(Object value) {
        if (value == null) {
            return BigDecimal.ZERO;
        }
        try {
            return new BigDecimal(value.toString());
        }
        catch (Exception e) {
            return BigDecimal.ZERO;
        }
    }

    public void handleComponentParam(ComponentContext cmptContext, String mobilePath, String schema, Map<String, Object> data, PcUiBotExecuteContext executeContext, MobilePageRawData mobilePageRawData) {
        super.handleComponentParam(cmptContext, mobilePath, schema, data, executeContext, mobilePageRawData);
        BigDecimal value = this.returnDefaultValue(UiBotDesignerRenderService.getDataByPathAndSchema(data, (String)mobilePath, (String)schema));
        if (ProgressBarTypeEnum.INTEGER_TYPE.getValue().equals(this.type)) {
            this.defaultValue = value.setScale(0, RoundingMode.HALF_UP);
            this.maxValue = this.maxValue.setScale(0, RoundingMode.HALF_UP);
            this.minValue = this.minValue.setScale(0, RoundingMode.HALF_UP);
        } else {
            this.defaultValue = value.setScale((int)this.decimals, RoundingMode.HALF_UP);
            this.maxValue = this.maxValue.setScale((int)this.decimals, RoundingMode.HALF_UP);
            this.minValue = this.minValue.setScale((int)this.decimals, RoundingMode.HALF_UP);
        }
    }

    public static BaseMobileComponent cardContentConvertComponent(Card.DesignerRawCard.Content rawContent, ComponentContext cmptContext, Map<String, Object> data, PcUiBotExecuteContext executeContext, MobilePageRawData mobilePageRawData) {
        ProgressBar progressBar = new ProgressBar();
        progressBar.setComponentId(rawContent.getComponentId());
        progressBar.setTitle(rawContent.getLabel());
        progressBar.setEnable(rawContent.getEditable());
        Card.DesignerRawCard.Content.ProgressBarObj progressBarObj = (Card.DesignerRawCard.Content.ProgressBarObj)JsonUtil.objectToJavaObject((Object)rawContent.getSetting(), Card.DesignerRawCard.Content.ProgressBarObj.class);
        if (progressBarObj != null) {
            progressBar.setMinValue(progressBarObj.getMinValue());
            progressBar.setMaxValue(progressBarObj.getMaxValue());
            progressBar.setType(progressBarObj.getType());
            progressBar.setDecimals(progressBarObj.getDecimals());
            progressBar.setUnit(progressBarObj.getUnit());
            progressBar.setActiveColor1(progressBarObj.getActiveColor1());
            progressBar.setActiveColor2(progressBarObj.getActiveColor2());
        }
        progressBar.handleComponentParam(cmptContext, rawContent.getFullPath(), rawContent.getSchema(), data, executeContext, mobilePageRawData);
        return progressBar;
    }

    public String getTitle() {
        return this.title;
    }

    public BigDecimal getMinValue() {
        return this.minValue;
    }

    public BigDecimal getMaxValue() {
        return this.maxValue;
    }

    public BigDecimal getDefaultValue() {
        return this.defaultValue;
    }

    public Integer getType() {
        return this.type;
    }

    public Integer getDecimals() {
        return this.decimals;
    }

    public String getUnit() {
        return this.unit;
    }

    public String getActiveColor1() {
        return this.activeColor1;
    }

    public String getActiveColor2() {
        return this.activeColor2;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setMinValue(BigDecimal minValue) {
        this.minValue = minValue;
    }

    public void setMaxValue(BigDecimal maxValue) {
        this.maxValue = maxValue;
    }

    public void setDefaultValue(BigDecimal defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public void setDecimals(Integer decimals) {
        this.decimals = decimals;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public void setActiveColor1(String activeColor1) {
        this.activeColor1 = activeColor1;
    }

    public void setActiveColor2(String activeColor2) {
        this.activeColor2 = activeColor2;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProgressBar)) {
            return false;
        }
        ProgressBar other = (ProgressBar)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Integer this$type = this.getType();
        Integer other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)this$type).equals(other$type)) {
            return false;
        }
        Integer this$decimals = this.getDecimals();
        Integer other$decimals = other.getDecimals();
        if (this$decimals == null ? other$decimals != null : !((Object)this$decimals).equals(other$decimals)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        BigDecimal this$minValue = this.getMinValue();
        BigDecimal other$minValue = other.getMinValue();
        if (this$minValue == null ? other$minValue != null : !((Object)this$minValue).equals(other$minValue)) {
            return false;
        }
        BigDecimal this$maxValue = this.getMaxValue();
        BigDecimal other$maxValue = other.getMaxValue();
        if (this$maxValue == null ? other$maxValue != null : !((Object)this$maxValue).equals(other$maxValue)) {
            return false;
        }
        BigDecimal this$defaultValue = this.getDefaultValue();
        BigDecimal other$defaultValue = other.getDefaultValue();
        if (this$defaultValue == null ? other$defaultValue != null : !((Object)this$defaultValue).equals(other$defaultValue)) {
            return false;
        }
        String this$unit = this.getUnit();
        String other$unit = other.getUnit();
        if (this$unit == null ? other$unit != null : !this$unit.equals(other$unit)) {
            return false;
        }
        String this$activeColor1 = this.getActiveColor1();
        String other$activeColor1 = other.getActiveColor1();
        if (this$activeColor1 == null ? other$activeColor1 != null : !this$activeColor1.equals(other$activeColor1)) {
            return false;
        }
        String this$activeColor2 = this.getActiveColor2();
        String other$activeColor2 = other.getActiveColor2();
        return !(this$activeColor2 == null ? other$activeColor2 != null : !this$activeColor2.equals(other$activeColor2));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ProgressBar;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)$type).hashCode());
        Integer $decimals = this.getDecimals();
        result = result * 59 + ($decimals == null ? 43 : ((Object)$decimals).hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        BigDecimal $minValue = this.getMinValue();
        result = result * 59 + ($minValue == null ? 43 : ((Object)$minValue).hashCode());
        BigDecimal $maxValue = this.getMaxValue();
        result = result * 59 + ($maxValue == null ? 43 : ((Object)$maxValue).hashCode());
        BigDecimal $defaultValue = this.getDefaultValue();
        result = result * 59 + ($defaultValue == null ? 43 : ((Object)$defaultValue).hashCode());
        String $unit = this.getUnit();
        result = result * 59 + ($unit == null ? 43 : $unit.hashCode());
        String $activeColor1 = this.getActiveColor1();
        result = result * 59 + ($activeColor1 == null ? 43 : $activeColor1.hashCode());
        String $activeColor2 = this.getActiveColor2();
        result = result * 59 + ($activeColor2 == null ? 43 : $activeColor2.hashCode());
        return result;
    }

    public String toString() {
        return "ProgressBar(title=" + this.getTitle() + ", minValue=" + this.getMinValue() + ", maxValue=" + this.getMaxValue() + ", defaultValue=" + this.getDefaultValue() + ", type=" + this.getType() + ", decimals=" + this.getDecimals() + ", unit=" + this.getUnit() + ", activeColor1=" + this.getActiveColor1() + ", activeColor2=" + this.getActiveColor2() + ")";
    }

    public ProgressBar() {
    }

    public ProgressBar(String title, BigDecimal minValue, BigDecimal maxValue, BigDecimal defaultValue, Integer type, Integer decimals, String unit, String activeColor1, String activeColor2) {
        this.title = title;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.defaultValue = defaultValue;
        this.type = type;
        this.decimals = decimals;
        this.unit = unit;
        this.activeColor1 = activeColor1;
        this.activeColor2 = activeColor2;
    }
}

