/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.component.qrcode;

import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.qrcode.QrCodeContentMsg;
import java.io.Serializable;
import java.util.Set;
import org.springframework.util.StringUtils;

public class QrCode
extends BaseMobileComponent
implements Serializable {
    private static final long serialVersionUID = 1174984745387959107L;
    public static final String COMPONENT_TYPE = "QR_CODE";
    private String content;
    private String hint;

    public static QrCode create(QrCodeContentMsg qrCodeContentMsg, String hint) {
        QrCode qrCode = new QrCode();
        String content = AppContext.getBaseUrl();
        StringBuffer sb = new StringBuffer();
        if (StringUtils.hasLength((String)qrCodeContentMsg.getBizType())) {
            sb.append("&bizType=").append(qrCodeContentMsg.getBizType());
        }
        if (StringUtils.hasLength((String)qrCodeContentMsg.getTimestamp())) {
            sb.append("&timestamp=").append(qrCodeContentMsg.getTimestamp());
        }
        Set keys = qrCodeContentMsg.keySet();
        keys.forEach(key -> {
            String value = (String)qrCodeContentMsg.get(key);
            if (StringUtils.hasLength((String)key) && StringUtils.hasLength((String)value)) {
                sb.append("&").append((String)key).append("=").append(value);
            }
        });
        if (sb.length() > 0) {
            String suffix = sb.substring(1);
            content = content + "?" + suffix;
        }
        qrCode.setContent(content);
        qrCode.setHint(hint);
        return qrCode;
    }

    public String returnComponentType() {
        return COMPONENT_TYPE;
    }

    public String getContent() {
        return this.content;
    }

    public String getHint() {
        return this.hint;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setHint(String hint) {
        this.hint = hint;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QrCode)) {
            return false;
        }
        QrCode other = (QrCode)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        String this$hint = this.getHint();
        String other$hint = other.getHint();
        return !(this$hint == null ? other$hint != null : !this$hint.equals(other$hint));
    }

    protected boolean canEqual(Object other) {
        return other instanceof QrCode;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        String $hint = this.getHint();
        result = result * 59 + ($hint == null ? 43 : $hint.hashCode());
        return result;
    }

    public String toString() {
        return "QrCode(content=" + this.getContent() + ", hint=" + this.getHint() + ")";
    }
}

