/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.component.tab.standardtab;

import com.digiwin.mobile.mobileuibot.common.context.SpringContextHolder;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.common.PcmFilterUtil;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.ComponentContext;
import com.digiwin.mobile.mobileuibot.core.component.MobilePageRawData;
import com.digiwin.mobile.mobileuibot.core.component.action.BusinessRawData;
import com.digiwin.mobile.mobileuibot.core.component.card.card.Card;
import com.digiwin.mobile.mobileuibot.core.component.list.ztbviewlist.ZtbViewList;
import com.digiwin.mobile.mobileuibot.core.component.tab.standardtab.StandardTabsContentArea;
import com.digiwin.mobile.mobileuibot.core.component.tab.standardtab.StandardTabsItem;
import com.digiwin.mobile.mobileuibot.designer.uibot.enums.BusinessTypeEnum;
import com.digiwin.mobile.mobileuibot.designer.uibot.service.UiBotDesignerRenderService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotRenderData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class StandardTabs
extends BaseMobileComponent {
    private static final long serialVersionUID = -8026287517050798816L;
    public static final String COMPONENT_TYPE = "STANDARD_TABS";
    private Integer tabAlign;
    private List<StandardTabsItem> tabItems;
    private Integer defaultSelected = 0;

    public String returnComponentType() {
        return COMPONENT_TYPE;
    }

    public void handleComponentParam(ComponentContext cmptContext, String mobilePath, String schema, Map<String, Object> data, PcUiBotExecuteContext executeContext, MobilePageRawData mobilePageRawData) {
        super.handleComponentParam(cmptContext, mobilePath, schema, data, executeContext, mobilePageRawData);
        this.customizePcmBudgetProjectApprovals(data, executeContext);
        List tabItems = this.getTabItems();
        if (!CollectionUtils.isEmpty((Collection)tabItems)) {
            UiBotDesignerRenderService uiBotDesignerRenderService = (UiBotDesignerRenderService)SpringContextHolder.getBean(UiBotDesignerRenderService.class);
            for (StandardTabsItem tabItem : tabItems) {
                StandardTabsContentArea contentArea = tabItem.getContentArea();
                uiBotDesignerRenderService.buildCmptDsl(cmptContext, executeContext, contentArea.getBodyArea(), data, mobilePageRawData);
                if (CollectionUtils.isEmpty((Collection)contentArea.getBodyArea())) {
                    contentArea.getBodyArea().add(UiBotRenderData.createEmptyWrapper());
                }
                contentArea.resetSize();
                contentArea.resetFilterFlag();
            }
            this.defaultSelected = this.buildDefaultSelected(cmptContext, executeContext, tabItems);
        }
    }

    private Integer buildDefaultSelected(ComponentContext cmptContext, PcUiBotExecuteContext executeContext, List<StandardTabsItem> tabItems) {
        if (PcmFilterUtil.isPcmCustomized((String)executeContext.getTmActivityId(), (String)executeContext.getTmProjectId()).booleanValue()) {
            return this.customizePcmBudgetProjectApprovalsDefaultSelected(cmptContext, tabItems);
        }
        Integer defaultSelected = this.getDefaultSelected();
        if (CollectionUtils.isEmpty(tabItems)) {
            return defaultSelected;
        }
        return defaultSelected;
    }

    private Integer customizePcmBudgetProjectApprovalsDefaultSelected(ComponentContext cmptContext, List<StandardTabsItem> tabItems) {
        String componentId;
        Integer defaultSelected = this.getDefaultSelected();
        if (CollectionUtils.isEmpty(tabItems)) {
            return defaultSelected;
        }
        String businessType = cmptContext.getRawData().getBusinessType();
        if (null == businessType) {
            return defaultSelected;
        }
        BusinessRawData businessRawData = cmptContext.getRawData().getBusinessRawData();
        if (null == businessRawData) {
            return defaultSelected;
        }
        if (BusinessTypeEnum.FILTER.getValue().equalsIgnoreCase(businessType) && businessRawData.getRefreshPageId().equalsIgnoreCase(cmptContext.getPageId()) && StringUtils.hasLength((String)(componentId = businessRawData.getComponentId()))) {
            for (int i = 0; i < tabItems.size(); ++i) {
                StandardTabsContentArea contentArea = tabItems.get(i).getContentArea();
                if (CollectionUtils.isEmpty((Collection)contentArea.getBodyArea()) || !contentArea.getBodyArea().stream().anyMatch(wrapper -> componentId.equals(wrapper.returnComponentId()))) continue;
                defaultSelected = i;
            }
        }
        return defaultSelected;
    }

    private void customizePcmBudgetProjectApprovals(Map<String, Object> data, PcUiBotExecuteContext executeContext) {
        if (!PcmFilterUtil.isPcmCustomized((String)executeContext.getTmActivityId(), (String)executeContext.getTmProjectId()).booleanValue()) {
            return;
        }
        this.customizePcmBudgetProjectApprovalsTab(data);
    }

    private void customizePcmBudgetProjectApprovalsTab(Map<String, Object> data) {
        List rawTabsItem = this.getTabItems();
        ArrayList newTabItems = new ArrayList();
        rawTabsItem.stream().filter(item -> "0".equals(item.getId())).findFirst().ifPresent(newTabItems::add);
        this.setTabItems(newTabItems);
        List projectBudgetItemDetail = (List)data.get("project_budget_item_detail");
        if (CollectionUtils.isEmpty((Collection)projectBudgetItemDetail)) {
            return;
        }
        StandardTabsItem materialTabTemplate = rawTabsItem.stream().filter(item -> "1".equals(item.getId())).findFirst().orElse(new StandardTabsItem());
        StandardTabsItem expensesTabTemplate = rawTabsItem.stream().filter(item -> "2".equals(item.getId())).findFirst().orElse(new StandardTabsItem());
        projectBudgetItemDetail.forEach(item -> {
            String budgetItemType = (String)item.get("budget_item_type");
            if ("1".equals(budgetItemType)) {
                this.handleMobilePathAndSchema(materialTabTemplate);
                StandardTabsItem materialTab = (StandardTabsItem)JsonUtil.objectToJavaObject((Object)materialTabTemplate, StandardTabsItem.class);
                materialTab.setName((String)item.get("budget_item_name"));
                this.handleFilterCondition(materialTab);
                newTabItems.add(materialTab);
            } else if ("2".equals(budgetItemType)) {
                this.handleMobilePathAndSchema(expensesTabTemplate);
                StandardTabsItem expensesTab = (StandardTabsItem)JsonUtil.objectToJavaObject((Object)expensesTabTemplate, StandardTabsItem.class);
                expensesTab.setName((String)item.get("budget_item_name"));
                this.handleFilterCondition(expensesTab);
                newTabItems.add(expensesTab);
            }
        });
    }

    private void handleMobilePathAndSchema(StandardTabsItem tabTemplate) {
        StandardTabsContentArea contentArea = tabTemplate.getContentArea();
        if (contentArea == null) {
            return;
        }
        contentArea.getBodyArea().stream().filter(bodyArea -> "DW_ZTB_VIEW_LIST".equals(bodyArea.getComponentType())).forEach(wrapper -> {
            wrapper.setMobilePath(wrapper.getMobilePath() + "&");
            wrapper.setSchema(wrapper.getSchema() + "&");
            wrapper.getData().setSchema(wrapper.getSchema());
            wrapper.getData().setMobilePath(wrapper.getMobilePath());
        });
    }

    private void handleFilterCondition(StandardTabsItem tabTemplate) {
        StandardTabsContentArea contentArea = tabTemplate.getContentArea();
        if (contentArea == null) {
            return;
        }
        contentArea.getBodyArea().stream().filter(bodyArea -> "DW_ZTB_VIEW_LIST".equals(bodyArea.getComponentType())).forEach(cardList -> {
            List processedConditionList;
            Card.DesignerRawCard data;
            ZtbViewList component = (ZtbViewList)cardList.getData();
            Card card = component.getCardListData();
            if (card != null && (data = card.getData()) != null && !CollectionUtils.isEmpty((Collection)(processedConditionList = data.getProcessedConditionList()))) {
                processedConditionList.forEach(processedCondition -> processedCondition.setValue(tabTemplate.getName()));
            }
        });
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StandardTabs)) {
            return false;
        }
        StandardTabs other = (StandardTabs)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$tabAlign = this.getTabAlign();
        Integer other$tabAlign = other.getTabAlign();
        if (this$tabAlign == null ? other$tabAlign != null : !((Object)this$tabAlign).equals(other$tabAlign)) {
            return false;
        }
        Integer this$defaultSelected = this.getDefaultSelected();
        Integer other$defaultSelected = other.getDefaultSelected();
        if (this$defaultSelected == null ? other$defaultSelected != null : !((Object)this$defaultSelected).equals(other$defaultSelected)) {
            return false;
        }
        List this$tabItems = this.getTabItems();
        List other$tabItems = other.getTabItems();
        return !(this$tabItems == null ? other$tabItems != null : !((Object)this$tabItems).equals(other$tabItems));
    }

    protected boolean canEqual(Object other) {
        return other instanceof StandardTabs;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $tabAlign = this.getTabAlign();
        result = result * 59 + ($tabAlign == null ? 43 : ((Object)$tabAlign).hashCode());
        Integer $defaultSelected = this.getDefaultSelected();
        result = result * 59 + ($defaultSelected == null ? 43 : ((Object)$defaultSelected).hashCode());
        List $tabItems = this.getTabItems();
        result = result * 59 + ($tabItems == null ? 43 : ((Object)$tabItems).hashCode());
        return result;
    }

    public Integer getTabAlign() {
        return this.tabAlign;
    }

    public List<StandardTabsItem> getTabItems() {
        return this.tabItems;
    }

    public Integer getDefaultSelected() {
        return this.defaultSelected;
    }

    public void setTabAlign(Integer tabAlign) {
        this.tabAlign = tabAlign;
    }

    public void setTabItems(List<StandardTabsItem> tabItems) {
        this.tabItems = tabItems;
    }

    public void setDefaultSelected(Integer defaultSelected) {
        this.defaultSelected = defaultSelected;
    }

    public String toString() {
        return "StandardTabs(tabAlign=" + this.getTabAlign() + ", tabItems=" + this.getTabItems() + ", defaultSelected=" + this.getDefaultSelected() + ")";
    }
}

