/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.layout.analyzer;

import com.digiwin.mobile.mobileuibot.core.component.MobileLayoutTypeEnum;
import com.digiwin.mobile.mobileuibot.core.layout.LayoutGeneratorPreprocessData;
import com.digiwin.mobile.mobileuibot.core.layout.analyzer.LayoutAnalyzer;
import com.digiwin.mobile.mobileuibot.core.layout.analyzer.LayoutAnalyzerTypeEnum;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="bizDataLayoutAnalyzer")
public class BizDataLayoutAnalyzer
implements LayoutAnalyzer<Object> {
    public String getType() {
        return LayoutAnalyzerTypeEnum.BIZ_DATA_TYPE.toString();
    }

    public MobileLayoutTypeEnum getLayoutType(LayoutGeneratorPreprocessData preprocessData) {
        Map bizDataMap = preprocessData.getBizDataMap();
        Map bizMetadataMap = preprocessData.getBizMetadataMap();
        if (CollectionUtils.isEmpty((Map)bizDataMap)) {
            return MobileLayoutTypeEnum.MULTI_PATTERN_LAYOUT;
        }
        if (bizDataMap.size() == 1) {
            String bizDataKey = (String)bizDataMap.keySet().iterator().next();
            Map bizData = bizDataMap.getOrDefault(bizDataKey, Collections.emptyMap());
            return this.getLayoutTypeBySingleBizData(bizData, bizMetadataMap);
        }
        boolean hasMultiLevelLayout = false;
        for (Map.Entry bizDataKey : bizDataMap.entrySet()) {
            Map bizData = bizDataMap.getOrDefault(bizDataKey, Collections.emptyMap());
            if (bizData instanceof Map) {
                MobileLayoutTypeEnum mobileLayoutTypeEnum = this.getLayoutTypeBySingleBizData(bizData, bizMetadataMap);
                if (!Objects.equals(mobileLayoutTypeEnum, MobileLayoutTypeEnum.MULTI_PATTERN_LAYOUT)) continue;
                hasMultiLevelLayout = true;
                break;
            }
            throw new IllegalArgumentException("Expected a Map but found: " + bizData.getClass().getName());
        }
        return hasMultiLevelLayout ? MobileLayoutTypeEnum.MULTI_PATTERN_LAYOUT : MobileLayoutTypeEnum.SINGLE_PATTERN_LAYOUT;
    }

    private MobileLayoutTypeEnum getLayoutTypeBySingleBizData(Object bizData, Map<String, Object> bizMetadata) {
        if (Objects.isNull(bizData)) {
            return MobileLayoutTypeEnum.MULTI_PATTERN_LAYOUT;
        }
        if (bizData instanceof List) {
            List listData = (List)bizData;
            if (listData.size() <= 1) {
                return MobileLayoutTypeEnum.SINGLE_PATTERN_LAYOUT;
            }
            return MobileLayoutTypeEnum.MULTI_PATTERN_LAYOUT;
        }
        if (bizData instanceof Map) {
            return MobileLayoutTypeEnum.SINGLE_PATTERN_LAYOUT;
        }
        return MobileLayoutTypeEnum.MULTI_PATTERN_LAYOUT;
    }
}

