/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.layout.doublepattern.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.appec.ComponentBox;
import com.digiwin.mobile.mobileuibot.core.appec.LeftBody;
import com.digiwin.mobile.mobileuibot.core.appec.LeftFooter;
import com.digiwin.mobile.mobileuibot.core.appec.LeftHeader;
import com.digiwin.mobile.mobileuibot.core.appec.SlipConfig;
import com.digiwin.mobile.mobileuibot.core.appec.SlipConfigLeft;
import com.digiwin.mobile.mobileuibot.core.appec.SlipConfigRight;
import com.digiwin.mobile.mobileuibot.core.appec.SlipTitle;
import com.digiwin.mobile.mobileuibot.core.appec.SlipTypeEnum;
import com.digiwin.mobile.mobileuibot.core.appec.UiBotSlip;
import com.digiwin.mobile.mobileuibot.core.columntag.ColumnTagService;
import com.digiwin.mobile.mobileuibot.core.common.BackgroundColorEnum;
import com.digiwin.mobile.mobileuibot.core.component.MobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.MobileLayoutTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.MobileRenderMetaData;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.basic.AutoFill;
import com.digiwin.mobile.mobileuibot.core.component.basic.AutoFillData;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonList;
import com.digiwin.mobile.mobileuibot.core.component.button.Button;
import com.digiwin.mobile.mobileuibot.core.component.button.ButtonRawData;
import com.digiwin.mobile.mobileuibot.core.component.search.SearchCategory;
import com.digiwin.mobile.mobileuibot.core.component.search.SkipConfig;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtab.CustomTabContentContainer;
import com.digiwin.mobile.mobileuibot.core.component.tab.tabscroll.TabScrollContainer;
import com.digiwin.mobile.mobileuibot.core.component.title.titlebody.TitleBody;
import com.digiwin.mobile.mobileuibot.core.layout.LayoutGeneratorPreprocessData;
import com.digiwin.mobile.mobileuibot.core.layout.LayoutGeneratorService;
import com.digiwin.mobile.mobileuibot.core.layout.LayoutGeneratorServiceResult;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.bean.PcLayoutEnum;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.bean.PcModuleEnum;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.service.UniversalParsingService;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.util.ModuleUtils;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.core.rule.RuleService;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.atdm.service.DigiwinAtdmProxyService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogDetail;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcTaskProgress;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinReassignReport;
import com.digiwin.mobile.mobileuibot.proxy.atmc.service.DigiwinAtmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.eoc.model.EocPersonResponse;
import com.digiwin.mobile.mobileuibot.proxy.eoc.service.DigiwinEocProxyService;
import com.digiwin.mobile.mobileuibot.proxy.esp.service.DigiwinEspProxyService;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.service.DigiwinKnowledgeMapsProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.button.UiBotQueryButton;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableColumnDefinition;
import com.digiwin.mobile.mobileuibot.task.model.TaskDetailBizReport;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="universalParsingService")
public class UniversalParsingServiceImpl
implements UniversalParsingService {
    private static final Logger log = LoggerFactory.getLogger(UniversalParsingServiceImpl.class);
    private static final String TABS_SCHEMA = "tabs";
    private static final String TITLE_REPLY_DATA = "titleDescription";
    public static final String TABSCROLL_SCHEMA = "tabScroll";
    private static final Integer PATTERN_TYPE_SINGLE = 1;
    private static final Integer PATTERN_TYPE_DOUBLE = 2;
    @Autowired
    private LocaleService localeService;
    @Autowired
    private LayoutGeneratorService layoutGeneratorService;
    @Autowired
    private RuleService ruleService;
    @Autowired
    private ColumnTagService columnTagService;
    @Autowired
    private DigiwinAtmcProxyService digiwinAtmcProxyService;
    @Autowired
    private DigiwinAtdmProxyService digiwinAtdmProxyService;
    @Autowired
    private DigiwinEspProxyService digiwinEspProxyService;
    @Autowired
    private DigiwinEocProxyService digiwinEocProxyService;
    @Autowired
    private DigiwinKnowledgeMapsProxyService digiwinKnowledgeMapsProxyService;

    public UiBotModel buildPatternModel(ApiRequest apiRequest, PageSetting oldpageSetting, UiBotModel pcUiBotModel, DigiwinAtmcBacklogDetail digiwinAtmcBacklogDetail, List<DigiwinAtmcTaskProgress> digiwinAtmcTaskProgressList, List<DigiwinReassignReport> reassignReportList) {
        ArrayList<String> targetLayoutTypeList = new ArrayList<String>();
        targetLayoutTypeList.add(PcLayoutEnum.TABLE.getValue());
        targetLayoutTypeList.add(PcLayoutEnum.ATHENA_TABLE.getValue());
        targetLayoutTypeList.add(PcLayoutEnum.FORM_LIST.getValue());
        targetLayoutTypeList.add("SPLIT_LAYOUT");
        UiBotModel targetLayoutAndPageDataModel = pcUiBotModel.searchPcTargetModel(targetLayoutTypeList, Collections.emptyList(), false);
        HashMap preProcessDataBizDataMap = new HashMap(1);
        targetLayoutAndPageDataModel.getLayout().forEach(layout -> {
            String layoutSchemaKey = layout.getSchema();
            preProcessDataBizDataMap.put(layoutSchemaKey, pcUiBotModel.getPageData().get((Object)layoutSchemaKey));
        });
        LayoutGeneratorPreprocessData preprocessData = LayoutGeneratorPreprocessData.builder().renderVersion(MobileRenderMetaData.RENDER_VERSION_1).apiRequest(apiRequest).pcUiBotModel(pcUiBotModel).bizDataMap(preProcessDataBizDataMap).build();
        LayoutGeneratorServiceResult layoutGeneratorServiceResult = this.layoutGeneratorService.generate(preprocessData);
        UiBotModel resultMobileUiBotModel = Objects.equals(MobileLayoutTypeEnum.SINGLE_PATTERN_LAYOUT, layoutGeneratorServiceResult.getLayoutTypeEnum()) ? this.buildSinglePatternModel(apiRequest, oldpageSetting, layoutGeneratorServiceResult, pcUiBotModel, digiwinAtmcBacklogDetail, digiwinAtmcTaskProgressList, reassignReportList) : this.buildDoublePatternModel(apiRequest, oldpageSetting, layoutGeneratorServiceResult, pcUiBotModel, digiwinAtmcBacklogDetail, digiwinAtmcTaskProgressList, reassignReportList);
        resultMobileUiBotModel.setLayoutGeneratorServiceResult(layoutGeneratorServiceResult);
        resultMobileUiBotModel.setAppliedDesignerFieldAndOrder(pcUiBotModel.getAppliedDesignerFieldAndOrder());
        resultMobileUiBotModel.setAppliedDesignerFieldTag(pcUiBotModel.getAppliedDesignerFieldTag());
        resultMobileUiBotModel.setAppliedDesignerFieldRule(pcUiBotModel.getAppliedDesignerFieldRule());
        resultMobileUiBotModel.setAppliedDesignerFieldOperation(pcUiBotModel.getAppliedDesignerFieldOperation());
        return resultMobileUiBotModel;
    }

    public UiBotModel buildShowTitleAndEmpty(UiBotModel uiBotModel, ApiRequest apiRequest) {
        LayoutGeneratorServiceResult layoutGeneratorServiceResult = uiBotModel.getLayoutGeneratorServiceResult();
        if (null == layoutGeneratorServiceResult) {
            return uiBotModel;
        }
        uiBotModel.buildShowTitleAndEmpty(this.localeService, apiRequest.getLocale());
        return uiBotModel;
    }

    private UiBotModel buildSinglePatternModel(ApiRequest apiRequest, PageSetting oldPageSetting, LayoutGeneratorServiceResult layoutGeneratorServiceResult, UiBotModel pcUiBotModel, DigiwinAtmcBacklogDetail digiwinAtmcBacklogDetail, List<DigiwinAtmcTaskProgress> digiwinAtmcTaskProgressList, List<DigiwinReassignReport> reassignReportList) {
        List pcLayouts = pcUiBotModel.getLayout();
        ArrayList<UiBotLayout> mobileLayouts = new ArrayList<UiBotLayout>(pcLayouts.size());
        UiBotModel mobileUiBotModel = new UiBotModel(mobileLayouts);
        UiBotPageData mobilePageData = new UiBotPageData();
        mobileUiBotModel.setPageData(mobilePageData);
        boolean headHasEdit = false;
        String locale = apiRequest.getLocale();
        for (UiBotLayout pcLayout : pcLayouts) {
            Object operations;
            List tableColumnDefinitionList;
            TitleBody mobileComponent;
            String type = pcLayout.getType();
            String schema = pcLayout.getSchema();
            UiBotLayout mobileLayout = new UiBotLayout();
            if (type.equals(PcModuleEnum.ACTIVITY_TITLE.getValue()) || type.equals(PcModuleEnum.DELIVERY_REPLY_TITLE.getValue())) {
                UiBotLayout findLayout = UiBotModel.getApprovalDesriptionLayout((List)pcUiBotModel.getLayout());
                if (findLayout != null) {
                    Map data = (Map)pcUiBotModel.getPageData().get((Object)findLayout.getSchema());
                    mobileComponent = TitleBody.createApc((String)locale, (DigiwinAtmcBacklogDetail)digiwinAtmcBacklogDetail, (UiBotLayout)findLayout, (Map)data);
                } else {
                    mobileComponent = ModuleUtils.buildTitle((UiBotModel)pcUiBotModel, (Map)((Map)pcUiBotModel.getPageData().get((Object)schema)), (DigiwinAtmcBacklogDetail)digiwinAtmcBacklogDetail, (ApiRequest)apiRequest, (Boolean)false, (Boolean)false);
                }
                mobileLayout.setType(mobileComponent.returnComponentType());
                mobileLayout.setSchema(schema);
                mobilePageData.put((Object)schema, (Object)mobileComponent);
                mobileLayouts.add(mobileLayout);
                ModuleUtils.addEmptyArea(mobileLayouts, (UiBotPageData)mobilePageData);
                continue;
            }
            if (type.equals(PcLayoutEnum.FORM_LIST.getValue())) {
                Map bizData = (Map)pcUiBotModel.getPageData().get((Object)pcLayout.getSchema());
                if (CollectionUtils.isEmpty((Map)bizData)) continue;
                headHasEdit = ModuleUtils.uibotFormListLayoutHasEdit((UiBotLayout)pcLayout);
                mobileComponent = ModuleUtils.buildFormList((UiBotLayout)pcLayout, (Map)bizData, (UiBotExecuteContext)pcUiBotModel.getExecuteContext(), (String)apiRequest.getLocale(), (String)"", (List)pcUiBotModel.getRules(), (Boolean)headHasEdit, (Boolean)true, (boolean)true, (String)apiRequest.getIamUserToken());
                mobileLayout.setType(mobileComponent.returnComponentType());
                mobileLayout.setSchema(schema);
                mobilePageData.put((Object)schema, (Object)mobileComponent);
                mobileLayouts.add(mobileLayout);
                continue;
            }
            if (!type.equals(PcLayoutEnum.ATHENA_TABLE.getValue())) continue;
            TaskDetailBizReport taskDetailBizReport = new TaskDetailBizReport(this.localeService);
            List bizDataList = (List)pcUiBotModel.getPageData().get((Object)schema);
            if (CollectionUtils.isEmpty((Collection)bizDataList) || CollectionUtils.isEmpty((Collection)(tableColumnDefinitionList = pcLayout.getColumnDefs()))) continue;
            List tableColumns = UiBotTableColumnDefinition.decomposeTableColumnDefinitions((List)tableColumnDefinitionList);
            List mobileRuleList = this.ruleService.findByRulePath(schema);
            List columnTagList = this.columnTagService.listColumnTagsByPath(schema);
            boolean taskInReadOnlyMode = apiRequest.getRawData().getBooleanValue("isTeamTask");
            if (!taskInReadOnlyMode && !CollectionUtils.isEmpty((Collection)(operations = pcLayout.getOperations()))) {
                LinkedList<AutoFillData> autoFillDataList = new LinkedList<AutoFillData>();
                String reportAtOnceName = this.localeService.getLanguageValue(locale, "\u4e00\u952e\u62a5\u5de5");
                for (int i = 0; i < operations.size(); ++i) {
                    String title = operations.getJSONObject(i).getString("title").trim();
                    if (!Objects.equals(title, reportAtOnceName)) continue;
                    autoFillDataList.add(AutoFillData.create((String)reportAtOnceName, (UiBotLayout)pcLayout, (Map)((Map)bizDataList.get(0)), Collections.emptyMap()));
                }
                if (!CollectionUtils.isEmpty(autoFillDataList)) {
                    AutoFill autoFill = new AutoFill();
                    autoFill.setData(autoFillDataList);
                    taskDetailBizReport.addMobileComponent(0, (MobileComponent)autoFill);
                }
            }
            operations = bizDataList.iterator();
            while (operations.hasNext()) {
                Map bizData = (Map)operations.next();
                if ("sch_manualAssignment".equalsIgnoreCase(digiwinAtmcBacklogDetail.getTmActivityId()) && "systemCloudHouseKeeper_userProject".equalsIgnoreCase(digiwinAtmcBacklogDetail.getTmTaskId())) {
                    String taskNo = bizData.get("task_no").toString();
                    String projectNo = bizData.get("project_no").toString();
                    List taskStatusList = this.digiwinEspProxyService.getTaskPiscInfo(apiRequest.getIamUserToken(), projectNo, taskNo, apiRequest.getTenantId(), apiRequest.getLocale());
                    if (CollUtil.isNotEmpty((Collection)taskStatusList)) {
                        boolean b = taskStatusList.stream().allMatch(a -> a.equalsIgnoreCase("30"));
                        pcUiBotModel.getVariableMaps().put("isReportableWork", b);
                    }
                    JSONArray jsonArray = new JSONArray();
                    JSONObject jsonObject1 = new JSONObject();
                    jsonObject1.put("variableId", (Object)"overdue_report");
                    JSONObject jsonObject2 = new JSONObject();
                    jsonObject2.put("variableId", (Object)"overdue_report_day");
                    jsonArray.add((Object)jsonObject1);
                    jsonArray.add((Object)jsonObject2);
                    List mechanismVariableList = this.digiwinKnowledgeMapsProxyService.getMechanismVariableList(apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale(), jsonArray);
                    if (CollUtil.isNotEmpty((Collection)mechanismVariableList)) {
                        for (Map map : mechanismVariableList) {
                            if ("overdue_report".equalsIgnoreCase(map.get("variableId").toString())) {
                                pcUiBotModel.getVariableMaps().put("overdue_report", map.get("result"));
                            }
                            if (!"overdue_report_day".equalsIgnoreCase(map.get("variableId").toString())) continue;
                            pcUiBotModel.getVariableMaps().put("overdue_report_day", map.get("result"));
                        }
                    }
                    pcUiBotModel.getVariableMaps().put("is_attachment", bizData.get("is_attachment"));
                    pcUiBotModel.getVariableMaps().put("plan_finish_date", bizData.get("plan_finish_date"));
                    mobileUiBotModel.getPageData().put((Object)"task_info", (Object)pcUiBotModel.getVariableMaps());
                    mobileUiBotModel.setRawUiBotPageData(mobileUiBotModel.getPageData());
                    tableColumns.forEach(column -> {
                        if (Lists.newArrayList((Object[])new String[]{"project_no", "project_name", "project_leader_name", "attachment_remark"}).contains(column.getSchema())) {
                            column.setEditable(Boolean.valueOf(false));
                        }
                    });
                }
                taskDetailBizReport.addMobileComponentsByColumnAndBizData(locale, tableColumns, pcUiBotModel, bizData, digiwinAtmcBacklogDetail, mobileRuleList, columnTagList, apiRequest);
            }
            mobileUiBotModel.getLayout().addAll(taskDetailBizReport.getActualLayoutList());
            mobileUiBotModel.getPageData().putAll((Map)taskDetailBizReport);
            mobileUiBotModel.setCustomGroup();
        }
        String bizDataSchema = pcUiBotModel.searchBizDataSchema();
        Object bizData = pcUiBotModel.getPageData().get((Object)bizDataSchema);
        if (CollectionUtils.isEmpty((Collection)pcUiBotModel.getActions())) {
            return this.buildEmptyContentModel(locale, mobileUiBotModel);
        }
        if (bizData instanceof Collection ? CollectionUtils.isEmpty((Collection)((Collection)bizData)) : (bizData instanceof Map ? CollectionUtils.isEmpty((Map)((Map)bizData)) : Objects.isNull(bizData))) {
            return this.buildEmptyContentModel(locale, mobileUiBotModel);
        }
        List uiBotActions = pcUiBotModel.getActions();
        BottomButtonList bottomButtonList = new BottomButtonList();
        UiBotModel pageSettingModel = oldPageSetting.getPageModel();
        String bottomButtonDataSchema = pageSettingModel.getLayout().stream().filter(layout -> layout.getType().equalsIgnoreCase("BOTTOM_BUTTON")).findFirst().orElse(new UiBotLayout()).getSchema();
        UiBotPageData pageData = pageSettingModel.getPageData();
        JSONArray bottomButtonDataArray = (JSONArray)JSON.toJSON(pageData.get(bottomButtonDataSchema));
        if (CollectionUtils.isEmpty((Collection)bottomButtonDataArray)) {
            for (UiBotAction uiBotAction : uiBotActions) {
                BottomButtonDigiwinAthena bottomButton = BottomButtonDigiwinAthena.create((UiBotAction)uiBotAction, (String)bizDataSchema, (Object)bizData, null, (Action)new Action(ActionTypeEnum.CALL_API.getValue()));
                Object oldRawData = bottomButton.getAction().getRawData();
                if (oldRawData instanceof ButtonRawData) {
                    ButtonRawData oldBtnRawData = (ButtonRawData)oldRawData;
                    oldBtnRawData.setMobileLayoutType(MobileLayoutTypeEnum.SINGLE_PATTERN_LAYOUT);
                }
                bottomButtonList.add((Object)bottomButton);
            }
        }
        bottomButtonList.sort(Comparator.comparing(Button::getType).reversed());
        UiBotLayout bottomButtonLayout = new UiBotLayout();
        bottomButtonLayout.setType("BOTTOM_BUTTON");
        bottomButtonLayout.setSchema("bottomButtons");
        mobilePageData.put((Object)"bottomButtons", (Object)bottomButtonList);
        mobileLayouts.add(bottomButtonLayout);
        mobileUiBotModel.setPageBackgroudColor(BackgroundColorEnum.APP_MAIN_GREY.getValue());
        if (digiwinAtmcBacklogDetail.backlogHasReassignData()) {
            List buttons = mobileUiBotModel.getAppbarButtonList();
            HashMap<String, String> buttonActionRawData = new HashMap<String, String>(digiwinAtmcBacklogDetail.getReassign());
            buttonActionRawData.put("appCode", digiwinAtmcBacklogDetail.getAppCode());
            buttonActionRawData.put("backlogDetail", (String)digiwinAtmcBacklogDetail);
            buttons.add(Button.createApprovalReassign((String)(digiwinAtmcBacklogDetail.getId() + ""), buttonActionRawData, (String)apiRequest.getLocale(), (String)"TASK", (Integer)59096));
        }
        return this.buildEmptyContentModel(locale, mobileUiBotModel);
    }

    private UiBotModel buildEmptyContentModel(String locale, UiBotModel mobileUiBotModel) {
        boolean existOther = mobileUiBotModel.getLayout().stream().anyMatch(layout -> !"BLANK_AREA".equals(layout.getType()) && !"TITLE_BODY".equals(layout.getType()));
        if (existOther) {
            return mobileUiBotModel;
        }
        UiBotModel empty = UiBotModel.createEmptyComponent((String)this.localeService.getLanguageValue(locale, "\u6682\u65e0\u6570\u636e"), (boolean)false, null);
        mobileUiBotModel.getLayout().addAll(empty.getLayout());
        mobileUiBotModel.getPageData().putAll((Map)empty.getPageData());
        return mobileUiBotModel;
    }

    public UiBotModel buildDoublePatternModel(ApiRequest apiRequest, PageSetting oldPageSetting, LayoutGeneratorServiceResult layoutGeneratorServiceResult, UiBotModel pcUiBotModel, DigiwinAtmcBacklogDetail digiwinAtmcBacklogDetail, List<DigiwinAtmcTaskProgress> digiwinAtmcTaskProgressList, List<DigiwinReassignReport> reassignReportList) {
        List pcUiBotModelLayouts = pcUiBotModel.getLayout();
        ArrayList<UiBotLayout> uiBotLayouts = new ArrayList<UiBotLayout>(pcUiBotModelLayouts.size());
        UiBotModel uiBotModel = new UiBotModel(uiBotLayouts);
        UiBotPageData pageData = new UiBotPageData();
        Integer patternType = this.judgePatternType(pcUiBotModel);
        UiBotLayout tabScrollLayout = new UiBotLayout();
        tabScrollLayout.setType("TAB_SCROLL_CONTAINER");
        tabScrollLayout.setSchema(TABSCROLL_SCHEMA);
        TabScrollContainer tabScrollContainer = new TabScrollContainer();
        List headArea = tabScrollContainer.getHeadArea();
        List bodyArea = tabScrollContainer.getBodyArea();
        Boolean hasTitle = true;
        if (!ModuleUtils.uibotIsNotEmpty((UiBotModel)pcUiBotModel).booleanValue()) {
            bodyArea.add(CustomTabContentContainer.emptyContainer((String)apiRequest.getLocale()));
        } else {
            for (UiBotLayout pcUiBotModelLayout : pcUiBotModelLayouts) {
                CustomTabContentContainer container;
                String type = pcUiBotModelLayout.getType();
                String schema = pcUiBotModelLayout.getSchema();
                UiBotLayout uiBotLayout = new UiBotLayout();
                if (type.equals(PcModuleEnum.ACTIVITY_TITLE.getValue())) {
                    hasTitle = false;
                    uiBotLayout.setType("TITLE_BODY");
                    uiBotLayout.setSchema(schema);
                    pageData.put((Object)schema, (Object)ModuleUtils.buildTitle((UiBotModel)pcUiBotModel, (Map)((Map)pcUiBotModel.getPageData().get((Object)schema)), (DigiwinAtmcBacklogDetail)digiwinAtmcBacklogDetail, (ApiRequest)apiRequest, (Boolean)false, (Boolean)false));
                    uiBotLayouts.add(uiBotLayout);
                    ModuleUtils.addEmptyArea(uiBotLayouts, (UiBotPageData)pageData);
                    continue;
                }
                if (type.equals(PcModuleEnum.DELIVERY_REPLY_TITLE.getValue())) {
                    uiBotLayout.setType("TITLE_BODY");
                    uiBotLayout.setSchema(schema);
                    pageData.put((Object)schema, (Object)ModuleUtils.buildTitle((UiBotModel)pcUiBotModel, (Map)((Map)pcUiBotModel.getPageData().get((Object)schema)), (DigiwinAtmcBacklogDetail)digiwinAtmcBacklogDetail, (ApiRequest)apiRequest, (Boolean)true, (Boolean)false));
                    uiBotLayouts.add(uiBotLayout);
                    if (!hasTitle.booleanValue()) continue;
                    hasTitle = false;
                    ModuleUtils.addEmptyArea(uiBotLayouts, (UiBotPageData)pageData);
                    continue;
                }
                if (type.equals(PcModuleEnum.DELIVERY_REPLY_DESCRIPTION.getValue())) {
                    uiBotLayout.setType("CUSTOM_GROUP");
                    uiBotLayout.setSchema(TITLE_REPLY_DATA);
                    pageData.put((Object)TITLE_REPLY_DATA, (Object)ModuleUtils.buildReplyTitle((UiBotLayout)pcUiBotModelLayout, (Map)((Map)pcUiBotModel.getPageData().get((Object)schema)), (ApiRequest)apiRequest));
                    uiBotLayouts.add(uiBotLayout);
                    ModuleUtils.addEmptyArea(uiBotLayouts, (UiBotPageData)pageData);
                    continue;
                }
                if (type.equals(PcModuleEnum.APPROVAL_DESCRIPTION.getValue())) {
                    Boolean headHasEdit = ModuleUtils.uibotFormListLayoutHasEdit((UiBotLayout)pcUiBotModelLayout);
                    container = new CustomTabContentContainer();
                    container.setContentCmptType("CUSTOM_GROUP");
                    container.setData((Object)ModuleUtils.buildFormList((UiBotLayout)pcUiBotModelLayout, (Map)((Map)pcUiBotModel.getPageData().get((Object)schema)), (UiBotExecuteContext)pcUiBotModel.getExecuteContext(), (String)apiRequest.getLocale(), (String)"", (List)pcUiBotModel.getRules(), (Boolean)headHasEdit, (Boolean)true, (boolean)true, (String)apiRequest.getIamUserToken()));
                    headArea.add(container);
                    if (!headHasEdit.booleanValue()) continue;
                    BottomButtonList buttonList = new BottomButtonList();
                    CustomTabContentContainer buttonContainer = new CustomTabContentContainer();
                    buttonContainer.setContentCmptType("BOTTOM_BUTTON");
                    HashMap<String, Object> rawData = new HashMap<String, Object>();
                    rawData.put("dataId", apiRequest.getDataId());
                    rawData.put("tmTaskId", apiRequest.getExtraParameter().getTmTaskId());
                    rawData.put("tmActivityId", apiRequest.getExtraParameter().getTmActivityId());
                    rawData.put("rawData", apiRequest.getRawData());
                    rawData.put("isTabs", false);
                    buttonList.add((Object)BottomButtonDigiwinAthena.createNextStepButton((String)apiRequest.getLocale(), rawData));
                    buttonContainer.setData((Object)buttonList);
                    break;
                }
                if (!type.equals(PcModuleEnum.CONTENT_QUERY_BUTTON.getValue())) continue;
                container = new CustomTabContentContainer();
                container.setContentCmptType("CUSTOM_TAB_CONTROLLER");
                container.setData((Object)ModuleUtils.buildTabs((UiBotModel)pcUiBotModel, (ApiRequest)apiRequest, (DigiwinAtdmProxyService)this.digiwinAtdmProxyService));
                bodyArea.add(container);
                break;
            }
        }
        uiBotLayouts.add(tabScrollLayout);
        pageData.put((Object)TABSCROLL_SCHEMA, (Object)tabScrollContainer);
        uiBotModel.setPageData(pageData);
        uiBotModel = this.buildSlip(apiRequest, pcUiBotModel, uiBotModel, digiwinAtmcBacklogDetail);
        if (digiwinAtmcBacklogDetail.backlogHasReassignData()) {
            List buttons = uiBotModel.getAppbarButtonList();
            HashMap<String, String> buttonActionRawData = new HashMap<String, String>(digiwinAtmcBacklogDetail.getReassign());
            buttonActionRawData.put("appCode", digiwinAtmcBacklogDetail.getAppCode());
            buttonActionRawData.put("backlogDetail", (String)digiwinAtmcBacklogDetail);
            buttons.add(Button.createApprovalReassign((String)(digiwinAtmcBacklogDetail.getId() + ""), buttonActionRawData, (String)apiRequest.getLocale(), (String)"TASK", (Integer)59096));
        }
        List layouts = uiBotModel.getLayout();
        Map commonRawData = uiBotModel.getCommonRawData();
        commonRawData.put("layout", ModuleUtils.getAthenaTable((List)pcUiBotModelLayouts));
        commonRawData.put("pageData", pcUiBotModel.getPageData());
        commonRawData.put("executeContext", pcUiBotModel.getExecuteContext());
        commonRawData.put("rules", pcUiBotModel.getRules());
        commonRawData.put("action", ModuleUtils.getDefaultAction((UiBotModel)pcUiBotModel));
        uiBotModel.setPageBackgroudColor(BackgroundColorEnum.APP_MAIN_GREY.getValue());
        return uiBotModel;
    }

    private Integer judgePatternType(UiBotModel pcUiBotModel) {
        ArrayList<String> tableTargetLayoutTypeList = new ArrayList<String>();
        tableTargetLayoutTypeList.add(PcLayoutEnum.ATHENA_TABLE.getValue());
        ArrayList<String> tableParentLayoutTypeList = new ArrayList<String>();
        tableParentLayoutTypeList.add(PcLayoutEnum.FORM_LIST.getValue());
        UiBotModel tableUiBotModel = pcUiBotModel.searchPcTargetModel(tableTargetLayoutTypeList, tableParentLayoutTypeList, false);
        if (!CollectionUtils.isEmpty((Collection)tableUiBotModel.getLayout())) {
            List layouts = tableUiBotModel.getLayout();
            UiBotPageData pageData = tableUiBotModel.getPageData();
            for (UiBotLayout layout : layouts) {
                Object bizData = new Object();
                if (layout.getSchema().contains(".")) {
                    String[] schemas = layout.getSchema().split("\\.");
                    Map map = new HashMap();
                    for (String tableSchema : schemas) {
                        if (map.get(tableSchema) instanceof List) {
                            bizData = map.get(tableSchema);
                            continue;
                        }
                        if (map.get(tableSchema) instanceof Map) {
                            map = (Map)map.get(tableSchema);
                            continue;
                        }
                        if (!(pageData.get((Object)tableSchema) instanceof Map)) continue;
                        map = (Map)pageData.get((Object)tableSchema);
                    }
                } else {
                    bizData = pageData.get((Object)layout.getSchema());
                }
                if (!(bizData instanceof List)) continue;
                if (((List)bizData).size() > 2) {
                    return PATTERN_TYPE_DOUBLE;
                }
                UiBotLayout uiBotLayout = UiBotModel.getContentQueryButtonLayout((List)pcUiBotModel.getLayout());
                if (uiBotLayout != null) {
                    List queryButtons = uiBotLayout.getQueryButtons();
                    if (queryButtons.size() > 1) {
                        return PATTERN_TYPE_DOUBLE;
                    }
                    if (queryButtons.get(0) != null && ((UiBotQueryButton)queryButtons.get(0)).getRowSize() > 1L) {
                        return PATTERN_TYPE_DOUBLE;
                    }
                    return PATTERN_TYPE_SINGLE;
                }
                return PATTERN_TYPE_SINGLE;
            }
        } else {
            return PATTERN_TYPE_SINGLE;
        }
        return PATTERN_TYPE_SINGLE;
    }

    private UiBotModel buildSlip(ApiRequest apiRequest, UiBotModel pcUiBotModel, UiBotModel model, DigiwinAtmcBacklogDetail digiwinAtmcBacklogDetail) {
        String athenaTaskName;
        if (null != digiwinAtmcBacklogDetail.getBpmActivityId()) {
            model.setDataId(digiwinAtmcBacklogDetail.getBpmActivityId());
        }
        if (!StringUtils.hasLength((String)(athenaTaskName = Optional.ofNullable(digiwinAtmcBacklogDetail).map(DigiwinAtmcBacklogDetail::getName).orElse("")))) {
            athenaTaskName = String.valueOf(pcUiBotModel.getPageData().getUiBotActivity().get("name"));
        }
        UiBotSlip slip = new UiBotSlip();
        slip.setSlipType(Integer.valueOf(SlipTypeEnum.LEFT_AND_RIGHT_SLIP.getValue()));
        SlipConfig slipConfig = new SlipConfig();
        slipConfig.setLeft(SlipConfigLeft.build((String)apiRequest.getLocale(), (String)athenaTaskName));
        SlipConfigLeft left = slipConfig.getLeft();
        List projectPerformers = this.digiwinAtmcProxyService.getPerformerListByBackLogId(digiwinAtmcBacklogDetail.getBacklogId(), apiRequest.getIamUserToken(), apiRequest.getLocale(), apiRequest.getTenantId());
        EocPersonResponse eocPersonResponse = this.digiwinEocProxyService.getSimplePersonList(apiRequest.getIamUserToken(), 9999, 1, "");
        SlipConfigLeft.setPersonList((SlipConfigLeft)left, (List)projectPerformers, (EocPersonResponse)eocPersonResponse);
        SlipConfigRight right = new SlipConfigRight();
        right.setTitle(LocaleUtil.getMobileTextByKey((String)apiRequest.getLocale(), (String)"\u8f85\u52a9\u8d44\u8baf"));
        LeftHeader header = new LeftHeader();
        header.setShowHeader(Boolean.valueOf(true));
        SlipTitle leftSlipTitle = new SlipTitle();
        leftSlipTitle.setContent(athenaTaskName);
        leftSlipTitle.setPrefix(LocaleUtil.getMobileTextByKey((String)apiRequest.getLocale(), (String)"\u6839\u636e\u60a8\u5f53\u524d\u4e8b\u52a1"));
        leftSlipTitle.setSuffix(LocaleUtil.getMobileTextByKey((String)apiRequest.getLocale(), (String)"\u7684\u5904\u7406"));
        ArrayList<String> newLine = new ArrayList<String>(1);
        newLine.add(LocaleUtil.getMobileTextByKey((String)apiRequest.getLocale(), (String)"\u7cfb\u7edf\u5339\u914d\u4e86\u4ee5\u4e0b\u8d44\u8baf"));
        leftSlipTitle.setNewLine(newLine);
        header.setSubTitle(leftSlipTitle);
        right.setHeader(header);
        LeftFooter leftFooter = new LeftFooter();
        leftFooter.setTitle(LocaleUtil.getMobileTextByKey((String)apiRequest.getLocale(), (String)"\u8d44\u8baf\u4e0d\u591f\uff0c\u60f3\u77e5\u9053\u66f4\u591a\uff1f"));
        leftFooter.setShowFooter(Boolean.valueOf(true));
        ArrayList<ComponentBox> componentBoxes = new ArrayList<ComponentBox>(1);
        ComponentBox componentBox = new ComponentBox();
        componentBox.setData((Object)LocaleUtil.getMobileTextByKey((String)apiRequest.getLocale(), (String)"\u641c\u7d22\u4f60\u60f3\u77e5\u9053\u7684\u5185\u5bb9"));
        componentBox.setPosition(Integer.valueOf(0));
        SkipConfig skipConfig = new SkipConfig();
        skipConfig.setJumpUrl("/mobile/v1/search/globalSearch");
        skipConfig.setRequestType(Integer.valueOf(2));
        componentBox.setJumpConfig(skipConfig);
        componentBox.setComponentType("SEARCH_BOX");
        ArrayList<SearchCategory> searchCategories = new ArrayList<SearchCategory>(4);
        searchCategories.add(SearchCategory.build((String)"all", (String)LocaleUtil.getMobileTextByKey((String)apiRequest.getLocale(), (String)"\u5168\u90e8")));
        searchCategories.add(SearchCategory.build((String)"all", (String)LocaleUtil.getMobileTextByKey((String)apiRequest.getLocale(), (String)"\u9879\u76ee")));
        searchCategories.add(SearchCategory.build((String)"all", (String)LocaleUtil.getMobileTextByKey((String)apiRequest.getLocale(), (String)"\u4efb\u52a1")));
        searchCategories.add(SearchCategory.build((String)"all", (String)LocaleUtil.getMobileTextByKey((String)apiRequest.getLocale(), (String)"\u95ee\u9898")));
        componentBox.setSearchCategories(searchCategories);
        componentBoxes.add(componentBox);
        leftFooter.setComponentBox(componentBoxes);
        right.setFooter(leftFooter);
        LeftBody leftBody = new LeftBody();
        leftBody.setShowBody(Boolean.valueOf(true));
        SkipConfig jumpConfig = new SkipConfig();
        jumpConfig.setJumpUrl("/mobile/v1/uibot/model");
        jumpConfig.setPageId(PageSettingIdPresetEnum.MOBILE_LEFT_SLIP.toString());
        jumpConfig.setRequestType(Integer.valueOf(2));
        leftBody.setJumpConfig(jumpConfig);
        right.setBody(leftBody);
        slipConfig.setRight(right);
        slip.setSlipConfig(slipConfig);
        model.setSlip(slip);
        return model;
    }
}

