/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.rule.relation;

import com.digiwin.mobile.mobileuibot.core.rule.Rule;
import com.digiwin.mobile.mobileuibot.core.rule.RuleCategoryEnum;
import com.digiwin.mobile.mobileuibot.core.rule.RuleSubcategoryEnum;
import com.digiwin.mobile.mobileuibot.core.rule.relation.AddOperator;
import com.digiwin.mobile.mobileuibot.core.rule.relation.CommonRule;
import com.digiwin.mobile.mobileuibot.core.rule.relation.CommonRuleCondition;
import com.digiwin.mobile.mobileuibot.core.rule.relation.RelationRuleDate;
import com.digiwin.mobile.mobileuibot.core.rule.relation.RelationRuleText;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.util.Assert;

public class RelationRule
implements Serializable {
    private static final long serialVersionUID = 976539621081752432L;
    private List<RelationRuleDate> dateRuleList = new ArrayList();
    private List<RelationRuleText> textRuleList = new ArrayList();
    private List<CommonRule> ruleList = new ArrayList();

    public static RelationRule create(Rule rule, Map<String, Object> bizData) {
        Assert.notNull((Object)rule, (String)"rule must not null!");
        Assert.isTrue((boolean)rule.getCategory().equalsIgnoreCase(RuleCategoryEnum.RELATION.getCategory()), (String)"rule must be relation category!");
        RelationRule relationRule = new RelationRule();
        if (rule.getSubcategory().equalsIgnoreCase(RuleSubcategoryEnum.DATE.getSubcategory())) {
            relationRule.addRelationRuleDate(RelationRuleDate.create(bizData, (Rule)rule));
        } else if (rule.getSubcategory().equalsIgnoreCase(RuleSubcategoryEnum.TEXT.getSubcategory())) {
            relationRule.addRelationRuleText(RelationRuleText.create(bizData, (Rule)rule));
        }
        return relationRule;
    }

    public static RelationRule createApcWorkShopOnlinePlanStartDate(String dateSchema, String durationSchema, Integer durationType, String targetSchema) {
        RelationRule relationRule = new RelationRule();
        ArrayList<CommonRule> ruleList = new ArrayList<CommonRule>(1);
        CommonRule rule = new CommonRule();
        rule.setCondition(CommonRuleCondition.CONDITION_CHANGE_NOT_EMPTY.getType());
        rule.setAddOperator(new AddOperator(dateSchema, durationSchema, targetSchema, durationType, targetSchema));
        rule.setTargetSchema(targetSchema);
        ruleList.add(rule);
        relationRule.setRuleList(ruleList);
        return relationRule;
    }

    public static void buildTbdsRule(List<CommonRule> commonRules) {
        CommonRule commonRule = new CommonRule();
        commonRule.setCondition(CommonRuleCondition.CONDITION_CHANGE_NOT_EMPTY.getType());
        commonRule.setAddOperator(new AddOperator().setStartSchema("actual_start_time").setDurationSchema("actual_work_hours").setFinishSchema("actual_end_time").setDurationType(Integer.valueOf(2)).setTargetSchema("actual_work_hours"));
        commonRule.setTargetSchema("actual_work_hours");
        commonRule.setTargetHidden(null);
        commonRule.setTargetEnable(Boolean.valueOf(true));
        commonRules.add(commonRule);
    }

    public void addRelationRuleDate(RelationRuleDate relationRuleDate) {
        if (relationRuleDate != null) {
            this.dateRuleList.add(relationRuleDate);
        }
    }

    public void addRelationRuleText(RelationRuleText relationRuleText) {
        if (relationRuleText != null) {
            this.textRuleList.add(relationRuleText);
        }
    }

    public void addCommonRule(CommonRule commonRule) {
        if (commonRule != null) {
            this.ruleList.add(commonRule);
        }
    }

    public List<RelationRuleDate> getDateRuleList() {
        return this.dateRuleList;
    }

    public List<RelationRuleText> getTextRuleList() {
        return this.textRuleList;
    }

    public List<CommonRule> getRuleList() {
        return this.ruleList;
    }

    public void setDateRuleList(List<RelationRuleDate> dateRuleList) {
        this.dateRuleList = dateRuleList;
    }

    public void setTextRuleList(List<RelationRuleText> textRuleList) {
        this.textRuleList = textRuleList;
    }

    public void setRuleList(List<CommonRule> ruleList) {
        this.ruleList = ruleList;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RelationRule)) {
            return false;
        }
        RelationRule other = (RelationRule)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        List this$dateRuleList = this.getDateRuleList();
        List other$dateRuleList = other.getDateRuleList();
        if (this$dateRuleList == null ? other$dateRuleList != null : !((Object)this$dateRuleList).equals(other$dateRuleList)) {
            return false;
        }
        List this$textRuleList = this.getTextRuleList();
        List other$textRuleList = other.getTextRuleList();
        if (this$textRuleList == null ? other$textRuleList != null : !((Object)this$textRuleList).equals(other$textRuleList)) {
            return false;
        }
        List this$ruleList = this.getRuleList();
        List other$ruleList = other.getRuleList();
        return !(this$ruleList == null ? other$ruleList != null : !((Object)this$ruleList).equals(other$ruleList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RelationRule;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List $dateRuleList = this.getDateRuleList();
        result = result * 59 + ($dateRuleList == null ? 43 : ((Object)$dateRuleList).hashCode());
        List $textRuleList = this.getTextRuleList();
        result = result * 59 + ($textRuleList == null ? 43 : ((Object)$textRuleList).hashCode());
        List $ruleList = this.getRuleList();
        result = result * 59 + ($ruleList == null ? 43 : ((Object)$ruleList).hashCode());
        return result;
    }

    public String toString() {
        return "RelationRule(dateRuleList=" + this.getDateRuleList() + ", textRuleList=" + this.getTextRuleList() + ", ruleList=" + this.getRuleList() + ")";
    }
}

