/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.strategy.compdatabuild;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.file.FileUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.basic.BlankArea;
import com.digiwin.mobile.mobileuibot.core.component.basic.Empty;
import com.digiwin.mobile.mobileuibot.core.component.button.CustomButton;
import com.digiwin.mobile.mobileuibot.core.component.index.TodoList;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtab.CustomTabContentContainer;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtabcontroller.CustomTabControllerItem;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtabcontroller.CustomTabControllerItemEmptyModeEnum;
import com.digiwin.mobile.mobileuibot.core.componentsetting.ComponentSettingRequestIdEnum;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.core.strategy.compdatabuild.UiBotCompDataBuildStrategy;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildMyTaskListStrategy;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;

@Component(value="uiBotCompDataBuildIndexWorkspaceTodoListStrategy")
public class UiBotCompDataBuildIndexWorkspaceTodoListStrategy
implements UiBotCompDataBuildStrategy<CustomTabControllerItem> {
    private static final Logger logger = LoggerFactory.getLogger(UiBotCompDataBuildIndexWorkspaceTodoListStrategy.class);
    @Autowired
    private UiBotModelBuildMyTaskListStrategy uiBotModelBuildMyTaskListStrategy;

    public String getTypeByRequestId() {
        return ComponentSettingRequestIdEnum.INDEX_MY_WORKSPACE_TODO_LIST.getReuqestId();
    }

    public CustomTabControllerItem buildComponentData(ApiRequest apiRequest) throws IOException {
        StopWatch stopWatch = new StopWatch("BuildIndexWorkspaceTodoList");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        CustomTabControllerItem customTabControllerItem = useMockData == false && modelTypeShow == false ? this.doActually(apiRequest, stopWatch) : this.doMockData(apiRequest);
        logger.debug(stopWatch.prettyPrint());
        return customTabControllerItem;
    }

    private CustomTabControllerItem doActually(ApiRequest apiRequest, StopWatch stopWatch) {
        ArrayList<CustomTabContentContainer> content = new ArrayList<CustomTabContentContainer>();
        CustomTabContentContainer taskContent = new CustomTabContentContainer();
        CustomTabContentContainer emptyContent = new CustomTabContentContainer();
        CustomTabContentContainer customButtonContent = new CustomTabContentContainer();
        CustomTabContentContainer blankAreaContent = new CustomTabContentContainer();
        int actualTaskSummaryCount = 0;
        boolean isSearched = false;
        TodoList todoList = this.uiBotModelBuildMyTaskListStrategy.doActually(apiRequest);
        List taskSummaryList = todoList.getTodoList();
        actualTaskSummaryCount = taskSummaryList.size();
        if (0 == actualTaskSummaryCount) {
            emptyContent.setContentCmptType("EMPTY");
            emptyContent.setData((Object)Empty.create((String)LocaleUtil.getMobileTextByKey((String)apiRequest.getLocale(), (String)"\u6682\u65f6\u6ca1\u6709\u4efb\u52a1"), (boolean)true, (Integer)400, (Integer)180, (String)"home_tab_no_work_item_prompt"));
            blankAreaContent.setContentCmptType("BLANK_AREA");
            blankAreaContent.setData((Object)BlankArea.create((Integer)32, (Double)1.0));
            customButtonContent.setContentCmptType("CUSTOM_BUTTON");
            Action createTaskAction = new Action();
            createTaskAction.setJumpPageId("MOBILE_MANUAL_TASK_DETAIL_APPROVAL_AGREE");
            createTaskAction.setJumpPageTitle(LocaleUtil.getMobileTextByKey((String)apiRequest.getLocale(), (String)"\u65b0\u5efa\u4efb\u52a1"));
            createTaskAction.setRequestUrl(AppContext.getBaseUrl() + "/mobile/v1/uibot/model");
            createTaskAction.setScreenShotSwitch(Boolean.valueOf(false));
            createTaskAction.setType(ActionTypeEnum.OPEN_NEW_PAGE.getValue());
            customButtonContent.setData((Object)CustomButton.create((String)"#6667AB", (String)"#FFFFFF", (String)("+ " + LocaleUtil.getMobileTextByKey((String)apiRequest.getLocale(), (String)"\u65b0\u5efa\u4efb\u52a1")), (String)"#FFFFFF", (Integer)28, (Integer)240, (Integer)64, (Action)createTaskAction));
            content.add(emptyContent);
            content.add(blankAreaContent);
            content.add(customButtonContent);
            content.add(blankAreaContent);
        } else {
            taskSummaryList.forEach(taskSummary -> {
                if (taskSummary.getAction() != null) {
                    taskSummary.getAction().setRefreshPageId(PageSettingIdPresetEnum.FLASH_MY_TODO.toString());
                }
            });
            taskContent.setContentCmptType("TODO_LIST");
            taskContent.setData((Object)taskSummaryList);
            taskContent.setFilterList(todoList.getFilterList());
            taskContent.setFilterIdList(todoList.getFilterIdList());
            taskContent.setGroupFilterList(todoList.getGroupFilterList());
            taskContent.setGroupFilterIdList(todoList.getGroupFilterIdList());
            taskContent.setCommonFilter(todoList.getCommonFilter());
            taskContent.setSeniorFilter(todoList.getSeniorFilter());
            taskContent.setIsUseSeniorFilter(todoList.getIsUseSeniorFilter());
            taskContent.setSortFilter(todoList.getSortFilter());
            taskContent.setShowEocSwitch(todoList.getShowEocSwitch());
            taskContent.setShowHandledCardSwitch(todoList.getShowHandledCardSwitch());
            taskContent.setSearchIdList(todoList.getSearchIdList());
            if (!CollectionUtils.isEmpty((Collection)todoList.getFilterIdList()) || !CollectionUtils.isEmpty((Collection)todoList.getSearchIdList())) {
                isSearched = true;
            }
            taskContent.setSearchUrl(todoList.getSearchUrl());
            taskContent.setQueryParam(todoList.getQueryParam());
            content.add(taskContent);
        }
        CustomTabControllerItem item = CustomTabControllerItem.createAsyncData((String)(LocaleUtil.getMobileTextByKey((String)apiRequest.getLocale(), (String)"\u6211\u7684\u4efb\u52a1") + "(" + actualTaskSummaryCount + ")"), content, (CustomTabControllerItemEmptyModeEnum)CustomTabControllerItemEmptyModeEnum.EMPTY_DATA_AND_UI_WITH_HIDE_MORE, (Boolean)isSearched);
        return item;
    }

    private CustomTabControllerItem doMockData(ApiRequest apiRequest) {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        CustomTabControllerItem uiBotModel = null;
        String data = FileUtil.readText((String)"static/appstore-use/MyWorkSpaceCardTodoList.json");
        if (null != data && !data.isEmpty()) {
            uiBotModel = (CustomTabControllerItem)JsonUtil.jsonStringToObject((String)data, CustomTabControllerItem.class);
        }
        return uiBotModel;
    }
}

