/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.strategy.modelbuild;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.common.BackgroundColorEnum;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponentWrapper;
import com.digiwin.mobile.mobileuibot.core.component.MobileRenderMetaData;
import com.digiwin.mobile.mobileuibot.core.component.card.card.Card;
import com.digiwin.mobile.mobileuibot.core.component.list.ztbviewlist.CardListToTableRawData;
import com.digiwin.mobile.mobileuibot.core.component.table.Table;
import com.digiwin.mobile.mobileuibot.core.component.table.TableHiddenConfig;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotRenderData;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Component
public class UiBotModelBuildCardlistConvertTablePageStrategy
implements UiBotModelBuildStrategy {
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        Boolean useMockData = AppContext.getUseMockData();
        boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel = useMockData == false && !modelTypeShow ? this.doActually(pageSetting, apiRequest) : this.doMockData(pageSetting, apiRequest);
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest) {
        BaseMobileComponentWrapper tableWrapper;
        UiBotModel uiBotModel = UiBotModel.emptyUiBotModel();
        uiBotModel.setPageBackgroudColor(BackgroundColorEnum.APP_MAIN_GREY.getValue());
        if (ObjectUtils.isEmpty((Object)uiBotModel.getRenderData())) {
            uiBotModel.setRenderData(UiBotRenderData.createEmptyRenderData());
        }
        if ((tableWrapper = this.buildTableWrapper(apiRequest)) == null) {
            uiBotModel.getRenderData().addEmptyComponentToBody();
            return uiBotModel;
        }
        uiBotModel.getRenderData().addWrapperedComponentToBody(tableWrapper);
        uiBotModel.setRenderVersion(MobileRenderMetaData.RENDER_VERSION_2);
        return uiBotModel;
    }

    private BaseMobileComponentWrapper<BaseMobileComponent> buildTableWrapper(ApiRequest apiRequest) {
        CardListToTableRawData tableRawData = (CardListToTableRawData)JsonUtil.objectToJavaObject((Object)apiRequest.getRawData(), CardListToTableRawData.class);
        if (tableRawData == null) {
            return null;
        }
        Card.DesignerRawCard.TableConfig tableConfig = tableRawData.getTableConfig();
        if (tableConfig == null || CollectionUtils.isEmpty((Collection)tableConfig.getContent())) {
            return null;
        }
        Table table = new Table();
        table.setName(tableConfig.getName());
        table.setColumnFreeze(tableConfig.getColumnFreeze());
        table.setTableHeader(Table.buildTableHeader((List)tableConfig.getContent(), (boolean)tableConfig.getTableFixed()));
        table.setRows(Table.buildTableRows((List)tableConfig.getContent(), (List)tableRawData.getDataList()));
        table.setDefaultLandscape(tableConfig.getDefaultLandscape());
        table.setIsLandscape(tableConfig.getIsLandscape());
        table.setHiddenConfig(this.buildTableHiddenConfig(apiRequest.getLocale()));
        return new BaseMobileComponentWrapper((BaseMobileComponent)table, "DW_TABLE");
    }

    private TableHiddenConfig buildTableHiddenConfig(String locale) {
        TableHiddenConfig tableHiddenConfig = new TableHiddenConfig();
        tableHiddenConfig.setHiddenExpandContent(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u67e5\u770b\u66f4\u591a"));
        tableHiddenConfig.setHiddenUnexpandContent(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u6536\u8d77"));
        return tableHiddenConfig;
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return null;
    }
}

